/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.util;

import com.mxgraph.util.mxRectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class mxGraphTransferable
implements Transferable,
UIResource,
Serializable {
    private static final long serialVersionUID = 5123819419918087664L;
    public static DataFlavor dataFlavor;
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    private static DataFlavor[] imageFlavors;
    protected Object[] cells;
    protected mxRectangle bounds;
    protected ImageIcon image;

    public mxGraphTransferable(Object[] cells, mxRectangle bounds) {
        this(cells, bounds, null);
    }

    public mxGraphTransferable(Object[] cells, mxRectangle bounds, ImageIcon image) {
        this.cells = cells;
        this.bounds = bounds;
        this.image = image;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public mxRectangle getBounds() {
        return this.bounds;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nRicher = richerFlavors != null ? richerFlavors.length : 0;
        int nHtml = this.isHtmlSupported() ? htmlFlavors.length : 0;
        int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
        int nString = this.isPlainSupported() ? stringFlavors.length : 0;
        int nImage = this.isImageSupported() ? stringFlavors.length : 0;
        int nFlavors = nRicher + nHtml + nPlain + nString + nImage;
        DataFlavor[] flavors = new DataFlavor[nFlavors];
        int nDone = 0;
        if (nRicher > 0) {
            System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
            nDone += nRicher;
        }
        if (nHtml > 0) {
            System.arraycopy(htmlFlavors, 0, flavors, nDone, nHtml);
            nDone += nHtml;
        }
        if (nPlain > 0) {
            System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
            nDone += nPlain;
        }
        if (nString > 0) {
            System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
            nDone += nString;
        }
        if (nImage > 0) {
            System.arraycopy(imageFlavors, 0, flavors, nDone, nImage);
            nDone += nImage;
        }
        return flavors;
    }

    protected DataFlavor[] getRicherFlavors() {
        return new DataFlavor[]{dataFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i] == null || !flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(flavor)) {
            return this.getRicherData(flavor);
        }
        if (this.isImageFlavor(flavor)) {
            if (this.image != null && this.image.getImage() instanceof RenderedImage) {
                if (flavor.equals(DataFlavor.imageFlavor)) {
                    return this.image.getImage();
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((Object)this.image.getImage()), "bmp", stream);
                return new ByteArrayInputStream(stream.toByteArray());
            }
        } else if (this.isHtmlFlavor(flavor)) {
            String data = this.getHtmlData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new ByteArrayInputStream(data.getBytes());
            }
        } else if (this.isPlainFlavor(flavor)) {
            String data = this.getPlainData();
            String string = data = data == null ? "" : data;
            if (String.class.equals(flavor.getRepresentationClass())) {
                return data;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new ByteArrayInputStream(data.getBytes());
            }
        } else if (this.isStringFlavor(flavor)) {
            String data = this.getPlainData();
            data = data == null ? "" : data;
            return data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected boolean isRicherFlavor(DataFlavor flavor) {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
        for (int i = 0; i < nFlavors; ++i) {
            if (!richerFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected boolean isHtmlFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = htmlFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHtmlSupported() {
        return false;
    }

    protected String getHtmlData() {
        return null;
    }

    protected boolean isImageFlavor(DataFlavor flavor) {
        int nFlavors = imageFlavors != null ? imageFlavors.length : 0;
        for (int i = 0; i < nFlavors; ++i) {
            if (!imageFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public boolean isImageSupported() {
        return this.image != null;
    }

    protected boolean isPlainFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = plainFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return false;
    }

    protected String getPlainData() {
        return null;
    }

    protected boolean isStringFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = stringFlavors;
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            mxGraphTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            mxGraphTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            mxGraphTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            mxGraphTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            mxGraphTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            mxGraphTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            mxGraphTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            mxGraphTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            imageFlavors = new DataFlavor[2];
            mxGraphTransferable.imageFlavors[0] = DataFlavor.imageFlavor;
            mxGraphTransferable.imageFlavors[1] = new DataFlavor("image/bmp");
        }
        catch (ClassNotFoundException cle) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
        try {
            dataFlavor = new DataFlavor("application/x-java-serialized-object; class=com.mxgraph.swing.util.mxGraphTransferable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

