/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.List;

public class mxEdgeStyle {
    public static mxEdgeStyleFunction EntityRelation = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxIGraphModel model = view.getGraph().getModel();
            double segment = mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_SEGMENT, mxConstants.ENTITY_SEGMENT) * state.view.getScale();
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            boolean isSourceLeft = false;
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            } else if (source != null) {
                int constraint = mxUtils.getPortConstraints(source, state, true, 0);
                if (constraint != 0) {
                    isSourceLeft = constraint == 1;
                } else {
                    mxGeometry sourceGeometry = model.getGeometry(source.cell);
                    if (sourceGeometry.isRelative()) {
                        isSourceLeft = sourceGeometry.getX() <= 0.5;
                    } else if (target != null) {
                        isSourceLeft = target.getX() + target.getWidth() < source.getX();
                    }
                }
            }
            boolean isTargetLeft = true;
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            } else if (target != null) {
                int constraint = mxUtils.getPortConstraints(target, state, false, 0);
                if (constraint != 0) {
                    isTargetLeft = constraint == 1;
                } else {
                    mxGeometry targetGeometry = model.getGeometry(target.cell);
                    if (targetGeometry.isRelative()) {
                        isTargetLeft = targetGeometry.getX() <= 0.5;
                    } else if (source != null) {
                        boolean bl = isTargetLeft = source.getX() + source.getWidth() < target.getX();
                    }
                }
            }
            if (source != null && target != null) {
                double x0 = isSourceLeft ? source.getX() : source.getX() + source.getWidth();
                double y0 = view.getRoutingCenterY(source);
                double xe = isTargetLeft ? target.getX() : target.getX() + target.getWidth();
                double ye = view.getRoutingCenterY(target);
                double seg = segment;
                double dx = isSourceLeft ? -seg : seg;
                mxPoint dep = new mxPoint(x0 + dx, y0);
                result.add(dep);
                dx = isTargetLeft ? -seg : seg;
                mxPoint arr = new mxPoint(xe + dx, ye);
                if (isSourceLeft == isTargetLeft) {
                    double x = isSourceLeft ? Math.min(x0, xe) - segment : Math.max(x0, xe) + segment;
                    result.add(new mxPoint(x, y0));
                    result.add(new mxPoint(x, ye));
                } else if (dep.getX() < arr.getX() == isSourceLeft) {
                    double midY = y0 + (ye - y0) / 2.0;
                    result.add(new mxPoint(dep.getX(), midY));
                    result.add(new mxPoint(arr.getX(), midY));
                }
                result.add(arr);
            }
        }
    };
    public static mxEdgeStyleFunction Loop = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            if (source != null) {
                mxPoint pt;
                mxGraphView view = state.getView();
                mxGraph graph = view.getGraph();
                mxPoint mxPoint2 = pt = points != null && points.size() > 0 ? points.get(0) : null;
                if (pt != null && source.contains((pt = view.transformControlPoint(state, pt)).getX(), pt.getY())) {
                    pt = null;
                }
                double x = 0.0;
                double dx = 0.0;
                double y = 0.0;
                double dy = 0.0;
                double seg = mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_SEGMENT, graph.getGridSize()) * view.getScale();
                String dir = mxUtils.getString(state.getStyle(), mxConstants.STYLE_DIRECTION, "west");
                if (dir.equals("north") || dir.equals("south")) {
                    x = view.getRoutingCenterX(source);
                    dx = seg;
                } else {
                    y = view.getRoutingCenterY(source);
                    dy = seg;
                }
                if (pt == null || pt.getX() < source.getX() || pt.getX() > source.getX() + source.getWidth()) {
                    if (pt != null) {
                        x = pt.getX();
                        dy = Math.max(Math.abs(y - pt.getY()), dy);
                    } else if (dir.equals("north")) {
                        y = source.getY() - 2.0 * dx;
                    } else if (dir.equals("south")) {
                        y = source.getY() + source.getHeight() + 2.0 * dx;
                    } else {
                        x = dir.equals("east") ? source.getX() - 2.0 * dy : source.getX() + source.getWidth() + 2.0 * dy;
                    }
                } else {
                    x = view.getRoutingCenterX(source);
                    dx = Math.max(Math.abs(x - pt.getX()), dy);
                    y = pt.getY();
                    dy = 0.0;
                }
                result.add(new mxPoint(x - dx, y - dy));
                result.add(new mxPoint(x + dx, y + dy));
            }
        }
    };
    public static mxEdgeStyleFunction ElbowConnector = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            boolean vertical = false;
            boolean horizontal = false;
            if (source != null && target != null) {
                if (pt != null) {
                    double left = Math.min(source.getX(), target.getX());
                    double right = Math.max(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                    double top = Math.min(source.getY(), target.getY());
                    double bottom = Math.max(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                    pt = state.getView().transformControlPoint(state, pt);
                    vertical = pt.getY() < top || pt.getY() > bottom;
                    horizontal = pt.getX() < left || pt.getX() > right;
                } else {
                    double right;
                    double left = Math.max(source.getX(), target.getX());
                    boolean bl = vertical = left == (right = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth()));
                    if (!vertical) {
                        double bottom;
                        double top = Math.max(source.getY(), target.getY());
                        boolean bl2 = horizontal = top == (bottom = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight()));
                    }
                }
            }
            if (!horizontal && (vertical || mxUtils.getString(state.getStyle(), mxConstants.STYLE_ELBOW, "").equals("vertical"))) {
                TopToBottom.apply(state, source, target, points, result);
            } else {
                SideToSide.apply(state, source, target, points, result);
            }
        }
    };
    public static mxEdgeStyleFunction SideToSide = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            if (pt != null) {
                pt = view.transformControlPoint(state, pt);
            }
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            }
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            }
            if (source != null && target != null) {
                double l = Math.max(source.getX(), target.getX());
                double r = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                double x = pt != null ? pt.getX() : r + (l - r) / 2.0;
                double y1 = view.getRoutingCenterY(source);
                double y2 = view.getRoutingCenterY(target);
                if (pt != null) {
                    if (pt.getY() >= source.getY() && pt.getY() <= source.getY() + source.getHeight()) {
                        y1 = pt.getY();
                    }
                    if (pt.getY() >= target.getY() && pt.getY() <= target.getY() + target.getHeight()) {
                        y2 = pt.getY();
                    }
                }
                if (!target.contains(x, y1) && !source.contains(x, y1)) {
                    result.add(new mxPoint(x, y1));
                }
                if (!target.contains(x, y2) && !source.contains(x, y2)) {
                    result.add(new mxPoint(x, y2));
                }
                if (result.size() == 1) {
                    if (pt != null) {
                        result.add(new mxPoint(x, pt.getY()));
                    } else {
                        double t = Math.max(source.getY(), target.getY());
                        double b = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                        result.add(new mxPoint(x, t + (b - t) / 2.0));
                    }
                }
            }
        }
    };
    public static mxEdgeStyleFunction TopToBottom = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            if (pt != null) {
                pt = view.transformControlPoint(state, pt);
            }
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            }
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            }
            if (source != null && target != null) {
                double y;
                double t = Math.max(source.getY(), target.getY());
                double b = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                double x = view.getRoutingCenterX(source);
                if (pt != null && pt.getX() >= source.getX() && pt.getX() <= source.getX() + source.getWidth()) {
                    x = pt.getX();
                }
                double d = y = pt != null ? pt.getY() : b + (t - b) / 2.0;
                if (!target.contains(x, y) && !source.contains(x, y)) {
                    result.add(new mxPoint(x, y));
                }
                if (!target.contains(x = pt != null && pt.getX() >= target.getX() && pt.getX() <= target.getX() + target.getWidth() ? pt.getX() : view.getRoutingCenterX(target), y) && !source.contains(x, y)) {
                    result.add(new mxPoint(x, y));
                }
                if (result.size() == 1) {
                    if (pt != null) {
                        result.add(new mxPoint(pt.getX(), y));
                    } else {
                        double l = Math.max(source.getX(), target.getX());
                        double r = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                        result.add(new mxPoint(l + (r - l) / 2.0, y));
                    }
                }
            }
        }
    };
    public static double orthBuffer = 10.0;
    public static double[][] dirVectors = new double[][]{{-1.0, 0.0}, {0.0, -1.0}, {1.0, 0.0}, {0.0, 1.0}, {-1.0, 0.0}, {0.0, -1.0}, {1.0, 0.0}};
    public static double[][] wayPoints1 = new double[128][2];
    public static int[][][] routePatterns = new int[][][]{new int[][]{{513, 2308, 2081, 2562}, {513, 1090, 514, 2184, 2114, 2561}, {513, 1090, 514, 2564, 2184, 2562}, {513, 2308, 2561, 1090, 514, 2568, 2308}}, new int[][]{{514, 1057, 513, 2308, 2081, 2562}, {514, 2184, 2114, 2561}, {514, 2184, 2562, 1057, 513, 2564, 2184}, {514, 1057, 513, 2568, 2308, 2561}}, new int[][]{{1090, 514, 1057, 513, 2308, 2081, 2562}, {2114, 2561}, {1090, 2562, 1057, 513, 2564, 2184}, {1090, 514, 1057, 513, 2308, 2561, 2568}}, new int[][]{{2081, 2562}, {1057, 513, 1090, 514, 2184, 2114, 2561}, {1057, 513, 1090, 514, 2184, 2562, 2564}, {1057, 2561, 1090, 514, 2568, 2308}}};
    public static int[][][] inlineRoutePatterns = new int[][][]{new int[][]{null, {2114, 2568}, null, null}, new int[][]{null, {514, 2081, 2114, 2568}, null, null}, new int[][]{null, {2114, 2561}, null, null}, new int[][]{{2081, 2562}, {1057, 2114, 2568}, {2184, 2562}, null}};
    public static double[] vertexSeperations = new double[5];
    public static double[][] limits = new double[2][9];
    public static int LEFT_MASK = 32;
    public static int TOP_MASK = 64;
    public static int RIGHT_MASK = 128;
    public static int BOTTOM_MASK = 256;
    public static int LEFT = 1;
    public static int TOP = 2;
    public static int RIGHT = 4;
    public static int BOTTOM = 8;
    public static int SIDE_MASK = LEFT_MASK | TOP_MASK | RIGHT_MASK | BOTTOM_MASK;
    public static int CENTER_MASK = 512;
    public static int SOURCE_MASK = 1024;
    public static int TARGET_MASK = 2048;
    public static int VERTEX_MASK = SOURCE_MASK | TARGET_MASK;
    public static double vertBendProportion = 0.5;
    public static double hozBendProportion = 0.5;
    public static mxEdgeStyleFunction orthConnector = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            if (source != null && target != null) {
                int i;
                int i2;
                double scaledOrthBuffer = orthBuffer * state.getView().getScale();
                int[] portConstraint = new int[]{mxUtils.getPortConstraints(source, state, true), mxUtils.getPortConstraints(target, state, false)};
                int[] dir = new int[2];
                double[][] geo = new double[2][4];
                geo[0][0] = source.getX();
                geo[0][1] = source.getY();
                geo[0][2] = source.getWidth();
                geo[0][3] = source.getHeight();
                geo[1][0] = target.getX();
                geo[1][1] = target.getY();
                geo[1][2] = target.getWidth();
                geo[1][3] = target.getHeight();
                for (int i3 = 0; i3 < 2; ++i3) {
                    mxEdgeStyle.limits[i3][1] = geo[i3][0] - scaledOrthBuffer;
                    mxEdgeStyle.limits[i3][2] = geo[i3][1] - scaledOrthBuffer;
                    mxEdgeStyle.limits[i3][4] = geo[i3][0] + geo[i3][2] + scaledOrthBuffer;
                    mxEdgeStyle.limits[i3][8] = geo[i3][1] + geo[i3][3] + scaledOrthBuffer;
                }
                double sourceCenX = geo[0][0] + geo[0][2] / 2.0;
                double sourceCenY = geo[0][1] + geo[0][3] / 2.0;
                double targetCenX = geo[1][0] + geo[1][2] / 2.0;
                double targetCenY = geo[1][1] + geo[1][3] / 2.0;
                double dx = sourceCenX - targetCenX;
                double dy = sourceCenY - targetCenY;
                int quad = 0;
                if (dx < 0.0) {
                    quad = dy < 0.0 ? 2 : 1;
                } else if (dy <= 0.0) {
                    quad = 3;
                    if (dx == 0.0) {
                        quad = 2;
                    }
                }
                mxPoint p0 = state.getAbsolutePoint(0);
                mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
                mxPoint currentTerm = p0;
                double[][] constraint = new double[][]{{0.5, 0.5}, {0.5, 0.5}};
                for (int i4 = 0; i4 < 2; ++i4) {
                    if (currentTerm != null) {
                        constraint[i4][0] = (currentTerm.getX() - geo[i4][0]) / geo[i4][2];
                        if (constraint[i4][0] < 0.01) {
                            dir[i4] = 1;
                        } else if (constraint[i4][0] > 0.99) {
                            dir[i4] = 8;
                        }
                        constraint[i4][1] = (currentTerm.getY() - geo[i4][1]) / geo[i4][3];
                        if (constraint[i4][1] < 0.01) {
                            dir[i4] = 2;
                        } else if (constraint[i4][1] > 0.99) {
                            dir[i4] = 4;
                        }
                    }
                    currentTerm = pe;
                }
                double sourceTopDist = geo[0][1] - (geo[1][1] + geo[1][3]);
                double sourceLeftDist = geo[0][0] - (geo[1][0] + geo[1][2]);
                double sourceBottomDist = geo[1][1] - (geo[0][1] + geo[0][3]);
                double sourceRightDist = geo[1][0] - (geo[0][0] + geo[0][2]);
                mxEdgeStyle.vertexSeperations[1] = Math.max(sourceLeftDist - 2.0 * scaledOrthBuffer, 0.0);
                mxEdgeStyle.vertexSeperations[2] = Math.max(sourceTopDist - 2.0 * scaledOrthBuffer, 0.0);
                mxEdgeStyle.vertexSeperations[4] = Math.max(sourceBottomDist - 2.0 * scaledOrthBuffer, 0.0);
                mxEdgeStyle.vertexSeperations[3] = Math.max(sourceRightDist - 2.0 * scaledOrthBuffer, 0.0);
                int[] dirPref = new int[2];
                int[] horPref = new int[2];
                int[] vertPref = new int[2];
                horPref[0] = sourceLeftDist >= sourceRightDist ? 1 : 8;
                vertPref[0] = sourceTopDist >= sourceBottomDist ? 2 : 4;
                horPref[1] = mxUtils.reversePortConstraints(horPref[0]);
                vertPref[1] = mxUtils.reversePortConstraints(vertPref[0]);
                double preferredHorizDist = sourceLeftDist >= sourceRightDist ? sourceLeftDist : sourceRightDist;
                double preferredVertDist = sourceTopDist >= sourceBottomDist ? sourceTopDist : sourceBottomDist;
                int[][] prefOrdering = new int[2][2];
                boolean preferredOrderSet = false;
                for (i2 = 0; i2 < 2; ++i2) {
                    if (dir[i2] != 0) continue;
                    if ((horPref[i2] & portConstraint[i2]) == 0) {
                        horPref[i2] = mxUtils.reversePortConstraints(horPref[i2]);
                    }
                    if ((vertPref[i2] & portConstraint[i2]) == 0) {
                        vertPref[i2] = mxUtils.reversePortConstraints(vertPref[i2]);
                    }
                    prefOrdering[i2][0] = vertPref[i2];
                    prefOrdering[i2][1] = horPref[i2];
                }
                if (preferredVertDist > scaledOrthBuffer * 2.0 && preferredHorizDist > scaledOrthBuffer * 2.0) {
                    if ((horPref[0] & portConstraint[0]) > 0 && (vertPref[1] & portConstraint[1]) > 0) {
                        prefOrdering[0][0] = horPref[0];
                        prefOrdering[0][1] = vertPref[0];
                        prefOrdering[1][0] = vertPref[1];
                        prefOrdering[1][1] = horPref[1];
                        preferredOrderSet = true;
                    } else if ((vertPref[0] & portConstraint[0]) > 0 && (horPref[1] & portConstraint[1]) > 0) {
                        prefOrdering[0][0] = vertPref[0];
                        prefOrdering[0][1] = horPref[0];
                        prefOrdering[1][0] = horPref[1];
                        prefOrdering[1][1] = vertPref[1];
                        preferredOrderSet = true;
                    }
                }
                if (preferredVertDist > scaledOrthBuffer * 2.0 && !preferredOrderSet) {
                    prefOrdering[0][0] = vertPref[0];
                    prefOrdering[0][1] = horPref[0];
                    prefOrdering[1][0] = vertPref[1];
                    prefOrdering[1][1] = horPref[1];
                    preferredOrderSet = true;
                }
                if (preferredHorizDist > scaledOrthBuffer * 2.0 && !preferredOrderSet) {
                    prefOrdering[0][0] = horPref[0];
                    prefOrdering[0][1] = vertPref[0];
                    prefOrdering[1][0] = horPref[1];
                    prefOrdering[1][1] = vertPref[1];
                    preferredOrderSet = true;
                }
                for (i2 = 0; i2 < 2; ++i2) {
                    if (dir[i2] != 0) continue;
                    if ((prefOrdering[i2][0] & portConstraint[i2]) == 0) {
                        prefOrdering[i2][0] = prefOrdering[i2][1];
                    }
                    dirPref[i2] = prefOrdering[i2][0] & portConstraint[i2];
                    int n = i2;
                    dirPref[n] = dirPref[n] | (prefOrdering[i2][1] & portConstraint[i2]) << 8;
                    int n2 = i2;
                    dirPref[n2] = dirPref[n2] | (prefOrdering[1 - i2][i2] & portConstraint[i2]) << 16;
                    int n3 = i2;
                    dirPref[n3] = dirPref[n3] | (prefOrdering[1 - i2][1 - i2] & portConstraint[i2]) << 24;
                    if ((dirPref[i2] & 0xF) == 0) {
                        dirPref[i2] = dirPref[i2] << 8;
                    }
                    if ((dirPref[i2] & 0xF00) == 0) {
                        dirPref[i2] = dirPref[i2] & 0xF | dirPref[i2] >> 8;
                    }
                    if ((dirPref[i2] & 0xF0000) == 0) {
                        dirPref[i2] = dirPref[i2] & 0xFFFF | (dirPref[i2] & 0xF000000) >> 8;
                    }
                    dir[i2] = dirPref[i2] & 0xF;
                    if (portConstraint[i2] != 1 && portConstraint[i2] != 2 && portConstraint[i2] != 8 && portConstraint[i2] != 4) continue;
                    dir[i2] = portConstraint[i2];
                }
                int[] routePattern = this.getRoutePattern(dir, quad, dx, dy);
                if (dx == 0.0 || dy == 0.0) {
                    // empty if block
                }
                mxEdgeStyle.wayPoints1[0][0] = geo[0][0];
                mxEdgeStyle.wayPoints1[0][1] = geo[0][1];
                switch (dir[0]) {
                    case 1: {
                        double[] dArray = wayPoints1[0];
                        dArray[0] = dArray[0] - scaledOrthBuffer;
                        double[] dArray2 = wayPoints1[0];
                        dArray2[1] = dArray2[1] + constraint[0][1] * geo[0][3];
                        break;
                    }
                    case 4: {
                        double[] dArray = wayPoints1[0];
                        dArray[0] = dArray[0] + constraint[0][0] * geo[0][2];
                        double[] dArray3 = wayPoints1[0];
                        dArray3[1] = dArray3[1] + (geo[0][3] + scaledOrthBuffer);
                        break;
                    }
                    case 8: {
                        double[] dArray = wayPoints1[0];
                        dArray[0] = dArray[0] + (geo[0][2] + scaledOrthBuffer);
                        double[] dArray4 = wayPoints1[0];
                        dArray4[1] = dArray4[1] + constraint[0][1] * geo[0][3];
                        break;
                    }
                    case 2: {
                        double[] dArray = wayPoints1[0];
                        dArray[0] = dArray[0] + constraint[0][0] * geo[0][2];
                        double[] dArray5 = wayPoints1[0];
                        dArray5[1] = dArray5[1] - scaledOrthBuffer;
                    }
                }
                int currentIndex = 0;
                int lastOrientation = (dir[0] & 9) > 0 ? 0 : 1;
                int currentOrientation = 0;
                for (i = 0; i < routePattern.length; ++i) {
                    boolean center;
                    int directionIndex;
                    int nextDirection = routePattern[i] & 0xF;
                    int n = directionIndex = nextDirection == 8 ? 3 : nextDirection;
                    if ((directionIndex += quad) > 4) {
                        directionIndex -= 4;
                    }
                    double[] direction = dirVectors[directionIndex - 1];
                    int n4 = currentOrientation = directionIndex % 2 > 0 ? 0 : 1;
                    if (currentOrientation != lastOrientation) {
                        mxEdgeStyle.wayPoints1[++currentIndex][0] = wayPoints1[currentIndex - 1][0];
                        mxEdgeStyle.wayPoints1[currentIndex][1] = wayPoints1[currentIndex - 1][1];
                    }
                    boolean tar = (routePattern[i] & TARGET_MASK) > 0;
                    boolean sou = (routePattern[i] & SOURCE_MASK) > 0;
                    int side = (routePattern[i] & SIDE_MASK) >> 5;
                    if ((side <<= quad) > 15) {
                        side >>= 4;
                    }
                    boolean bl = center = (routePattern[i] & CENTER_MASK) > 0;
                    if ((sou || tar) && side < 9) {
                        int souTar;
                        double limit = 0.0;
                        int n5 = souTar = sou ? 0 : 1;
                        limit = center && currentOrientation == 0 ? geo[souTar][0] + constraint[souTar][0] * geo[souTar][2] : (center ? geo[souTar][1] + constraint[souTar][1] * geo[souTar][3] : limits[souTar][side]);
                        if (currentOrientation == 0) {
                            double lastX = wayPoints1[currentIndex][0];
                            double deltaX = (limit - lastX) * direction[0];
                            if (deltaX > 0.0) {
                                double[] dArray = wayPoints1[currentIndex];
                                dArray[0] = dArray[0] + direction[0] * deltaX;
                            }
                        } else {
                            double lastY = wayPoints1[currentIndex][1];
                            double deltaY = (limit - lastY) * direction[1];
                            if (deltaY > 0.0) {
                                double[] dArray = wayPoints1[currentIndex];
                                dArray[1] = dArray[1] + direction[1] * deltaY;
                            }
                        }
                    } else if (center) {
                        double[] dArray = wayPoints1[currentIndex];
                        dArray[0] = dArray[0] + direction[0] * Math.abs(vertexSeperations[directionIndex] / 2.0);
                        double[] dArray6 = wayPoints1[currentIndex];
                        dArray6[1] = dArray6[1] + direction[1] * Math.abs(vertexSeperations[directionIndex] / 2.0);
                    }
                    if (currentIndex > 0 && wayPoints1[currentIndex][currentOrientation] == wayPoints1[currentIndex - 1][currentOrientation]) {
                        --currentIndex;
                        continue;
                    }
                    lastOrientation = currentOrientation;
                }
                for (i = 0; i <= currentIndex; ++i) {
                    result.add(new mxPoint(wayPoints1[i][0], wayPoints1[i][1]));
                }
            }
        }

        protected int[] getRoutePattern(int[] dir, double quad, double dx, double dy) {
            int sourceIndex = dir[0] == 8 ? 3 : dir[0];
            int targetIndex = dir[1] == 8 ? 3 : dir[1];
            sourceIndex = (int)((double)sourceIndex - quad);
            targetIndex = (int)((double)targetIndex - quad);
            if (sourceIndex < 1) {
                sourceIndex += 4;
            }
            if (targetIndex < 1) {
                targetIndex += 4;
            }
            int[] result = routePatterns[sourceIndex - 1][targetIndex - 1];
            if ((dx == 0.0 || dy == 0.0) && inlineRoutePatterns[sourceIndex - 1][targetIndex - 1] != null) {
                result = inlineRoutePatterns[sourceIndex - 1][targetIndex - 1];
            }
            return result;
        }
    };

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface mxEdgeStyleFunction {
        public void apply(mxCellState var1, mxCellState var2, mxCellState var3, List<mxPoint> var4, List<mxPoint> var5);
    }
}

