/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.dataTable.HecDataTableToExcel;
import hec.dssgui.ListSelection;
import hec.dssgui.TimeSeriesDataEntry;
import hec.heclib.dss.DssDataManager;
import hec.io.TimeSeriesContainer;
import hec.plugins.excel.ExcelFrame;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import rma.swing.FlatPanelButton;
import rma.swing.RmaImage;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class Excel {
    public static void main(Object[] args) {
        final Excel plugin = new Excel();
        final ListSelection listSelection = (ListSelection)args[0];
        JMenuItem importMenu = new JMenuItem("Excel");
        importMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.importExcel(listSelection);
            }
        });
        listSelection.registerImportPlugin(null, importMenu, null);
        JMenuItem exportMenu = new JMenuItem("Excel");
        exportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.tabulateInExcel(listSelection, false, true);
            }
        });
        listSelection.registerExportPlugin(exportMenu);
        JMenuItem tabulate = new JMenuItem("Tabulate in Excel");
        tabulate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.tabulateInExcel(listSelection, false, false);
            }
        });
        listSelection.registerPlugin(3, tabulate);
        FlatPanelButton TabulateExcelTool = new FlatPanelButton();
        TabulateExcelTool.setMargin(new Insets(0, 0, 0, 0));
        TabulateExcelTool.setActionCommand("TabulateExcel");
        TabulateExcelTool.setToolTipText("Tabulate in MS Excel");
        TabulateExcelTool.setBounds(93, 2, 7, 7);
        TabulateExcelTool.setIcon((Icon)RmaImage.getImageIcon((String)"Images/Excel.gif"));
        TabulateExcelTool.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.tabulateInExcel(listSelection, false, false);
            }
        });
        listSelection.addToolBarButton((JButton)TabulateExcelTool);
        JMenuItem edit = new JMenuItem("Edit in Excel");
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.tabulateInExcel(listSelection, true, false);
            }
        });
        listSelection.registerPlugin(1, edit);
    }

    public void tabulateInExcel(ListSelection listSelection, boolean edit, boolean exportOnly) {
        int i;
        DssDataManager dataManager = listSelection.getDataManager();
        if (!dataManager.fileAccessible()) {
            String message = "No DSS file opened.";
            JOptionPane.showMessageDialog((Component)listSelection, message, ListSelection._programName, 2);
            return;
        }
        if (!dataManager.writeAccess() && edit) {
            String message = "No write access to File " + dataManager.DSSFileName();
            JOptionPane.showMessageDialog((Component)listSelection, message, ListSelection._programName, 2);
            return;
        }
        List[] dataSets = listSelection.readData();
        boolean found = false;
        for (i = 0; i < dataSets.length; ++i) {
            if (dataSets[i] == null) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        if (edit) {
            for (i = 1; i < dataSets.length; ++i) {
                if (dataSets[i] == null) continue;
                String message = "Can only edit time series data in Excel at this time.";
                JOptionPane.showMessageDialog((Component)listSelection, message, ListSelection._programName, 2);
                return;
            }
        }
        HecDataTableToExcel excelTable = new HecDataTableToExcel();
        try {
            if (exportOnly) {
                String excelDirectory = listSelection.getPreferences().get("ExcelDirectory", "");
                JFileChooser chooser = excelDirectory.length() > 0 ? new JFileChooser(excelDirectory) : new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter((FileFilter)new RMAFilenameFilter("xls", "*.xls"));
                chooser.setFileFilter((FileFilter)new RMAFilenameFilter("xlsx", "*.xlsx"));
                chooser.showOpenDialog((Component)listSelection);
                File file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                excelDirectory = RMAIO.getDirectoryFromPath((String)file.getPath());
                listSelection.getPreferences().put("ExcelDirectory", excelDirectory);
                Object filename = file.getCanonicalPath();
                String extension = RMAIO.getFileExtension((String)filename);
                if (!extension.toLowerCase().equalsIgnoreCase(".xls") && !extension.toLowerCase().equalsIgnoreCase(".xlsx") && chooser.getFileFilter() != null) {
                    String fileFilterExtension = chooser.getFileFilter().getDescription();
                    filename = fileFilterExtension.equalsIgnoreCase("*.xls") ? (String)filename + ".xls" : (String)filename + ".xlsx";
                }
                excelTable.createExcelFile(dataSets, (String)filename);
                String message = "Data exported to " + (String)filename;
                JOptionPane.showMessageDialog((Component)listSelection, message, ListSelection._programName, 1);
            } else {
                Vector containers;
                int opt;
                excelTable.runExcel(dataSets);
                if (edit && (opt = JOptionPane.showConfirmDialog((Component)listSelection, "Press OK after you have saved the Excel file.", "Excel Data", 2)) == 0 && (containers = excelTable.getEditedContainers()).size() > 0) {
                    listSelection.save(containers);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)listSelection, e.getMessage(), ListSelection._programName, 2);
        }
    }

    protected void importExcel(final ListSelection listSelection) {
        String currentDirectory = listSelection.getDSSFilename();
        if (currentDirectory == null || currentDirectory.length() == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "Please select a DSS File", "No File Selected", 2);
            return;
        }
        final DssDataManager dataManager = listSelection.getDataManager();
        if (!dataManager.writeAccess()) {
            JOptionPane.showMessageDialog((Component)listSelection, "No write access to file.", "Unable to Write", 2);
            return;
        }
        String excelDirectory = listSelection.getPreferences().get("ExcelDirectory", "");
        String filename = this.getExcelFilename(excelDirectory, listSelection);
        if (filename == null) {
            return;
        }
        System.out.println("File: " + filename);
        excelDirectory = RMAIO.getDirectoryFromPath((String)filename);
        listSelection.getPreferences().put("ExcelDirectory", excelDirectory);
        final ExcelFrame excelFrame = new ExcelFrame(filename);
        excelFrame.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg instanceof ActionEvent) {
                    ActionEvent event = (ActionEvent)arg;
                    String eventName = event.getActionCommand();
                    if (eventName.compareTo("importDataEntry") == 0) {
                        Vector dataContainers = excelFrame.getTimeSeriesContainers();
                        if (dataContainers.size() > 0) {
                            for (int i = 0; i < dataContainers.size(); ++i) {
                                Object obj = dataContainers.elementAt(i);
                                if (!(obj instanceof TimeSeriesContainer)) continue;
                                TimeSeriesContainer timeSeriesContainer = (TimeSeriesContainer)obj;
                                TimeSeriesDataEntry timeSeriesDataEntry = new TimeSeriesDataEntry((JFrame)listSelection, dataManager, timeSeriesContainer);
                                timeSeriesDataEntry.setModal(true);
                                timeSeriesDataEntry.setVisible(true);
                            }
                            listSelection.updateCatalog();
                        }
                        Object mess = excelFrame.getMessage();
                        if (dataContainers.size() > 0) {
                            mess = (String)mess + "\nClose import table or return to table?";
                            Object[] selVals = new String[]{"Close", "Return"};
                            int opt = JOptionPane.showOptionDialog((Component)listSelection, mess, "Data imported", 0, 1, null, selVals, 0);
                            if (opt == 0) {
                                excelFrame.close();
                            } else {
                                excelFrame.toFront();
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)listSelection, mess);
                        }
                    } else if (eventName.compareTo("importComplete") == 0) {
                        Vector dataContainers = excelFrame.getData();
                        if (dataContainers.size() > 0) {
                            listSelection.saveData(dataContainers);
                            listSelection.updateCatalog();
                        }
                        Object mess = excelFrame.getMessage();
                        if (dataContainers.size() > 0) {
                            if (((String)mess).length() == 0) {
                                mess = dataContainers.size() + " data set(s) imported.";
                            }
                            mess = (String)mess + "\nClose import table or return to table?";
                            Object[] selVals = new String[]{"Close", "Return"};
                            int opt = JOptionPane.showOptionDialog((Component)listSelection, mess, "Data imported", 0, 1, null, selVals, 0);
                            if (opt == 0) {
                                excelFrame.close();
                            } else {
                                excelFrame.toFront();
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)listSelection, mess);
                        }
                    }
                }
            }
        });
        excelFrame.setVisible(true);
    }

    public String getExcelFilename(String directory, ListSelection listSelection) {
        JFileChooser chooser = directory != null && directory.length() > 0 ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.xlsx", "xlsx");
        chooser.addChoosableFileFilter(filter);
        filter = new FileNameExtensionFilter("*.xls", "xls");
        chooser.addChoosableFileFilter(filter);
        chooser.showOpenDialog((Component)listSelection);
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }
}

