/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.plugins.excel.ExcelPanel;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observer;
import java.util.Vector;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class ExcelFrame
extends GeneralTableEditor {
    protected ExcelPanel _excelPanel;

    public ExcelFrame(String excelFile) {
        this.buildControls();
        this.loadExcelFile(excelFile);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._excelPanel = new ExcelPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._excelPanel, gbc);
        this.setJMenuBar(this._excelPanel.getJMenuBar());
        this.addListeners();
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExcelFrame.this._excelPanel.close();
                ExcelFrame.this.close();
            }
        });
    }

    protected void loadExcelFile(String filename) {
        if (this._excelPanel.loadFile(filename)) {
            this.setTitle(RMAIO.getFileNameNoExtension((String)filename));
        }
    }

    public boolean isCanceled() {
        return this._excelPanel.isCanceled();
    }

    public String getSelectedWorkbook() {
        return this._excelPanel.getSelectedWorkbook();
    }

    public void setSelectedWorkbook(String workbookName) {
        this._excelPanel.setSelectedWorkbook(workbookName);
    }

    public String getSelectedRange() {
        return this._excelPanel.getSelectedRange();
    }

    public void setSelectedRange(String range) {
        this._excelPanel.setSelectedRange(range);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            // empty if block
        }
        super.setVisible(visible);
    }

    public Vector getData() {
        return this._excelPanel.getData();
    }

    public Vector getTimeSeriesContainers() {
        return this._excelPanel.getTimeSeriesContainers();
    }

    public String getMessage() {
        return this._excelPanel.getMessage();
    }

    public void close() {
        this._excelPanel.close();
        if (this._standAlone) {
            System.exit(0);
        }
        this.dispose();
    }

    public void addObserver(Observer o) {
        this._excelPanel.addObserver(o);
    }
}

