/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.plugins.excel.ExcelImportControl;
import hec.plugins.excel.ExcelTable;
import hec.util.ObservableClass;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTabbedPane;
import rma.swing.RmaJTextField;

public class ExcelPanel
extends JPanel {
    private RmaJTabbedPane _tabbedPane;
    private RmaJTextField _statusLine;
    private ButtonCmdPanel _cmdPanel;
    private Workbook _workbook;
    protected boolean _canceled;
    protected Vector<ExcelImportControl> controls = new Vector();
    protected Observer _observer = null;
    protected ObservableClass _observableClass = new ObservableClass();

    public ExcelPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._tabbedPane = new RmaJTabbedPane();
        this._tabbedPane.setTabPlacement(3);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)this._tabbedPane, gbc);
        this._statusLine = new RmaJTextField();
        this._statusLine.setEditable(false);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._statusLine, gbc);
        this._cmdPanel = new ButtonCmdPanel(14);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this._cmdPanel, gbc);
        this.addListeners();
    }

    protected void addListeners() {
        this._cmdPanel.getButton("OK").setText("Import");
        this._cmdPanel.getButton("Cancel").setText("Clear");
        this._cmdPanel.getButton("Apply").setText("Close");
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                Window w = SwingUtilities.windowForComponent(ExcelPanel.this);
                switch (e.getID()) {
                    case 8: {
                        ExcelPanel.this.importData();
                        return;
                    }
                    case 2: {
                        ExcelPanel.this._canceled = true;
                        break;
                    }
                    case 4: {
                        ExcelPanel.this.clear();
                        return;
                    }
                }
                ExcelPanel.this.close();
                w.setVisible(false);
            }
        });
    }

    public boolean loadFile(String fileName) {
        this.close();
        this._tabbedPane.removeAll();
        File f = new File(fileName);
        if (!f.exists() || !f.canRead()) {
            return false;
        }
        try {
            FileInputStream inp = new FileInputStream(fileName);
            this._workbook = WorkbookFactory.create((InputStream)inp);
        }
        catch (Exception e) {
            System.out.println("Exception loading MSExcel File " + e);
            e.printStackTrace();
            return false;
        }
        int sheetCnt = this._workbook.getNumberOfSheets();
        for (int i = 0; i < sheetCnt; ++i) {
            this.addTab(i);
        }
        return true;
    }

    protected void addTab(int sheetNumber) {
        Sheet sheet = this._workbook.getSheetAt(sheetNumber);
        ExcelTable table = new ExcelTable(this, sheet);
        ExcelImportControl importControl = new ExcelImportControl(table);
        this.controls.add(importControl);
        if (this._observer != null) {
            importControl.addObserver(this._observer);
        }
        table.setImportControl(importControl);
        table.getSelectionModel().addListSelectionListener(new ExcelListSelectionListener(table));
        this._tabbedPane.addTab(sheet.getSheetName(), (Component)table.getScrollPane());
    }

    public Vector getData() {
        ExcelTable table = this.getSelectedTable();
        return ((ExcelImportControl)table.getImportControl()).getData();
    }

    public Vector getTimeSeriesContainers() {
        ExcelTable table = this.getSelectedTable();
        return ((ExcelImportControl)table.getImportControl()).getTimeSeriesContainers(this);
    }

    public void clear() {
        ExcelTable table = this.getSelectedTable();
        table.setSelectedRangeString(null);
        table.clearAll();
    }

    protected void importData() {
        ExcelTable table = this.getSelectedTable();
        boolean useImportControl = table.getImportControl().isAnySet();
        String selected = this.getSelectedRange();
        if (selected.length() == 0) {
            if (useImportControl) {
                table.getImportControl().importData();
            } else {
                JOptionPane.showMessageDialog(null, "No data selected to import.", "Import Excel data", 2);
            }
        } else if (useImportControl) {
            ((ExcelImportControl)table.getImportControl()).runSelectedImport(this);
        } else {
            ActionEvent event = new ActionEvent(this, 0, "importDataEntry");
            if (this._observableClass != null) {
                this._observableClass.notifyObservers((Object)event);
            }
        }
    }

    public String getMessage() {
        ExcelTable table = this.getSelectedTable();
        return table.getImportControl().getMessage();
    }

    public void setButtonPanelVisible(boolean visible) {
        this._cmdPanel.setVisible(visible);
    }

    public void setStatusLineVisible(boolean visible) {
        this._statusLine.setVisible(visible);
    }

    public void setTableHeaderPopupsEnabled(boolean enabled) {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            JScrollPane pane = (JScrollPane)this._tabbedPane.getComponent(i);
            ExcelTable table = (ExcelTable)((Object)pane.getViewport().getView());
            table.setHeaderPopupsEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int cnt = this._tabbedPane.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            this._tabbedPane.getComponentAt(i).setEnabled(false);
        }
    }

    public JMenuBar getJMenuBar() {
        return new JMenuBar();
    }

    public void close() {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            JScrollPane scrollPane;
            JViewport viewPort;
            Component component;
            Component tabComponent = this._tabbedPane.getComponentAt(i);
            if (!(tabComponent instanceof JScrollPane) || !((component = (viewPort = (scrollPane = (JScrollPane)tabComponent).getViewport()).getView()) instanceof ExcelTable)) continue;
            ExcelTable table = (ExcelTable)((Object)component);
            table.close();
        }
        if (this._workbook != null) {
            this._workbook = null;
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getSelectedWorkbook() {
        int idx = this._tabbedPane.getSelectedIndex();
        return this._tabbedPane.getTitleAt(idx);
    }

    public Sheet getSelectedSheet() {
        ExcelTable table = this.getSelectedTable();
        if (table != null) {
            return table.getSheet();
        }
        return null;
    }

    public ExcelTable getSelectedTable() {
        JScrollPane pane = (JScrollPane)this._tabbedPane.getSelectedComponent();
        ExcelTable table = (ExcelTable)((Object)pane.getViewport().getView());
        return table;
    }

    public boolean setSelectedWorkbook(String workbookName) {
        if (workbookName == null) {
            return false;
        }
        int count = this._tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            String title = this._tabbedPane.getTitleAt(i);
            if (!workbookName.equalsIgnoreCase(title)) continue;
            this._tabbedPane.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public String getSelectedRange() {
        JScrollPane pane = (JScrollPane)this._tabbedPane.getSelectedComponent();
        ExcelTable table = (ExcelTable)((Object)pane.getViewport().getView());
        return table.getSelectedRangeString();
    }

    public void setSelectedRange(String range) {
        JScrollPane pane = (JScrollPane)this._tabbedPane.getSelectedComponent();
        if (pane != null) {
            ExcelTable table = (ExcelTable)((Object)pane.getViewport().getView());
            table.setSelectedRangeString(range);
        }
    }

    public List getSelectedData() {
        ExcelTable table = this.getSelectedTable();
        if (table == null) {
            return new ArrayList(0);
        }
        List l = table.getSelectedData();
        return l;
    }

    public List getWorksheetNames() {
        Vector<String> sheetList = new Vector<String>();
        int ntab = this._tabbedPane.getTabCount();
        for (int i = 0; i < ntab; ++i) {
            String tabname = this._tabbedPane.getTitleAt(i);
            sheetList.add(tabname);
        }
        return sheetList;
    }

    public void addObserver(Observer o) {
        this._observer = o;
        this._observableClass.addObserver(o);
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.elementAt(i).addObserver(o);
        }
    }

    public JTabbedPane getTabbedPane() {
        return this._tabbedPane;
    }

    private class ExcelListSelectionListener
    implements ListSelectionListener {
        private ExcelTable _table;

        ExcelListSelectionListener(ExcelTable table) {
            this._table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ExcelPanel.this._statusLine.setText(this._table.getSelectedRangeString());
        }
    }
}

