/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.dataui.importExport.general.ImportTable;
import hec.heclib.util.HecTime;
import hec.plugins.excel.ExcelTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ExcelTable
extends ImportTable {
    private ExcelTableModel _model;
    protected TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private Sheet _sheet;

    public ExcelTable(Component parent, Sheet sheet) {
        super(parent);
        this.setSheet(sheet);
    }

    protected void createTable() {
        Row row1;
        this.setHorizontalAlignment(0, 0);
        this.setAddRemoveEnabled(false);
        this.setAutoResizeMode(0);
        if (this._sheet != null) {
            for (int row = 0; row < this._sheet.getPhysicalNumberOfRows(); ++row) {
                row1 = this._sheet.getRow(row);
                if (row1 == null) continue;
                this.setRowHeight(row, row1.getHeight() / 12);
            }
        }
        if ((row1 = this._sheet.getRow(0)) == null) {
            return;
        }
        for (int i = 0; i < row1.getPhysicalNumberOfCells(); ++i) {
            int width = this._sheet.getColumnWidth(i);
            if (width > 1000) {
                width /= 35;
            }
            if (width <= 20) continue;
            this.setColumnWidth(i + 1, width);
        }
    }

    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int column = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        if (this.getAutoRowHeaders() && column == 0) {
            return super.getToolTipText(event);
        }
        Cell cell = this._model.getCell(row, column);
        if (cell != null && cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        return super.getToolTipText(event);
    }

    public boolean isEditable() {
        return false;
    }

    public String getSelectedRangeString() {
        StringBuffer buf = new StringBuffer();
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || cols.length == 0 || cols.length == 1 && cols[0] == 0) {
            return buf.toString();
        }
        TableColumnModel colModel = this.getColumnModel();
        buf.append(colModel.getColumn(cols[0]).getHeaderValue());
        buf.append(rows[0] + 1);
        buf.append("..");
        buf.append(colModel.getColumn(cols[cols.length - 1]).getHeaderValue());
        buf.append(rows[rows.length - 1] + 1);
        return buf.toString();
    }

    public void setSelectedRangeString(String range) {
        if (range == null || range.length() == 0) {
            this.clearSelection();
            return;
        }
        String start = RMAIO.getType((String)range, (String)"..");
        String end = RMAIO.getParam((String)range, (String)"..");
        int startCol = this.getColumnFromRangePart(start);
        int startRow = this.getRowFromRangePart(start);
        int endCol = this.getColumnFromRangePart(end);
        int endRow = this.getRowFromRangePart(end);
        if (startCol > -1 && startRow > -1 && endCol > -1 && endRow > -1) {
            this.addColumnSelectionInterval(startCol, endCol);
            this.addRowSelectionInterval(startRow, endRow);
        }
    }

    private int getColumnFromRangePart(String rangePart) {
        int i;
        if (rangePart == null || rangePart.length() == 0) {
            return -1;
        }
        char[] array = rangePart.toCharArray();
        for (i = 0; i < array.length && !Character.isDigit(array[i]); ++i) {
        }
        String columnName = rangePart.substring(0, i);
        TableColumnModel colModel = this.getColumnModel();
        for (i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            if (!columnName.equals(col.getHeaderValue())) continue;
            return i;
        }
        return -1;
    }

    private int getRowFromRangePart(String rangePart) {
        int i;
        if (rangePart == null || rangePart.length() == 0) {
            return -1;
        }
        char[] array = rangePart.toCharArray();
        for (i = 0; i < array.length && Character.isLetter(array[i]); ++i) {
        }
        String rowName = rangePart.substring(i);
        int row = RMAIO.parseInt((String)rowName, (int)-1);
        if (row > 0) {
            --row;
        }
        return row;
    }

    public void setSheet(Sheet sheet) {
        if (sheet != null) {
            this._model = new ExcelTableModel(sheet, sheet.getWorkbook());
            this.setModel((TableModel)((Object)this._model));
            this._sheet = sheet;
            this.createTable();
        }
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public List getSelectedData() {
        int[] rows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        ArrayList data = new ArrayList(rows.length);
        HecTime time = new HecTime();
        for (int row = 0; row < rows.length; ++row) {
            ArrayList<Object> rowData = new ArrayList<Object>(cols.length);
            for (int col = 0; col < cols.length; ++col) {
                Cell cell = this._model.getCell(rows[row], cols[col]);
                if (cell != null && cell.getCellType() == CellType.NUMERIC) {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date d = cell.getDateCellValue();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(d);
                        SimpleDateFormat tzDateFormat = new SimpleDateFormat("ddMMMyyyy HHmm");
                        tzDateFormat.setTimeZone(cal.getTimeZone());
                        String contents = tzDateFormat.format(d);
                        if (contents.length() < 6) {
                            rowData.add(contents);
                            continue;
                        }
                        time = new HecTime();
                        time.set(contents);
                        rowData.add(time);
                        continue;
                    }
                    rowData.add(Double.toString(cell.getNumericCellValue()));
                    continue;
                }
                if (cell == null) continue;
                String contents = cell.getStringCellValue().trim();
                double val = RMAIO.parseDouble((String)contents);
                if (RMAConst.isValidValue((double)val)) {
                    rowData.add(new Double(val));
                    continue;
                }
                if (contents.length() > 5) {
                    time.set(contents);
                    if (time.isDateDefined()) {
                        rowData.add(time.clone());
                        continue;
                    }
                }
                rowData.add(contents);
            }
            data.add(rowData);
        }
        return data;
    }

    public void close() {
        this._sheet = null;
        this._model.close();
    }
}

