/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.dataui.importExport.general.ImportTableModel;
import hec.heclib.util.HecTime;
import java.util.ArrayList;
import java.util.TimeZone;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;

public class ExcelTableModel
extends ImportTableModel {
    private Sheet _sheet;
    private int _rowCnt;
    protected TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected ExcelStyleDateFormatter _dateFormat = new ExcelStyleDateFormatter("ddMMMyyyy HHmm");
    protected ExcelStyleDateFormatter _timeFormat = new ExcelStyleDateFormatter("HH:mm");
    protected FormulaEvaluator _evaluator;

    public ExcelTableModel(Sheet sheet) {
        this(sheet, null);
    }

    public ExcelTableModel(Sheet sheet, Workbook wb) {
        int i;
        this._sheet = sheet;
        this._rowCnt = sheet.getPhysicalNumberOfRows();
        ArrayList<String> columnLetters = new ArrayList<String>();
        columnLetters.add(" ");
        int numCells = this.findMaxColumnCount();
        for (i = 0; i < numCells; ++i) {
            columnLetters.add(ExcelTableModel.convertToLetter(i + 1));
        }
        this.m_columnNames = new String[columnLetters.size()];
        for (i = 0; i < columnLetters.size(); ++i) {
            this.m_columnNames[i] = (String)columnLetters.get(i);
        }
        this.setColumnNames(this.m_columnNames);
        if (wb != null) {
            this._evaluator = wb.getCreationHelper().createFormulaEvaluator();
        }
    }

    private int findMaxColumnCount() {
        if (this._sheet == null) {
            return 0;
        }
        int max = -1;
        for (Row row : this._sheet) {
            short lastCell = row.getLastCellNum();
            max = Math.max(max, lastCell);
        }
        return max;
    }

    public static String convertToLetter(int column) {
        int firstLetterVal = 0;
        int secondLetterVal = 0;
        double value = column;
        Object result = "";
        if (value / 26.0 > 1.0) {
            firstLetterVal += 64 + (int)value / 26;
            secondLetterVal += 64 + (int)(value % 26.0);
        } else {
            firstLetterVal = (int)((double)firstLetterVal + (64.0 + value));
        }
        char firstLetter = (char)firstLetterVal;
        char secondLetter = (char)secondLetterVal;
        result = secondLetterVal > 0 ? String.valueOf(firstLetter) + String.valueOf(secondLetter) : String.valueOf(firstLetter);
        return result;
    }

    public void close() {
        this._sheet = null;
    }

    public int getRowCount() {
        return this._rowCnt;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount() || col < 0 || col >= this.getColumnCount()) {
            return null;
        }
        if (col == 0) {
            return String.valueOf(row + 1);
        }
        --col;
        Row rowCell = this._sheet.getRow(row);
        if (rowCell == null) {
            return null;
        }
        Cell cell = rowCell.getCell(col);
        return this.getCellContents(cell);
    }

    public String getCellContents(String loc) {
        CellReference ref = new CellReference(loc);
        Row row = this._sheet.getRow(ref.getRow());
        Cell cell = row.getCell((int)ref.getCol());
        if (cell != null) {
            return this.getCellContents(cell);
        }
        return "";
    }

    public String getCellContents(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getRichStringCellValue().getString();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    DataFormatter dataFormatter = new DataFormatter();
                    CellStyle style = cell.getCellStyle();
                    if (style != null && this.isTimeFormat(cell)) {
                        return this._timeFormat.format(cell.getDateCellValue());
                    }
                    return this._dateFormat.format(cell.getDateCellValue());
                }
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                if (this._evaluator != null) {
                    CellValue cellValue = this._evaluator.evaluate(cell);
                    switch (cellValue.getCellType()) {
                        case BOOLEAN: {
                            return String.valueOf(cellValue.getBooleanValue());
                        }
                        case NUMERIC: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                CellStyle style = cell.getCellStyle();
                                if (style != null) {
                                    short i = style.getDataFormat();
                                    String f = style.getDataFormatString();
                                    if (this.isTimeFormat(cell)) {
                                        return this._timeFormat.format(cell.getDateCellValue());
                                    }
                                }
                                return this._dateFormat.format(cell.getDateCellValue());
                            }
                            return Double.toString(cellValue.getNumberValue());
                        }
                        case STRING: {
                            return cellValue.getStringValue();
                        }
                        case BLANK: 
                        case ERROR: {
                            return "";
                        }
                    }
                    break;
                }
                return cell.getCellFormula();
            }
        }
        return "";
    }

    private boolean isTimeFormat(Cell cell) {
        String fmt;
        CellStyle style = cell.getCellStyle();
        return style != null && (fmt = style.getDataFormatString()).contains(":") && !fmt.contains("y");
    }

    public void getTime(int row, HecTime hecTime) {
        if (this.getActionSet(10)) {
            hecTime.setUndefined();
            if (this.getActionSet(10)) {
                int col = this.getActionCell(row, 10);
                if (col > -1) {
                    String s = this.getValueAt(row, col).toString();
                    hecTime.set(s);
                }
            } else {
                super.getTime(row, hecTime);
            }
        } else {
            super.getTime(row, hecTime);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Cell getCell(int row, int col) {
        Row rowCell;
        int column = col - 1;
        if (column < 0) {
            column = 1;
        }
        if ((rowCell = this._sheet.getRow(row)) == null) {
            return null;
        }
        Cell cell = rowCell.getCell(column);
        return cell;
    }
}

