/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.excel;

import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.lang.Const;
import hec.plugins.excel.ExcelPanel;
import java.util.List;
import java.util.Vector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ExcelToDSSImportCmd {
    protected ExcelPanel _panel;
    protected List _data;

    public ExcelToDSSImportCmd(ExcelPanel panel) {
        this._panel = panel;
    }

    public Vector<TimeSeriesContainer> getTimeSeriesContainers() {
        double val;
        TimeSeriesContainer timeSeriesContainer;
        this._data = this._panel.getSelectedData();
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        HecTime time = new HecTime();
        Object obj = this._data.get(0);
        if (!(obj instanceof List)) {
            return containers;
        }
        List row = (List)obj;
        int timeDiff = Integer.MIN_VALUE;
        int numRows = this._data.size();
        boolean foundDate = false;
        for (int c = 0; c < row.size(); ++c) {
            obj = row.get(c);
            if (obj instanceof HecTime) {
                time = (HecTime)obj;
                foundDate = true;
                continue;
            }
            if (obj instanceof Double) {
                timeSeriesContainer = new TimeSeriesContainer();
                timeSeriesContainer.times = new int[numRows];
                timeSeriesContainer.values = new double[numRows];
                timeSeriesContainer.values[0] = val = ((Double)obj).doubleValue();
                containers.add(timeSeriesContainer);
                continue;
            }
            if (!(obj instanceof String)) continue;
            val = RMAIO.parseDouble(obj);
            if (Const.isDefined((double)val)) {
                timeSeriesContainer = new TimeSeriesContainer();
                timeSeriesContainer.times = new int[numRows];
                timeSeriesContainer.values = new double[numRows];
                timeSeriesContainer.values[0] = val;
                containers.add(timeSeriesContainer);
                continue;
            }
            if (time.isDefined()) continue;
            String objStr = (String)obj;
            time.set(objStr);
        }
        if (!foundDate && !this.askForDataColumns()) {
            return containers;
        }
        if (containers.size() == 0) {
            return containers;
        }
        if (!time.isDefined() && time.isDateDefined()) {
            time.setTime("2400");
        }
        if (time.isDefined()) {
            for (int i = 0; i < containers.size(); ++i) {
                timeSeriesContainer = containers.elementAt(i);
                timeSeriesContainer.times[0] = time.value();
            }
        }
        boolean irregular = false;
        for (int r = 1; r < this._data.size(); ++r) {
            obj = this._data.get(r);
            if (!(obj instanceof List)) continue;
            time.setUndefined();
            int count = 0;
            row = (List)obj;
            for (int c = 0; c < row.size(); ++c) {
                obj = row.get(c);
                if (obj instanceof HecTime) {
                    time = (HecTime)obj;
                    continue;
                }
                if (obj instanceof Double) {
                    timeSeriesContainer = containers.elementAt(count++);
                    timeSeriesContainer.values[r] = val = ((Double)obj).doubleValue();
                    continue;
                }
                if (!(obj instanceof String)) continue;
                val = RMAIO.parseDouble(obj);
                if (RMAConst.isValidValue((double)val)) {
                    timeSeriesContainer = containers.elementAt(count++);
                    timeSeriesContainer.values[r] = val;
                    continue;
                }
                if (obj.toString().length() == 0) {
                    timeSeriesContainer = containers.elementAt(count++);
                    timeSeriesContainer.values[r] = -3.4028234663852886E38;
                    continue;
                }
                if (time.isDefined()) continue;
                String objStr = (String)obj;
                time.set(objStr);
            }
            if (!time.isDefined() && time.isDateDefined()) {
                time.setTime("2400");
            }
            if (!time.isDefined()) continue;
            for (int i = 0; i < containers.size(); ++i) {
                timeSeriesContainer = containers.elementAt(i);
                timeSeriesContainer.times[r] = time.value();
            }
            timeSeriesContainer = containers.elementAt(0);
            if (r == 1) {
                timeDiff = timeSeriesContainer.times[1] - timeSeriesContainer.times[0];
            }
            if (irregular || r <= 1 || timeSeriesContainer.times[r] - timeSeriesContainer.times[r - 1] == timeDiff) continue;
            irregular = true;
        }
        for (int i = 0; i < containers.size(); ++i) {
            timeSeriesContainer = containers.elementAt(i);
            timeSeriesContainer.numberValues = numRows;
            if (!irregular && timeDiff > 0) {
                timeSeriesContainer.interval = timeDiff;
            }
            if (numRows <= 0 || timeSeriesContainer.times[0] <= 0) continue;
            timeSeriesContainer.startTime = timeSeriesContainer.times[0];
            timeSeriesContainer.endTime = timeSeriesContainer.times[numRows - 1];
        }
        return containers;
    }

    protected boolean askForDataColumns() {
        int cols = 0;
        if (this._data.size() > 0) {
            Object obj = this._data.get(0);
            if (!(obj instanceof List)) {
                return false;
            }
            List row = (List)obj;
            cols = row.size();
        }
        if (cols == 0) {
            return false;
        }
        String[] columns = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columns[i] = String.valueOf(cols + 1);
        }
        return true;
    }
}

