/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.dssvue.collections;

import hec.plugins.dssvue.collections.OverwriteCaret;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class OverwritableTextField
extends JTextField {
    protected Caret overwriteCaret = new OverwriteCaret();
    protected Caret insertCaret;
    protected static boolean overwriting = true;
    public static final String toggleOverwriteAction = "toggle-overwrite";
    protected static Keymap sharedKeymap;
    protected static final String keymapName = "OverwriteMap";
    protected static final Action[] defaultActions;
    protected static JTextComponent.KeyBinding[] bindings;

    public OverwritableTextField() {
        this(null, null, 0);
    }

    public OverwritableTextField(String text) {
        this(null, text, 0);
    }

    public OverwritableTextField(int columns) {
        this(null, null, columns);
    }

    public OverwritableTextField(String text, int columns) {
        this(null, text, columns);
    }

    public OverwritableTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        super.setCaret(overwriting ? this.overwriteCaret : this.insertCaret);
    }

    @Override
    public void setKeymap(Keymap map) {
        if (map == null) {
            super.setKeymap(null);
            sharedKeymap = null;
            return;
        }
        if (this.getKeymap() == null) {
            if (sharedKeymap == null) {
                OverwritableTextField.removeKeymap(keymapName);
                sharedKeymap = OverwritableTextField.addKeymap(keymapName, map);
                OverwritableTextField.loadKeymap(sharedKeymap, bindings, defaultActions);
            }
            map = sharedKeymap;
        }
        super.setKeymap(map);
    }

    @Override
    public void replaceSelection(String content) {
        Document doc = this.getDocument();
        if (doc != null && overwriting && this.getSelectionStart() == this.getSelectionEnd()) {
            int length;
            int insertPosition = this.getCaretPosition();
            int overwriteLength = doc.getLength() - insertPosition;
            if (overwriteLength > (length = content.length())) {
                overwriteLength = length;
            }
            try {
                doc.remove(insertPosition, overwriteLength);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.replaceSelection(content);
    }

    public static void setOverwriting(boolean overwriting) {
        OverwritableTextField.overwriting = overwriting;
    }

    public static boolean isOverwriting() {
        return overwriting;
    }

    @Override
    public void setCaret(Caret caret) {
        this.insertCaret = caret;
    }

    public void setOverwriteCaret(Caret caret) {
        this.overwriteCaret = caret;
    }

    public Caret getOverwriteCaret() {
        return this.overwriteCaret;
    }

    @Override
    public void processFocusEvent(FocusEvent evt) {
        if (evt.getID() == 1004) {
            this.selectCaret();
        }
        super.processFocusEvent(evt);
    }

    protected void selectCaret() {
        Caret newCaret;
        Caret caret = newCaret = overwriting ? this.overwriteCaret : this.insertCaret;
        if (newCaret != this.getCaret()) {
            Caret caret2 = this.getCaret();
            int mark = caret2.getMark();
            int dot = caret2.getDot();
            caret2.setVisible(false);
            super.setCaret(newCaret);
            newCaret.setDot(mark);
            newCaret.moveDot(dot);
            newCaret.setVisible(true);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame("Overwrite test");
        OverwritableTextField tf = new OverwritableTextField(20);
        f.getContentPane().add((Component)tf, "North");
        tf = new OverwritableTextField(20);
        f.getContentPane().add((Component)tf, "South");
        f.pack();
        f.setVisible(true);
    }

    static {
        defaultActions = new Action[]{new ToggleOverwriteAction()};
        bindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 0), toggleOverwriteAction)};
    }

    public static class ToggleOverwriteAction
    extends TextAction {
        ToggleOverwriteAction() {
            super(OverwritableTextField.toggleOverwriteAction);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OverwritableTextField.setOverwriting(!OverwritableTextField.isOverwriting());
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof OverwritableTextField) {
                OverwritableTextField field = (OverwritableTextField)target;
                field.selectCaret();
            }
        }
    }
}

