/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.dssvue.collections;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

class OverwriteCaret
extends DefaultCaret {
    protected static final int MIN_WIDTH = 8;

    OverwriteCaret() {
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            try {
                JTextComponent comp = this.getComponent();
                TextUI mapper = comp.getUI();
                Rectangle r2 = mapper.modelToView(comp, this.getDot() + 1);
                int width = r2.x - r.x;
                if (width == 0) {
                    width = 8;
                }
                comp.repaint(r.x, r.y, width, r.height);
                this.x = r.x;
                this.y = r.y;
                this.width = width;
                this.height = r.height;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible()) {
            try {
                JTextComponent comp = this.getComponent();
                TextUI mapper = comp.getUI();
                Rectangle r1 = mapper.modelToView(comp, this.getDot());
                Rectangle r2 = mapper.modelToView(comp, this.getDot() + 1);
                g = g.create();
                g.setColor(comp.getForeground());
                g.setXORMode(comp.getBackground());
                int width = r2.x - r1.x;
                if (width == 0) {
                    width = 8;
                }
                g.fillRect(r1.x, r1.y, width, r1.height);
                g.dispose();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

