/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclineg2dplot;

import com.rma.paint.isoclineg2dplot.IsoclineG2dObject;
import com.rma.paint.isoclinepaint.BiFunction;
import com.rma.paint.isoclinepaint.Gradient;
import com.rma.paint.isoclinepaint.IsoclinePaint;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.geometry.Axis;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import rma.util.RMAIO;

public class IcoclineG2dGlyph
extends G2dGlyph {
    WorldPt crossHairPt = null;
    BufferedImage crossHairImg;
    WorldRect mPreviousWorldRect;
    BufferedImage image;
    private List<RepaintCallable> repaintCallables = new ArrayList<RepaintCallable>();
    ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public IcoclineG2dGlyph(Viewport view, IsoclineG2dObject map, Scale scl) {
        super(view, (G2dObject)map, scl);
        URL url = Thread.currentThread().getContextClassLoader().getResource("com/rma/paint/isoclineg2dplot/Red_Point.gif");
        try {
            this.crossHairImg = ImageIO.read(url);
        }
        catch (IOException e) {
            Logger.getLogger(IcoclineG2dGlyph.class.getName()).log(Level.WARNING, "Error loading crosshair image", e);
        }
    }

    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        Point point = e.getPoint();
        Scale scale = this.getScale();
        double x2e = scale.x2e(point.x);
        double y2n = scale.y2n(point.y);
        HecTime time = new HecTime((int)x2e, 11);
        ((IsoclineG2dObject)this.getG2dObject()).objectSelect(new WorldPt(x2e, y2n));
        return "<html>" + this.getG2dObject().getName() + "<br>[" + time.dateAndTime(4) + ", " + RMAIO.setPrecision2((double)y2n, (int)2) + "]</html>";
    }

    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        return false;
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        return false;
    }

    public WorldRect getBounds() {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy");
        DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HHmm");
        WorldRect rect2 = super.getBounds();
        WorldRect rect = new WorldRect(rect2);
        LocalDateTime time1 = LocalDateTime.ofEpochSecond((long)rect.w, 0, ZoneOffset.UTC);
        HecTime time = new HecTime(dateFormat.format(time1), timeFormat.format(time1));
        rect.w = time.value();
        time1 = LocalDateTime.ofEpochSecond((long)rect.e, 0, ZoneOffset.UTC);
        time = new HecTime(dateFormat.format(time1), timeFormat.format(time1));
        rect.e = time.value();
        return rect;
    }

    public Gradient getGradient() {
        IsoclineG2dObject g2dObj = (IsoclineG2dObject)this.getG2dObject();
        return g2dObj.getColorGradient();
    }

    private boolean compare(WorldRect wr1, WorldRect wr2) {
        if (wr1 == wr2) {
            return true;
        }
        if (wr1 == null || wr2 == null) {
            return false;
        }
        return wr1.e == wr2.e && wr1.w == wr2.w && wr1.s == wr2.s && wr1.n == wr2.n;
    }

    public void draw(Graphics g) {
        boolean isDirty = false;
        Dimension d = this._viewport.getSize();
        if (this.image == null || (double)this.image.getWidth() != d.getWidth() || (double)this.image.getHeight() != d.getHeight()) {
            isDirty = true;
            this.image = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
        }
        Scale scale = this.getScale();
        Axis xaxis = scale.getAxis(0);
        Axis yaxis = scale.getAxis(1);
        WorldRect currentWorldRect = new WorldRect(xaxis.getActMin(), yaxis.getActMax(), xaxis.getActMax(), yaxis.getActMin());
        if (this.mPreviousWorldRect == null || !this.compare(currentWorldRect, this.mPreviousWorldRect)) {
            isDirty = true;
        }
        if (isDirty) {
            IsoclineG2dObject g2dObj = (IsoclineG2dObject)this.getG2dObject();
            BiFunction<Double, Double, Double> function = g2dObj.getFunction();
            Gradient cc = this.getGradient();
            double viewMin = scale.getAxis(0).getViewMin();
            double viewMax = scale.getAxis(0).getViewMax();
            HecTime time = new HecTime((int)viewMin, 11);
            DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy, HH:mm");
            LocalDateTime ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
            viewMin = ldt.toEpochSecond(ZoneOffset.UTC);
            time = new HecTime((int)viewMax, 11);
            ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
            viewMax = ldt.toEpochSecond(ZoneOffset.UTC);
            double viewYMin = scale.getAxis(1).getViewMin();
            double viewYMax = scale.getAxis(1).getViewMax();
            int yparamId = ((IsoclineG2dObject)this.getG2dObject()).getYParameterId();
            int unitSystem = ((IsoclineG2dObject)this.getG2dObject()).getUnitSystem();
            if (yparamId != -1 && unitSystem != 0 && this._scale.getDisplayUnitSystem() != 0) {
                try {
                    viewYMin = Units.convertUnits((double)viewYMin, (int)yparamId, (int)this._scale.getDisplayUnitSystem(), (int)unitSystem);
                    viewYMax = Units.convertUnits((double)viewYMax, (int)yparamId, (int)this._scale.getDisplayUnitSystem(), (int)unitSystem);
                }
                catch (UnitsConversionException ex) {
                    Logger.getLogger(IcoclineG2dGlyph.class.getName()).log(Level.WARNING, "Isocline draw : units conversion exception", ex);
                }
            }
            boolean inverted = !scale.getAxis(1).isReversed();
            double lowerBounds = inverted ? viewYMax : viewYMin;
            double upperBounds = inverted ? viewYMin : viewYMax;
            Rectangle2D.Double viewWorldBounds = new Rectangle2D.Double(viewMin, lowerBounds, viewMax - viewMin, upperBounds - lowerBounds);
            IsoclinePaint paint = new IsoclinePaint(viewWorldBounds, function, cc);
            Viewport viewport = this.getViewport();
            Rectangle bounds1 = viewport.getBounds();
            bounds1.x = 0;
            bounds1.y = 0;
            Graphics2D bufG2d = (Graphics2D)this.image.getGraphics();
            bufG2d.setComposite(AlphaComposite.Src);
            bufG2d.setColor(new Color(0, 0, 0, 0));
            bufG2d.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
            bufG2d.setPaint((Paint)paint);
            bufG2d.fill(bounds1);
            bufG2d.dispose();
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.drawImage((Image)this.image, 0, 0, null);
        if (this.crossHairPt != null && this.crossHairImg != null) {
            LocalPt lpt = new LocalPt(this._scale.e2x(this.crossHairPt.e), this._scale.n2y(this.crossHairPt.n));
            g2d.translate(lpt.x - this.crossHairImg.getWidth() / 2, lpt.y - this.crossHairImg.getHeight() / 2);
            g2d.drawImage((Image)this.crossHairImg, 0, 0, null);
        }
        this.mPreviousWorldRect = currentWorldRect;
        g2d.dispose();
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        Scale scale = this.getScale();
        double x2e = scale.x2e(pt.x);
        double y2n = scale.y2n(pt.y);
        HecTime time = new HecTime((int)x2e, 11);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy, HH:mm");
        LocalDateTime ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
        x2e = ldt.toEpochSecond(ZoneOffset.UTC);
        ((IsoclineG2dObject)this.getG2dObject()).objectSelect(new WorldPt(x2e, y2n));
        return true;
    }

    public boolean pointerOver(LocalPt pt) {
        Scale scale = this.getScale();
        double x2e = scale.x2e(pt.x);
        double y2n = scale.y2n(pt.y);
        this.crossHairPt = new WorldPt(x2e, y2n);
        HecTime time = new HecTime((int)x2e, 11);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy, HH:mm");
        LocalDateTime ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
        ((IsoclineG2dObject)this.getG2dObject()).pointOver(Double.valueOf(ldt.toEpochSecond(ZoneOffset.UTC)), y2n);
        for (RepaintCallable repaintCallable : this.repaintCallables) {
            repaintCallable.setCanceled(true);
        }
        this.repaintCallables.clear();
        RepaintCallable c = new RepaintCallable();
        this.repaintCallables.add(c);
        this.executor.submit(c);
        return true;
    }

    private class RepaintCallable
    implements Callable<Boolean> {
        boolean canceled = false;

        private RepaintCallable() {
        }

        public void setCanceled(boolean t) {
            this.canceled = t;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.canceled) {
                return true;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IcoclineG2dGlyph.this._viewport.setDirty();
                    IcoclineG2dGlyph.this._viewport.repaint();
                    IcoclineG2dGlyph.this.repaintCallables.remove(RepaintCallable.this);
                }
            });
            return true;
        }
    }
}

