/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclineg2dplot;

import com.rma.paint.isoclineg2dplot.IsoclineContoursG2dObject;
import com.rma.paint.isoclinepaint.DoubleArrayFunction;
import com.rma.paint.isoclinepaint.Function;
import hec.geometry.Scale;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class IsoclineContoursG2dGlyph
extends G2dGlyph {
    public IsoclineContoursG2dGlyph(Viewport view, IsoclineContoursG2dObject g2dObject, Scale scale) {
        super(view, (G2dObject)g2dObject, scale);
    }

    public WorldRect getBounds() {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy");
        DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HHmm");
        WorldRect rect2 = super.getBounds();
        WorldRect rect = new WorldRect(rect2);
        LocalDateTime time1 = LocalDateTime.ofEpochSecond((long)rect.w, 0, ZoneOffset.UTC);
        HecTime time = new HecTime(dateFormat.format(time1), timeFormat.format(time1));
        rect.w = time.value();
        time1 = LocalDateTime.ofEpochSecond((long)rect.e, 0, ZoneOffset.UTC);
        time = new HecTime(dateFormat.format(time1), timeFormat.format(time1));
        rect.e = time.value();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g) {
        IsoclineContoursG2dObject g2dObect = (IsoclineContoursG2dObject)this.getG2dObject();
        if (!g2dObect.getShowContourLines()) {
            return;
        }
        List<Function<Double, Double>> contourFunctions = g2dObect.getContourFunctions();
        double[][] timeRating = new double[2][2];
        Scale scale = this.getScale();
        double viewMin = scale.getAxis(0).getViewMin();
        double viewMax = scale.getAxis(0).getViewMax();
        double localViewMin = scale.e2x(viewMin);
        double localViewMax = scale.e2x(viewMax);
        timeRating[0][0] = viewMin;
        timeRating[0][1] = viewMax;
        HecTime time = new HecTime((int)viewMin, 11);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("ddMMMyyyy, HH:mm");
        LocalDateTime ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
        viewMin = ldt.toEpochSecond(ZoneOffset.UTC);
        time = new HecTime((int)viewMax, 11);
        ldt = LocalDateTime.parse(time.dateAndTime(4), dateFormat);
        viewMax = ldt.toEpochSecond(ZoneOffset.UTC);
        timeRating[1][0] = viewMin;
        timeRating[1][1] = viewMax;
        DoubleArrayFunction hTimeToLocalDate = new DoubleArrayFunction(timeRating);
        this.getViewport().getVisibleArea();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.WHITE);
        try {
            for (Function<Double, Double> contourLevel : contourFunctions) {
                FunctionPathIterator functionPathIterator = new FunctionPathIterator(localViewMin, localViewMax, 2.0, (Function<Double, Double>)hTimeToLocalDate, contourLevel);
                FunctionShape fs = new FunctionShape(functionPathIterator);
                g2d.draw(fs);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    private class FunctionPathIterator
    implements PathIterator {
        private final Function<Double, Double> timeRating;
        private final double localDelta;
        private final double localMax;
        private final double localMin;
        private double currentLocalValue;
        private final Function<Double, Double> timeToYValueFunction;

        public FunctionPathIterator(double localMin, double localMax, double localDelta, Function<Double, Double> timeRating, Function<Double, Double> timeToYValueFunction) {
            this.localMin = localMin;
            this.localMax = localMax;
            this.localDelta = localDelta;
            this.timeRating = timeRating;
            this.timeToYValueFunction = timeToYValueFunction;
            this.currentLocalValue = localMin;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.currentLocalValue > this.localMax;
        }

        @Override
        public void next() {
            this.currentLocalValue += this.localDelta;
        }

        @Override
        public int currentSegment(float[] coords) {
            double x2e = IsoclineContoursG2dGlyph.this.getScale().x2e((int)this.currentLocalValue);
            Double epocSeconds = (Double)this.timeRating.compute((Object)x2e);
            Double yvalue = (Double)this.timeToYValueFunction.compute((Object)epocSeconds);
            coords[0] = (float)this.currentLocalValue;
            coords[1] = IsoclineContoursG2dGlyph.this.getScale().n2y(yvalue.doubleValue());
            return this.currentLocalValue == this.localMin ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            double x2e = IsoclineContoursG2dGlyph.this.getScale().x2e((int)this.currentLocalValue);
            Double epocSeconds = (Double)this.timeRating.compute((Object)x2e);
            Double yvalue = (Double)this.timeToYValueFunction.compute((Object)epocSeconds);
            coords[0] = this.currentLocalValue;
            coords[1] = IsoclineContoursG2dGlyph.this.getScale().n2y(yvalue.doubleValue());
            return this.currentLocalValue == this.localMin ? 0 : 1;
        }
    }

    private class FunctionShape
    implements Shape {
        PathIterator iter;

        public FunctionShape(PathIterator iter) {
            this.iter = iter;
        }

        @Override
        public Rectangle getBounds() {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds();
        }

        @Override
        public boolean contains(double x, double y) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().contains(x, y);
        }

        @Override
        public boolean contains(Point2D p) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().contains(p);
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().intersects(x, y, w, h);
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().intersects(r);
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().contains(x, y, w, h);
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return IsoclineContoursG2dGlyph.this.getViewport().getBounds().contains(r);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return this.iter;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return this.iter;
        }
    }
}

