/*
 * Decompiled with CFR 0.152.
 */
package com.rma.paint.isoclineg2dplot;

import com.rma.paint.isoclineg2dplot.IcoclineG2dGlyph;
import hec.geometry.LocalPt;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class TargetViewport
extends Viewport {
    LocalPt crosshairs = null;

    public TargetViewport() {
    }

    public TargetViewport(G2dPanel p) {
        super(p);
    }

    public void pointerOver(LocalPt pt) {
        this.crosshairs = pt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TargetViewport.this.revalidate();
                TargetViewport.this.repaint();
            }
        });
        Vector glyphVector = this.getGlyphVector();
        for (Object object : glyphVector) {
            if (!(object instanceof IcoclineG2dGlyph)) continue;
            ((IcoclineG2dGlyph)((Object)object)).pointerOver(pt);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.crosshairs == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setStroke(new BasicStroke(1.25f));
        graphics.setColor(Color.black);
        graphics.drawLine(this.crosshairs.x, 0, this.crosshairs.x, this.getHeight());
        graphics.drawLine(0, this.crosshairs.y, this.getWidth(), this.crosshairs.y);
        graphics.dispose();
    }
}

