/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.lookup.Lookup;
import usace.metrics.noop.NoOpMetricsFactory;
import usace.metrics.services.Metrics;
import usace.metrics.services.MetricsFactory;
import usace.metrics.services.MetricsFactoryProvider;
import usace.metrics.services.MetricsFilter;
import usace.metrics.services.MetricsInitializationException;
import usace.metrics.services.MetricsUtil;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsInvalidValueException;

public class MetricsService {
    private static final Logger LOGGER = Logger.getLogger(MetricsService.class.getSimpleName());
    private static final NoOpMetricsFactory NO_OP_FACTORY = new NoOpMetricsFactory();
    private boolean _lookupFailure = false;
    private Class<? extends MetricsFactoryProvider> _foundMetricsFactory;
    private MetricsFactory _metricsFactory;
    private final MetricsConfig _config;
    private final PropertyChangeListener _configChangedListener = this::configUpdated;

    public MetricsService(MetricsConfig config) {
        if (config == null) {
            throw new MetricsInitializationException("Unable to initialize metrics with a null configuration.");
        }
        this._config = config;
        this._config.addWeakPropertyChangeListener(this._configChangedListener);
    }

    private void configUpdated(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("metrics-enabled")) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if ((oldValue == null || Boolean.FALSE.equals(oldValue)) && Boolean.TRUE.equals(newValue)) {
                this.clearMetricData();
            }
        }
    }

    private MetricsFactory getMetricsFactory() {
        MetricsFactoryProvider provider = (MetricsFactoryProvider)Lookup.getDefault().lookup(MetricsFactoryProvider.class);
        MetricsFactory output = this._metricsFactory;
        if (output == null && provider != null && (output = provider.buildFactoryForService(this)) == null) {
            LOGGER.log(Level.SEVERE, provider.getClass().getSimpleName() + " returned null when building a factory.  This is a break in the contract.");
        }
        if (output != null && this._foundMetricsFactory != provider.getClass()) {
            LOGGER.log(Level.FINE, "Using {0} to build Metrics.", output.getClass().getSimpleName());
            this._foundMetricsFactory = provider.getClass();
            output = this._metricsFactory = provider.buildFactoryForService(this);
        }
        return output;
    }

    public Metrics createMetrics(String ... paths) {
        Metrics output;
        String pathErrors = MetricsUtil.getPathErrors(paths);
        if (pathErrors != null) {
            throw new MetricsInvalidValueException("Paths provided for creating metrics is invalid: " + pathErrors);
        }
        if (this._lookupFailure || !this._config.isMetricsEnabled()) {
            return NO_OP_FACTORY.createMetrics(paths);
        }
        MetricsFactory factory = this.getMetricsFactory();
        if (factory != null) {
            output = factory.createMetrics(paths);
            if (output == null) {
                LOGGER.log(Level.SEVERE, "{0} is not following the contract for Metrics Factories. Metrics Factories need to always return non-null values! Using default implementation.", factory.getClass().toString());
                output = NO_OP_FACTORY.createMetrics(paths);
                this._lookupFailure = true;
            }
        } else {
            LOGGER.log(Level.SEVERE, "Could not find a Metrics Factory.  Using default No-Op factory.  What happened?  Why didn't we at least get the No Op version?");
            output = NO_OP_FACTORY.createMetrics(paths);
            this._lookupFailure = true;
        }
        return output;
    }

    public Metrics createMetrics(Metrics originalMetrics, String ... paths) {
        Metrics output = originalMetrics;
        if (paths.length != 0) {
            output = originalMetrics == null ? this.createMetrics(paths) : originalMetrics.createMetrics(paths);
        }
        return output;
    }

    public void setFilter(MetricsFilter filter) {
        MetricsFactory factory = this.getMetricsFactory();
        if (factory != null) {
            factory.setMetricsFilter(filter);
        }
    }

    public boolean clearMetricData() {
        boolean output = false;
        MetricsFactory factory = this.getMetricsFactory();
        if (factory != null) {
            LOGGER.log(Level.FINE, "Clearing Metrics data");
            Date now = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd kkmm-ss");
            String prefix = format.format(now);
            try {
                this._config.setFilePrefix(prefix);
            }
            catch (MetricsInvalidValueException ex) {
                LOGGER.log(Level.SEVERE, "Unable to set Metrics file prefix to " + prefix, ex);
            }
            output = factory.clearMetrics();
        }
        return output;
    }

    public boolean shutdownMetrics() {
        boolean output = false;
        MetricsFactory factory = this.getMetricsFactory();
        if (factory != null) {
            output = factory.shutdownMetrics();
        }
        return output;
    }

    public MetricsConfig getConfig() {
        return this._config;
    }
}

