/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public final class MetricsUtil {
    private static final String SEPARATOR = "/";

    private MetricsUtil() {
        throw new AssertionError((Object)"Utility class instantiated");
    }

    public static String concatPath(String path, String newPart) {
        if (path == null || newPart == null) {
            return path;
        }
        if (!path.endsWith("\\") && !path.endsWith(SEPARATOR)) {
            String slash = SEPARATOR;
            if (path.indexOf(92) > -1) {
                slash = "\\";
            }
            path = path.concat(slash);
        }
        if (newPart.startsWith("\\") || newPart.startsWith(SEPARATOR)) {
            newPart = newPart.substring(1);
        }
        path = path.concat(newPart);
        return path;
    }

    public static String getPathErrors(String[] paths) {
        String error = null;
        if (paths == null) {
            error = "Path values are null.";
        } else if (paths.length == 0) {
            error = "Path list is empty";
        }
        return error;
    }

    public static Properties readPropertiesFromSystemProperty(String systemProperty) throws IOException {
        Properties output = null;
        if (systemProperty == null || systemProperty.isEmpty()) {
            throw new IllegalArgumentException("Unable to read system property, the property requested is either null or empty.");
        }
        String property = System.getProperty(systemProperty);
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    output = new Properties();
                    output.load(reader);
                }
            } else {
                throw new FileNotFoundException("Unable to find configuration file for system property '" + systemProperty + "'." + System.lineSeparator() + "Expected file location: " + path.toAbsolutePath().toString() + System.lineSeparator() + "System property value: " + property);
            }
        }
        return output;
    }
}

