/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import rma.util.lookup.Lookup;
import usace.metrics.services.MetricsApp;
import usace.metrics.services.config.MetricsInvalidValueException;
import usace.metrics.services.config.Options;
import usace.metrics.services.config.SavableOptions;

public class MetricsConfig {
    public static final String METRICS_CSV_DELIMITER_PREF = "csv-delim";
    public static final String METRICS_ENABLED_PREF = "metrics-enabled";
    public static final String METRICS_FILE_LOCATION_PREF = "metrics-file-location";
    public static final String METRICS_FILE_PREFIX_PREF = "metrics-file-prefix";
    public static final String METRICS_MAX_FILES_PREF = "metrics-max-files-prefix";
    public static final boolean DEFAULT_METRICS_ENABLED = false;
    public static final String DEFAULT_FILE_PREFIX = "";
    public static final String DEFAULT_FILE_LOCATION = "";
    public static final String DEFAULT_CSV_DELIMITER = "|";
    public static final int DEFAULT_MAX_FILES_STORED = 5;
    private final List<Options> _options;
    private final ReentrantReadWriteLock _optionLock = new ReentrantReadWriteLock();
    private final List<WeakReference<PropertyChangeListener>> _weakListeners = new ArrayList<WeakReference<PropertyChangeListener>>();
    private final ReentrantReadWriteLock _propertyListenerLock = new ReentrantReadWriteLock();

    MetricsConfig(List<Options> options) {
        this._options = new ArrayList<Options>(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getProperty(String property, BiFunction<Options, String, T> func, T def) {
        ReentrantReadWriteLock.ReadLock lock = this._optionLock.readLock();
        try {
            lock.lock();
            Object object = this._options.stream().filter(Objects::nonNull).map(opts -> func.apply((Options)opts, property)).filter(Objects::nonNull).findFirst().orElse(def);
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWeakPropertyChangeListener(PropertyChangeListener listener) {
        ReentrantReadWriteLock.WriteLock writeLock = this._propertyListenerLock.writeLock();
        try {
            writeLock.lock();
            WeakReference<PropertyChangeListener> removalRef = null;
            for (WeakReference<PropertyChangeListener> ref : this._weakListeners) {
                PropertyChangeListener weakListener = (PropertyChangeListener)ref.get();
                if (weakListener != listener) continue;
                removalRef = ref;
                break;
            }
            if (removalRef != null) {
                this._weakListeners.remove(removalRef);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangedEvent(String property, Object oldValue, Object newValue) {
        ArrayList<WeakReference<PropertyChangeListener>> deadRefs = new ArrayList<WeakReference<PropertyChangeListener>>();
        ReentrantReadWriteLock.ReadLock read = this._propertyListenerLock.readLock();
        try {
            read.lock();
            for (WeakReference<PropertyChangeListener> ref : this._weakListeners) {
                PropertyChangeListener listener = (PropertyChangeListener)ref.get();
                if (listener != null) {
                    listener.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
                    continue;
                }
                deadRefs.add(ref);
            }
        }
        finally {
            read.unlock();
        }
        this.cleanWeakListenerRefs(deadRefs);
    }

    private void cleanWeakListenerRefs(List<WeakReference<PropertyChangeListener>> deadRefs) {
        if (!deadRefs.isEmpty()) {
            ReentrantReadWriteLock.WriteLock writeLock = this._propertyListenerLock.writeLock();
            try {
                writeLock.lock();
                this._weakListeners.removeAll(deadRefs);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public void addWeakPropertyChangeListener(PropertyChangeListener listener) {
        ReentrantReadWriteLock.WriteLock writeLock = this._propertyListenerLock.writeLock();
        try {
            writeLock.lock();
            this._weakListeners.add(new WeakReference<PropertyChangeListener>(listener));
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean getBooleanProperty(String property, boolean def) {
        return this.getProperty(property, Options::getBoolean, def);
    }

    private String getStringProperty(String property, String def) {
        return this.getProperty(property, Options::getString, def);
    }

    private int getIntegerProperty(String property, int def) {
        return this.getProperty(property, Options::getInt, def);
    }

    private boolean putIntegerProperty(String property, int value) {
        return this.putProperty(property, value, SavableOptions::putInt, Options::getInt);
    }

    private boolean putBooleanProperty(String property, boolean value) {
        return this.putProperty(property, value, SavableOptions::putBoolean, Options::getBoolean);
    }

    private boolean putStringProperty(String property, String value) {
        return this.putProperty(property, value, SavableOptions::putString, Options::getString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean putProperty(String property, T value, TriFunction<SavableOptions, String, T, Boolean> setter, BiFunction<Options, String, T> getter) {
        boolean success = false;
        ReentrantReadWriteLock.WriteLock writeLock = this._optionLock.writeLock();
        Object oldValue = this.getProperty(property, getter, null);
        try {
            writeLock.lock();
            List options = this._options.stream().filter(SavableOptions.class::isInstance).map(SavableOptions.class::cast).collect(Collectors.toList());
            Collections.reverse(options);
            for (SavableOptions option : options) {
                Boolean successful = setter.apply(option, property, (SavableOptions)value);
                if (!Objects.equals(successful, Boolean.TRUE)) continue;
                success = true;
                break;
            }
        }
        finally {
            writeLock.unlock();
        }
        if (success) {
            this.firePropertyChangedEvent(property, oldValue, value);
        }
        return success;
    }

    protected MetricsApp getMetricsApp() {
        return (MetricsApp)Lookup.getDefault().lookup(MetricsApp.class);
    }

    public boolean isMetricsEnabled() {
        MetricsApp app = this.getMetricsApp();
        boolean globallyEnabled = true;
        if (app != null) {
            globallyEnabled = app.isMetricsEnabled();
        }
        return this.getBooleanProperty(METRICS_ENABLED_PREF, false) && globallyEnabled;
    }

    public String getFilePrefix() {
        return this.getStringProperty(METRICS_FILE_PREFIX_PREF, "");
    }

    public String getPreferredFileLocation() {
        return this.getStringProperty(METRICS_FILE_LOCATION_PREF, "");
    }

    public String getCsvDelimiter() {
        return this.getStringProperty(METRICS_CSV_DELIMITER_PREF, DEFAULT_CSV_DELIMITER);
    }

    public int getMaxFilesStored() {
        return this.getIntegerProperty(METRICS_MAX_FILES_PREF, 5);
    }

    public boolean setFilePrefix(String filePrefix) {
        if (filePrefix == null || filePrefix.isEmpty()) {
            throw new MetricsInvalidValueException("Null or empty file prefix provided.");
        }
        return this.putStringProperty(METRICS_FILE_PREFIX_PREF, filePrefix);
    }

    public boolean setMetricsEnabled(boolean enabled) {
        return this.putBooleanProperty(METRICS_ENABLED_PREF, enabled);
    }

    public boolean setMaxFilesStored(int maxFiles) {
        if (maxFiles < 0) {
            throw new MetricsInvalidValueException("Max files stored must be greater than or equal to 0");
        }
        return this.putIntegerProperty(METRICS_MAX_FILES_PREF, maxFiles);
    }

    public boolean setPreferredFileLocation(String preferredFileLocation) {
        if (preferredFileLocation == null || preferredFileLocation.isEmpty()) {
            throw new MetricsInvalidValueException("Null or empty Preferred File Location provided.");
        }
        return this.putStringProperty(METRICS_FILE_LOCATION_PREF, preferredFileLocation);
    }

    public Path getMetricsFileLocation() {
        String prefLoc;
        MetricsApp app = this.getMetricsApp();
        Path rootPath = null;
        if (app != null) {
            rootPath = app.getMetricsRootDirectory();
        }
        if (rootPath == null) {
            rootPath = Paths.get("", new String[0]);
        }
        if ((prefLoc = this.getPreferredFileLocation()) != null) {
            rootPath = rootPath.resolve(prefLoc);
        }
        return rootPath;
    }

    public boolean setCsvDelimiter(String delim) {
        if (delim == null || delim.isEmpty()) {
            throw new MetricsInvalidValueException("CSV Delimiter provided is either null or empty.");
        }
        return this.putStringProperty(METRICS_CSV_DELIMITER_PREF, delim);
    }

    @FunctionalInterface
    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

