/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsConfigOptions;
import usace.metrics.services.config.Options;
import usace.metrics.services.config.PreferencesOptions;
import usace.metrics.services.config.PropertiesOptions;
import usace.metrics.services.config.SystemOptions;

public class MetricsConfigBuilder {
    private final List<Options> _optionsList = new ArrayList<Options>();

    public final MetricsConfig build() {
        return new MetricsConfig(this._optionsList);
    }

    public static MetricsConfig forDefaultSettings(Preferences prefs) {
        return new MetricsConfigBuilder().withPreferenceOptions(prefs).withSystemPropertyOptions().build();
    }

    final List<Options> getOptions() {
        return this._optionsList;
    }

    final void addOptions(Options options) {
        this._optionsList.add(options);
    }

    public final MetricsConfigBuilder withPreferenceOptions(Preferences prefs) {
        this.addOptions(new PreferencesOptions(prefs));
        return this;
    }

    public final MetricsConfigBuilder withSystemPropertyOptions() {
        this.addOptions(new SystemOptions());
        return this;
    }

    public final MetricsConfigBuilder withPropertiesFile(Properties propertiesFile) {
        this.addOptions(new PropertiesOptions(propertiesFile));
        return this;
    }

    public final MetricsConfigBuilder withBackingConfiguration(MetricsConfig backingConfig) {
        this.addOptions(new MetricsConfigOptions(backingConfig));
        return this;
    }
}

