/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.services.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import usace.metrics.services.config.SavableOptions;

final class PreferencesOptions
implements SavableOptions {
    private static final Logger LOGGER = Logger.getLogger(PreferencesOptions.class.getSimpleName());
    private final Preferences _prefs;

    PreferencesOptions(Preferences prefs) {
        this._prefs = prefs;
    }

    @Override
    public Integer getInt(String property) {
        int value;
        Integer output = null;
        if (this.hasProperty(property) && (value = this._prefs.getInt(property, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            output = value;
        }
        return output;
    }

    @Override
    public Boolean getBoolean(String property) {
        Boolean output = null;
        if (this.hasProperty(property)) {
            output = this._prefs.getBoolean(property, false);
        }
        return output;
    }

    @Override
    public String getString(String property) {
        String output = null;
        if (this.hasProperty(property)) {
            output = this._prefs.get(property, null);
        }
        return output;
    }

    @Override
    public boolean putString(String property, String value) {
        this._prefs.put(property, value);
        return true;
    }

    @Override
    public boolean putInt(String property, int value) {
        this._prefs.putInt(property, value);
        return true;
    }

    @Override
    public boolean putBoolean(String property, boolean value) {
        this._prefs.putBoolean(property, value);
        return false;
    }

    private boolean hasProperty(String property) {
        if (this._prefs == null) {
            return false;
        }
        String[] keys = new String[]{};
        try {
            keys = this._prefs.keys();
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, "Unable to access the backing storage system to identify all of the available keys.", ex);
        }
        boolean output = false;
        for (String key : keys) {
            if (!key.equals(property)) continue;
            output = true;
            break;
        }
        return output;
    }
}

