/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import usace.metrics.codahale.CodahaleCounter;
import usace.metrics.codahale.CodahaleHistogram;
import usace.metrics.codahale.CodahaleMeter;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.CodahaleTimer;
import usace.metrics.services.AbstractMetric;
import usace.metrics.services.Counter;
import usace.metrics.services.Histogram;
import usace.metrics.services.Meter;
import usace.metrics.services.Metrics;
import usace.metrics.services.MetricsUtil;
import usace.metrics.services.Timer;
import usace.metrics.services.config.MetricsInvalidValueException;

public class CodahaleMetrics
implements Metrics,
PropertyChangeListener {
    static final String METRICS_DELIMITER = "/";
    private static final String NULL_STRING = "NULL";
    private final CodahaleMetricRegistry _registry;
    private final String _path;
    private final List<PropertyChangeListener> _metricEventListeners = new ArrayList<PropertyChangeListener>();

    CodahaleMetrics(CodahaleMetricRegistry registry, List<PropertyChangeListener> metricEventListeners, String ... paths) {
        this._path = this.buildPathFromArray(paths);
        this._registry = registry;
        this._metricEventListeners.addAll(metricEventListeners);
    }

    private CodahaleMetrics(CodahaleMetrics original, String ... paths) {
        this(original._registry, original._metricEventListeners, paths);
    }

    private String buildPathFromArray(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String addPath;
            boolean canAddDelimiter;
            String curPath = paths[i];
            boolean bl = canAddDelimiter = i != 0;
            if (curPath != null) {
                addPath = curPath.trim();
                if (addPath.isEmpty()) {
                    canAddDelimiter = false;
                }
            } else {
                addPath = NULL_STRING;
                canAddDelimiter = false;
            }
            if (canAddDelimiter) {
                sb.append(METRICS_DELIMITER);
            }
            sb.append(addPath);
        }
        return sb.toString().trim();
    }

    public String getPath() {
        return this._path;
    }

    public Metrics createMetrics(String ... paths) {
        CodahaleMetrics output = this;
        String pathErrors = MetricsUtil.getPathErrors((String[])paths);
        if (pathErrors != null) {
            throw new MetricsInvalidValueException("Unable to create metrics for paths: " + pathErrors);
        }
        if (paths.length > 0) {
            String[] newPaths = new String[paths.length + 1];
            newPaths[0] = this._path;
            System.arraycopy(paths, 0, newPaths, 1, paths.length);
            output = new CodahaleMetrics(this, newPaths);
        }
        return output;
    }

    public Timer createTimer() {
        CodahaleTimer metric = new CodahaleTimer(this._registry, this.getPath());
        metric.addPropertyChangeListener(this);
        return metric;
    }

    public Histogram createHistogram() {
        CodahaleHistogram metric = new CodahaleHistogram(this._registry, this.getPath());
        metric.addPropertyChangeListener(this);
        return metric;
    }

    public Meter createMeter() {
        CodahaleMeter metric = new CodahaleMeter(this._registry, this.getPath());
        metric.addPropertyChangeListener(this);
        return metric;
    }

    public Counter createCounter() {
        CodahaleCounter metric = new CodahaleCounter(this._registry, this.getPath());
        metric.addPropertyChangeListener(this);
        return metric;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String s = evt.getPropertyName();
        if ("metric_update_event".equals(s)) {
            this._metricEventListeners.forEach(pcl -> pcl.propertyChange(evt));
        }
    }

    public boolean remove(AbstractMetric metric) {
        return this._registry.remove(metric.getMetricName());
    }
}

