/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.CodahaleMetrics;
import usace.metrics.codahale.CodahaleMetricsFilter;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.CodahaleReporterBuilder;
import usace.metrics.codahale.reporter.csv.CodahaleCsvReporter;
import usace.metrics.codahale.reporter.json.CodahaleJsonReporter;
import usace.metrics.services.Metrics;
import usace.metrics.services.MetricsFactory;
import usace.metrics.services.MetricsFilter;
import usace.metrics.services.MetricsService;

public class CodahaleMetricsFactory
implements MetricsFactory {
    private static final Logger LOGGER = Logger.getLogger(CodahaleMetricsFactory.class.getName());
    private static final String METRICS_CLEARED_EVENT = "METRICS_CLEARED_EVENT";
    static final String USE_JSON_PREF = "json-metrics";
    private final List<CodahaleReporter> _metricsReporters = new ArrayList<CodahaleReporter>();
    private final List<PropertyChangeListener> _reportListeners = new ArrayList<PropertyChangeListener>();
    private final MetricsService _metricsService;
    private final CodahaleMetricRegistry _registry = new CodahaleMetricRegistry();
    private final UUID _uuid = UUID.randomUUID();
    private CodahaleMetricsFilter _filter = new CodahaleMetricsFilter();

    CodahaleMetricsFactory(MetricsService service) {
        this._metricsService = service;
        SharedMetricRegistries.add((String)this._uuid.toString(), (MetricRegistry)this._registry);
        boolean useJson = Boolean.getBoolean(USE_JSON_PREF);
        if (useJson) {
            this.registerReporter(CodahaleJsonReporter.forRegistry(this._registry));
        } else {
            this.registerReporter(CodahaleCsvReporter.forRegistry(this._registry));
        }
    }

    private void registerReporter(CodahaleReporterBuilder builder) {
        Object rep = ((CodahaleReporterBuilder)((CodahaleReporterBuilder)builder.filter(this._filter)).withConfig(this._metricsService.getConfig())).build();
        this._reportListeners.add((PropertyChangeListener)rep);
        this._metricsReporters.add((CodahaleReporter)rep);
    }

    public Metrics createMetrics(String ... paths) {
        return new CodahaleMetrics(this._registry, this._reportListeners, paths);
    }

    public boolean shutdownMetrics() {
        for (CodahaleReporter c : this._metricsReporters) {
            c.close();
        }
        SharedMetricRegistries.remove((String)this._uuid.toString());
        return true;
    }

    public boolean clearMetrics() {
        boolean wasSuccessful = true;
        SortedSet names = this._registry.getNames();
        for (String s : names) {
            if (this._registry.remove(s)) continue;
            wasSuccessful = false;
        }
        for (PropertyChangeListener pcl : this._reportListeners) {
            pcl.propertyChange(new PropertyChangeEvent(this, METRICS_CLEARED_EVENT, null, null));
        }
        LOGGER.log(Level.FINE, wasSuccessful ? "Successfully cleared metrics." : "Unsuccessfully cleared Metrics.");
        return wasSuccessful;
    }

    public void setMetricsFilter(MetricsFilter filter) {
        this._filter = new CodahaleMetricsFilter(filter);
        for (CodahaleReporter reporter : this._metricsReporters) {
            reporter.setFilter(this._filter);
        }
    }
}

