/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.CodahaleMetricsFilter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;
import usace.metrics.codahale.reporter.MetricReporterFactory;
import usace.metrics.services.config.MetricsConfig;

public abstract class CodahaleReporter
extends ScheduledReporter
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CodahaleReporter.class.getName());
    protected static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final ExecutorService _singleThreadExecutor;
    private final Clock _clock;
    private final Locale _locale;
    private final CopyOnWriteArrayList<String> _unavailableMetricsFiles = new CopyOnWriteArrayList();
    private final MetricReporter<Gauge<?>> _gaugeReporter;
    private final MetricReporter<Histogram> _histogramReporter;
    private final MetricReporter<Timer> _timerReporter;
    private final MetricReporter<Meter> _meterReporter;
    private final MetricReporter<Counter> _counterReporter;
    private boolean _isShutdown = false;
    private CodahaleMetricsFilter _filter;
    private final MetricsConfig _config;
    private File _cachedDirectory;
    private String _lastDirectoryString;

    protected CodahaleReporter(CodahaleMetricRegistry registry, String registryName, Locale locale, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter, MetricReporter<Gauge<?>> gaugeReporter, MetricReporter<Histogram> histogramReporter, MetricReporter<Timer> timerReporter, MetricReporter<Meter> meterReporter, MetricReporter<Counter> counterReporter, MetricsConfig config) {
        super((MetricRegistry)registry, registryName, filter, rateUnit, durationUnit);
        this._config = config;
        this._singleThreadExecutor = Executors.newFixedThreadPool(1);
        this._clock = clock;
        this._locale = locale;
        this._gaugeReporter = gaugeReporter;
        this._histogramReporter = histogramReporter;
        this._timerReporter = timerReporter;
        this._meterReporter = meterReporter;
        this._counterReporter = counterReporter;
    }

    public double convertDuration(double duration) {
        return super.convertDuration(duration);
    }

    public double convertRate(double rate) {
        return super.convertRate(rate);
    }

    public String getRateUnit() {
        return super.getRateUnit();
    }

    public String getDurationUnit() {
        return super.getDurationUnit();
    }

    public final MetricReporter<Gauge<?>> getGaugeReporter() {
        return this._gaugeReporter;
    }

    public final MetricReporter<Histogram> getHistogramReporter() {
        return this._histogramReporter;
    }

    public final MetricReporter<Timer> getTimerReporter() {
        return this._timerReporter;
    }

    public final MetricReporter<Meter> getMeterReporter() {
        return this._meterReporter;
    }

    public final MetricReporter<Counter> getCounterReporter() {
        return this._counterReporter;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
        metricMap.putAll(gauges);
        metricMap.putAll(counters);
        metricMap.putAll(meters);
        metricMap.putAll(timers);
        metricMap.putAll(histograms);
        this.report(metricMap);
    }

    public void report() {
        if (this._isShutdown) {
            return;
        }
        this._singleThreadExecutor.submit(() -> super.report());
    }

    public void start(long period, TimeUnit unit) {
    }

    public void stop() {
        this._isShutdown = true;
        this._singleThreadExecutor.shutdown();
        try {
            if (!this._singleThreadExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this._singleThreadExecutor.shutdownNow();
                if (!this._singleThreadExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    LOGGER.log(Level.SEVERE, "{0}: ScheduledExecutorService did not terminate", this.getClass().getSimpleName());
                }
            }
        }
        catch (InterruptedException ie) {
            this._singleThreadExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private File getDirectory() {
        Path fileLocation = this._config.getMetricsFileLocation();
        if (this._cachedDirectory == null || !Objects.equals(this._lastDirectoryString, fileLocation.toString())) {
            this._lastDirectoryString = fileLocation.toString();
            this._cachedDirectory = fileLocation.toFile();
        }
        return this._cachedDirectory;
    }

    private File getOrCreateFile(String name) {
        File directory = this.getDirectory();
        File output = new File(directory, this.buildFileName(name));
        if (!output.exists()) {
            try {
                output.getParentFile().mkdirs();
                if (output.createNewFile()) {
                    this.deleteOldFiles(name);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Unable to create " + output.getAbsolutePath(), ex);
            }
        }
        return output;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String s = evt.getPropertyName();
        if ("metric_update_event".equals(s)) {
            this.report();
        }
    }

    private void deleteOldFiles(String name) {
        File[] files;
        int diff;
        String fileStyle = name + this.getFileExtension();
        int maxFiles = this.getMaxFilesStored();
        File directory = this.getDirectory();
        if (directory != null && (diff = (files = directory.listFiles((dir, name1) -> name1.endsWith(fileStyle))).length - maxFiles) > 0) {
            ArrayList<File> removedFiles = new ArrayList<File>();
            for (int i = 0; i < diff; ++i) {
                File oldestFile = null;
                for (File f : files) {
                    long lastCreation;
                    Path p = Paths.get(f.getAbsolutePath(), new String[0]);
                    BasicFileAttributeView attrib = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]);
                    try {
                        lastCreation = attrib.readAttributes().creationTime().toMillis();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINE, "IOException while reading file attributes for creation time, using last modified");
                        lastCreation = f.lastModified();
                    }
                    if (removedFiles.contains(f) || oldestFile != null && lastCreation >= oldestFile.lastModified()) continue;
                    oldestFile = f;
                }
                if (oldestFile == null || !oldestFile.delete()) continue;
                removedFiles.add(oldestFile);
            }
        }
    }

    public final int getMaxFilesStored() {
        return this._config.getMaxFilesStored();
    }

    public final String getDelimiter() {
        return this._config.getCsvDelimiter();
    }

    public final String getFilePrefix() {
        return this._config.getFilePrefix();
    }

    private String buildFileName(String name) {
        StringBuilder sb = new StringBuilder(this.getFilePrefix());
        sb.append("_");
        sb.append(name);
        sb.append(this.getFileExtension());
        return sb.toString();
    }

    private void report(Map<String, Metric> metrics) {
        long timestamp = TimeUnit.MILLISECONDS.toMillis(this._clock.getTime());
        File directory = this.getDirectory();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        CodahaleMetricsFilter filter = this.getFilter();
        metrics.entrySet().stream().filter(entry -> filter.matches((String)entry.getKey(), (Metric)entry.getValue())).forEach(metric -> {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                this.reportMetric(timestamp, (String)metric.getKey(), (Metric)metric.getValue());
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.FINE, "Runtime Exception occurred while processing metrics.", ex);
            }
        });
    }

    public final CodahaleMetricsFilter getFilter() {
        CodahaleMetricsFilter output = this._filter;
        if (output == null) {
            output = new CodahaleMetricsFilter();
        }
        return output;
    }

    private <M extends Metric> void reportMetric(long timestamp, String name, M metric) {
        block6: {
            String nameForMetric = MetricReporterFactory.getNameForMetric(metric);
            Path path = this.getOrCreateFile(nameForMetric).toPath();
            try {
                String report;
                boolean wroteToFile = false;
                MetricReporter<M> metricReporter = MetricReporterFactory.getReporter(this, metric);
                if (metricReporter != null && (report = metricReporter.report(this, timestamp, name, metric)) != null) {
                    this.writeHeader(path, metricReporter);
                    this.writeMetric(report, path);
                    wroteToFile = true;
                }
                if (wroteToFile && this._unavailableMetricsFiles.contains(nameForMetric)) {
                    LOGGER.log(Level.FINE, "File access restored: {0}", path.toAbsolutePath());
                    this._unavailableMetricsFiles.remove(nameForMetric);
                }
            }
            catch (FileNotFoundException ex) {
                if (this._unavailableMetricsFiles.addIfAbsent(nameForMetric)) {
                    LOGGER.log(Level.SEVERE, "Metrics File No longer available. The process cannot access the file because it is being used by another process.\nFile referred to: {0}", path.toAbsolutePath());
                }
            }
            catch (IOException e) {
                if (!this._unavailableMetricsFiles.addIfAbsent(nameForMetric)) break block6;
                LOGGER.log(Level.SEVERE, "An error occured when writing the metrics files.", e);
            }
        }
    }

    protected abstract void writeHeader(Path var1, MetricReporter<? extends Metric> var2) throws IOException;

    private void writeMetric(String report, Path path) throws IOException {
        Files.write(path, Collections.singletonList(report), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    protected abstract String getFileExtension();

    public abstract String report(long var1, String var3, String var4, Map<MetricColumn, Object> var5, Locale var6);

    public abstract String getHeader(Map<MetricColumn, Object> var1);

    public Locale getLocale() {
        return this._locale;
    }

    public final void setFilter(CodahaleMetricsFilter filter) {
        this._filter = filter;
    }
}

