/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.DefaultCounterReporter;
import usace.metrics.codahale.reporter.DefaultGaugeReporter;
import usace.metrics.codahale.reporter.DefaultHistogramReporter;
import usace.metrics.codahale.reporter.DefaultMeterReporter;
import usace.metrics.codahale.reporter.DefaultTimerReporter;
import usace.metrics.codahale.reporter.MetricReporter;
import usace.metrics.services.config.MetricsConfig;

public abstract class CodahaleReporterBuilder<T extends CodahaleReporterBuilder<T, R>, R extends CodahaleReporter> {
    private final CodahaleMetricRegistry _registry;
    private Locale _locale;
    private TimeUnit _rateUnit;
    private TimeUnit _durationUnit;
    private Clock _clock;
    private MetricFilter _filter;
    private MetricsConfig _config;
    private MetricReporter<Gauge<?>> _gaugeReporter;
    private MetricReporter<Timer> _timerReporter;
    private MetricReporter<Histogram> _histogramReporter;
    private MetricReporter<Meter> _meterReporter;
    private MetricReporter<Counter> _counterReporter;

    protected CodahaleReporterBuilder(CodahaleMetricRegistry registry) {
        this._registry = registry;
        this._locale = Locale.getDefault();
        this._rateUnit = TimeUnit.SECONDS;
        this._durationUnit = TimeUnit.MILLISECONDS;
        this._clock = Clock.defaultClock();
        this._filter = MetricFilter.ALL;
        this._gaugeReporter = new DefaultGaugeReporter(this._locale, registry);
        this._timerReporter = new DefaultTimerReporter(this._locale, registry);
        this._counterReporter = new DefaultCounterReporter(this._locale, registry);
        this._meterReporter = new DefaultMeterReporter(this._locale, registry);
        this._counterReporter = new DefaultCounterReporter(this._locale, registry);
        this._histogramReporter = new DefaultHistogramReporter(this._locale, registry);
    }

    public T formatFor(Locale locale) {
        this._locale = locale;
        return (T)this;
    }

    public T convertRatesTo(TimeUnit rateUnit) {
        this._rateUnit = rateUnit;
        return (T)this;
    }

    public T convertDurationsTo(TimeUnit durationUnit) {
        this._durationUnit = durationUnit;
        return (T)this;
    }

    public T withClock(Clock clock) {
        this._clock = clock;
        return (T)this;
    }

    public T filter(MetricFilter filter) {
        this._filter = filter;
        return (T)this;
    }

    public T withGaugeReporter(MetricReporter<Gauge<?>> gaugeReporter) {
        this._gaugeReporter = gaugeReporter;
        return (T)this;
    }

    public T withHistogramReporter(MetricReporter<Histogram> histogramReporter) {
        this._histogramReporter = histogramReporter;
        return (T)this;
    }

    public T withMeterReporter(MetricReporter<Meter> meterReporter) {
        this._meterReporter = meterReporter;
        return (T)this;
    }

    public T withCounterReporter(MetricReporter<Counter> counterReporter) {
        this._counterReporter = counterReporter;
        return (T)this;
    }

    public T withTimerReporter(MetricReporter<Timer> timerReporter) {
        this._timerReporter = timerReporter;
        return (T)this;
    }

    public T withConfig(MetricsConfig config) {
        this._config = config;
        return (T)this;
    }

    public abstract R build();

    protected Clock getClock() {
        return this._clock;
    }

    protected MetricReporter<Counter> getCounterReporter() {
        return this._counterReporter;
    }

    protected TimeUnit getDurationUnit() {
        return this._durationUnit;
    }

    protected MetricFilter getFilter() {
        return this._filter;
    }

    protected MetricReporter<Gauge<?>> getGaugeReporter() {
        return this._gaugeReporter;
    }

    protected MetricReporter<Histogram> getHistogramReporter() {
        return this._histogramReporter;
    }

    public Locale getLocale() {
        return this._locale;
    }

    protected MetricReporter<Meter> getMeterReporter() {
        return this._meterReporter;
    }

    protected TimeUnit getRateUnit() {
        return this._rateUnit;
    }

    public CodahaleMetricRegistry getRegistry() {
        return this._registry;
    }

    protected MetricReporter<Timer> getTimerReporter() {
        return this._timerReporter;
    }

    public MetricsConfig getConfig() {
        return this._config;
    }
}

