/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;

public class DefaultCounterReporter
extends MetricReporter<Counter> {
    private final Map<String, Long> _counterCounts = new HashMap<String, Long>();

    DefaultCounterReporter(Locale locale, CodahaleMetricRegistry metricRegistry) {
        super(locale, metricRegistry);
    }

    @Override
    public String report(CodahaleReporter parentReporter, long timestamp, String name, Counter counter) {
        Long prevCount = this._counterCounts.get(name);
        if (prevCount != null && counter.getCount() == prevCount.longValue()) {
            return null;
        }
        this._counterCounts.put(name, counter.getCount());
        this.clearColumnFormatting();
        this.getColumnFormatting().put(new MetricColumn("path", "%s"), name);
        this.getColumnFormatting().put(new MetricColumn("count", "%d"), counter.getCount());
        this.reportProperties((Metric)counter);
        return parentReporter.report(timestamp, name, "Counter", this.getColumnFormatting(), this.getLocale());
    }
}

