/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;

public class DefaultHistogramReporter
extends MetricReporter<Histogram> {
    private final Map<String, Long> _histogramCounts = new HashMap<String, Long>();

    DefaultHistogramReporter(Locale locale, CodahaleMetricRegistry metricRegistry) {
        super(locale, metricRegistry);
    }

    @Override
    public String report(CodahaleReporter parentReporter, long timestamp, String name, Histogram histogram) {
        long count = histogram.getCount();
        if (count == 0L) {
            return null;
        }
        Long prevCount = this._histogramCounts.get(name);
        if (prevCount != null && prevCount == count) {
            return null;
        }
        this._histogramCounts.put(name, count);
        Snapshot snapshot = histogram.getSnapshot();
        this.clearColumnFormatting();
        this.getColumnFormatting().put(new MetricColumn("path", "%s"), name);
        this.getColumnFormatting().put(new MetricColumn("count", "%d"), histogram.getCount());
        this.getColumnFormatting().put(new MetricColumn("max", "%d"), snapshot.getMax());
        this.getColumnFormatting().put(new MetricColumn("mean", "%f"), snapshot.getMean());
        this.getColumnFormatting().put(new MetricColumn("min", "%d"), snapshot.getMin());
        this.getColumnFormatting().put(new MetricColumn("stddev", "%f"), snapshot.getStdDev());
        this.getColumnFormatting().put(new MetricColumn("p50", "%f"), snapshot.getMedian());
        this.getColumnFormatting().put(new MetricColumn("p75", "%f"), snapshot.get75thPercentile());
        this.getColumnFormatting().put(new MetricColumn("p95", "%f"), snapshot.get95thPercentile());
        this.getColumnFormatting().put(new MetricColumn("p98", "%f"), snapshot.get98thPercentile());
        this.getColumnFormatting().put(new MetricColumn("p99", "%f"), snapshot.get99thPercentile());
        this.getColumnFormatting().put(new MetricColumn("p999", "%f"), snapshot.get999thPercentile());
        this.reportProperties((Metric)histogram);
        return parentReporter.report(timestamp, name, "Histogram", this.getColumnFormatting(), this.getLocale());
    }
}

