/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;

public class DefaultMeterReporter
extends MetricReporter<Meter> {
    private final Map<String, Long> _meterCounts = new HashMap<String, Long>();

    DefaultMeterReporter(Locale locale, CodahaleMetricRegistry metricRegistry) {
        super(locale, metricRegistry);
    }

    @Override
    public String report(CodahaleReporter parentReporter, long timestamp, String name, Meter meter) {
        long count = meter.getCount();
        if (count == 0L) {
            return null;
        }
        Long prevCount = this._meterCounts.get(name);
        if (prevCount != null && prevCount == count) {
            return null;
        }
        this._meterCounts.put(name, count);
        this.clearColumnFormatting();
        this.getColumnFormatting().put(new MetricColumn("path", "%s"), name);
        this.getColumnFormatting().put(new MetricColumn("count", "%d"), meter.getCount());
        this.getColumnFormatting().put(new MetricColumn("mean_rate", "%f"), parentReporter.convertRate(meter.getMeanRate()));
        this.getColumnFormatting().put(new MetricColumn("m1_rate", "%f"), parentReporter.convertRate(meter.getOneMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("m5_rate", "%f"), parentReporter.convertRate(meter.getFiveMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("m15_rate", "%f"), parentReporter.convertRate(meter.getFifteenMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("rate_unit", "events/%s"), parentReporter.getRateUnit());
        this.reportProperties((Metric)meter);
        return parentReporter.report(timestamp, name, "Meter", this.getColumnFormatting(), this.getLocale());
    }
}

