/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;

public class DefaultTimerReporter
extends MetricReporter<Timer> {
    private final Map<String, Long> _timerCounts = new HashMap<String, Long>();

    DefaultTimerReporter(Locale locale, CodahaleMetricRegistry registry) {
        super(locale, registry);
    }

    @Override
    public String report(CodahaleReporter parentReporter, long timestamp, String name, Timer timer) {
        long tmrCount = timer.getCount();
        if (tmrCount == 0L) {
            return null;
        }
        Long prevCount = this._timerCounts.get(name);
        if (prevCount != null && prevCount == tmrCount) {
            return null;
        }
        Snapshot snapshot = timer.getSnapshot();
        this._timerCounts.put(name, tmrCount);
        this.clearColumnFormatting();
        this.getColumnFormatting().put(new MetricColumn("time", "%d"), timestamp);
        this.getColumnFormatting().put(new MetricColumn("path", "%s"), name);
        this.getColumnFormatting().put(new MetricColumn("count", "%d"), timer.getCount());
        this.getColumnFormatting().put(new MetricColumn("max", "%f"), parentReporter.convertDuration(snapshot.getMax()));
        this.getColumnFormatting().put(new MetricColumn("mean", "%f"), parentReporter.convertDuration(snapshot.getMean()));
        this.getColumnFormatting().put(new MetricColumn("min", "%f"), parentReporter.convertDuration(snapshot.getMin()));
        this.getColumnFormatting().put(new MetricColumn("stddev", "%f"), parentReporter.convertDuration(snapshot.getStdDev()));
        long total = 0L;
        for (long l : snapshot.getValues()) {
            total += l;
        }
        this.getColumnFormatting().put(new MetricColumn("total time", "%f"), parentReporter.convertDuration(total));
        this.getColumnFormatting().put(new MetricColumn("p50", "%f"), parentReporter.convertDuration(snapshot.getMedian()));
        this.getColumnFormatting().put(new MetricColumn("p75", "%f"), parentReporter.convertDuration(snapshot.get75thPercentile()));
        this.getColumnFormatting().put(new MetricColumn("p95", "%f"), parentReporter.convertDuration(snapshot.get95thPercentile()));
        this.getColumnFormatting().put(new MetricColumn("p98", "%f"), parentReporter.convertDuration(snapshot.get98thPercentile()));
        this.getColumnFormatting().put(new MetricColumn("p99", "%f"), parentReporter.convertDuration(snapshot.get99thPercentile()));
        this.getColumnFormatting().put(new MetricColumn("p999", "%f"), parentReporter.convertDuration(snapshot.get999thPercentile()));
        this.getColumnFormatting().put(new MetricColumn("mean_rate", "%f"), parentReporter.convertRate(timer.getMeanRate()));
        this.getColumnFormatting().put(new MetricColumn("m1_rate", "%f"), parentReporter.convertRate(timer.getOneMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("m5_rate", "%f"), parentReporter.convertRate(timer.getFiveMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("m15_rate", "%f"), parentReporter.convertRate(timer.getFifteenMinuteRate()));
        this.getColumnFormatting().put(new MetricColumn("rate_unit", "calls/%s"), parentReporter.getRateUnit());
        this.getColumnFormatting().put(new MetricColumn("duration_unit", "%s"), parentReporter.getDurationUnit());
        this.reportProperties((Metric)timer);
        return parentReporter.report(timestamp, name, "Timer", this.getColumnFormatting(), this.getLocale());
    }
}

