/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Metric;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;

public abstract class MetricReporter<T extends Metric> {
    private final Map<MetricColumn, Object> _columnFormatting = new LinkedHashMap<MetricColumn, Object>();
    private Locale _locale;
    private CodahaleMetricRegistry _metricRegistry;

    public MetricReporter(Locale locale, CodahaleMetricRegistry metricRegistry) {
        this._locale = locale;
        this._metricRegistry = metricRegistry;
    }

    Properties getAndRemoveMetricProperties(Metric metricName) {
        return this._metricRegistry.getAndRemoveMetricProperties(metricName);
    }

    void clearColumnFormatting() {
        for (Map.Entry<MetricColumn, Object> entry : this._columnFormatting.entrySet()) {
            this._columnFormatting.put(entry.getKey(), "");
        }
    }

    Map<MetricColumn, Object> getColumnFormatting() {
        return this._columnFormatting;
    }

    protected Locale getLocale() {
        return this._locale;
    }

    public abstract String report(CodahaleReporter var1, long var2, String var4, T var5);

    public String getHeader(CodahaleReporter parentReporter) {
        return parentReporter.getHeader(this.getColumnFormatting());
    }

    void reportProperties(Metric metric) {
        StringBuilder builder = new StringBuilder("[");
        Properties metricProperties = this.getAndRemoveMetricProperties(metric);
        if (metricProperties != null) {
            Set<Map.Entry<Object, Object>> entrySet = metricProperties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                builder.append("{").append(entry.getKey().toString()).append(":").append(Objects.toString(entry.getValue())).append("}");
            }
        }
        builder.append("]");
        this.getColumnFormatting().put(new MetricColumn("Properties", "%s"), builder.toString());
    }
}

