/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricReporter;
import usace.metrics.codahale.reporter.json.CodahaleJsonReporter;

final class MetricReporterFactory {
    private static final String GAUGE_FILE_NAME = "Gauges";
    private static final String COUNTER_FILE_NAME = "Counters";
    private static final String METER_FILE_NAME = "Meters";
    private static final String HISTOGRAM_FILE_NAME = "Histograms";
    private static final String TIMER_FILE_NAME = "Timers";

    private MetricReporterFactory() {
        throw new AssertionError((Object)"Utilitie class");
    }

    static <T extends Metric> MetricReporter<T> getReporter(CodahaleReporter codahaleReporter, T metric) {
        MetricReporter<Counter> metricReporter = null;
        if (metric instanceof Counter) {
            metricReporter = codahaleReporter.getCounterReporter();
        } else if (metric instanceof Meter) {
            metricReporter = codahaleReporter.getMeterReporter();
        } else if (metric instanceof Timer) {
            metricReporter = codahaleReporter.getTimerReporter();
        } else if (metric instanceof Histogram) {
            metricReporter = codahaleReporter.getHistogramReporter();
        } else if (metric instanceof Gauge) {
            metricReporter = codahaleReporter.getGaugeReporter();
        } else {
            Logger.getLogger(CodahaleJsonReporter.class.getName()).log(Level.FINE, "Unsupported metric: {0}", metric.getClass().getSimpleName());
        }
        return metricReporter;
    }

    static String getNameForMetric(Metric metric) {
        String name;
        if (metric instanceof Counter) {
            name = COUNTER_FILE_NAME;
        } else if (metric instanceof Meter) {
            name = METER_FILE_NAME;
        } else if (metric instanceof Timer) {
            name = TIMER_FILE_NAME;
        } else if (metric instanceof Histogram) {
            name = HISTOGRAM_FILE_NAME;
        } else if (metric instanceof Gauge) {
            name = GAUGE_FILE_NAME;
        } else {
            Logger.getLogger(CodahaleJsonReporter.class.getName()).log(Level.SEVERE, "Unsupported metric: {0}", metric.getClass().getSimpleName());
            return null;
        }
        return name;
    }
}

