/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter.csv;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;
import usace.metrics.codahale.reporter.csv.CodahaleCsvReporterBuilder;
import usace.metrics.services.config.MetricsConfig;

public class CodahaleCsvReporter
extends CodahaleReporter {
    private static final Logger LOGGER = Logger.getLogger(CodahaleCsvReporter.class.getName());
    private static final String FILE_EXTENSION = ".csv";

    CodahaleCsvReporter(CodahaleMetricRegistry registry, Locale locale, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter, MetricReporter<Gauge<?>> gaugeReporter, MetricReporter<Histogram> histogramReporter, MetricReporter<Timer> timerReporter, MetricReporter<Meter> meterReporter, MetricReporter<Counter> counterReporter, MetricsConfig config) {
        super(registry, "csv-reporter", locale, rateUnit, durationUnit, clock, filter, gaugeReporter, histogramReporter, timerReporter, meterReporter, counterReporter, config);
    }

    public static CodahaleCsvReporterBuilder forRegistry(CodahaleMetricRegistry registry) {
        return new CodahaleCsvReporterBuilder(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader(Path path, MetricReporter<?> metricReporter) throws IOException {
        String firstLine;
        try (BufferedReader reader = Files.newBufferedReader(path, UTF_8);){
            firstLine = reader.readLine() + "\n";
        }
        String header = metricReporter.getHeader(this);
        int headerLength = header.length();
        if (headerLength != firstLine.length()) {
            int firstLineLength = firstLine.length();
            int offset = headerLength - firstLineLength;
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile(path.getFileName().toString(), "~");
                try (RandomAccessFile originalFile = new RandomAccessFile(path.toFile(), "rw");
                     RandomAccessFile rtemp = new RandomAccessFile(tmpFile, "rw");
                     FileChannel sourceChannel = originalFile.getChannel();
                     FileChannel targetChannel = rtemp.getChannel();){
                    long fileSize = originalFile.length();
                    long count = fileSize - (long)offset;
                    if (count > 0L) {
                        sourceChannel.transferTo(firstLineLength, fileSize - (long)firstLineLength, targetChannel);
                        if (offset > -1) {
                            sourceChannel.truncate(offset);
                        }
                    }
                    originalFile.seek(0L);
                    originalFile.write((header + "\n").getBytes(UTF_8));
                    long newOffset = originalFile.getFilePointer();
                    targetChannel.position(0L);
                    if (count > 0L) {
                        sourceChannel.transferFrom(targetChannel, newOffset, fileSize - (long)offset);
                    }
                }
            }
            finally {
                if (tmpFile != null) {
                    Files.deleteIfExists(tmpFile.toPath());
                }
            }
        }
    }

    @Override
    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String report(long timestamp, String path, String name, Map<MetricColumn, Object> columnFormatting, Locale locale) {
        String delimiter = this.getDelimiter();
        return columnFormatting.entrySet().stream().map(entry -> String.format(locale, ((MetricColumn)entry.getKey()).getFormatting(), entry.getValue())).collect(Collectors.joining(delimiter));
    }

    @Override
    public String getHeader(Map<MetricColumn, Object> columnFormatting) {
        String delim = this.getDelimiter();
        return columnFormatting.keySet().stream().map(column -> String.format("%s", column.getName())).collect(Collectors.joining(delim));
    }
}

