/*
 * Decompiled with CFR 0.152.
 */
package usace.metrics.codahale.reporter.json;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import usace.metrics.codahale.CodahaleMetricRegistry;
import usace.metrics.codahale.reporter.CodahaleReporter;
import usace.metrics.codahale.reporter.MetricColumn;
import usace.metrics.codahale.reporter.MetricReporter;
import usace.metrics.codahale.reporter.json.CodahaleJsonReporterBuilder;
import usace.metrics.services.config.MetricsConfig;

public class CodahaleJsonReporter
extends CodahaleReporter {
    private static final Logger LOGGER = Logger.getLogger(CodahaleJsonReporter.class.getSimpleName());
    private static final String FILE_EXTENSION = ".json";

    CodahaleJsonReporter(CodahaleMetricRegistry registry, Locale locale, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter, MetricReporter<Gauge<?>> gaugeReporter, MetricReporter<Histogram> histogramReporter, MetricReporter<Timer> timerReporter, MetricReporter<Meter> meterReporter, MetricReporter<Counter> counterReporter, MetricsConfig config) {
        super(registry, "json-reporter", locale, rateUnit, durationUnit, clock, filter, gaugeReporter, histogramReporter, timerReporter, meterReporter, counterReporter, config);
    }

    public static CodahaleJsonReporterBuilder forRegistry(CodahaleMetricRegistry registry) {
        return new CodahaleJsonReporterBuilder(registry);
    }

    @Override
    protected void writeHeader(Path path, MetricReporter<? extends Metric> metricReporter) {
    }

    @Override
    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String report(long timestamp, String path, String name, Map<MetricColumn, Object> columnFormatting, Locale locale) {
        JsonNodeFactory jsonNodeFactory = JsonNodeFactory.withExactBigDecimals((boolean)false);
        ObjectNode metricNode = jsonNodeFactory.objectNode();
        metricNode.put("path", path);
        ObjectNode metricDetailsNode = metricNode.putObject("details");
        columnFormatting.forEach((column, value1) -> {
            String value = String.format(locale, column.getFormatting(), value1);
            metricDetailsNode.put(column.getName(), value);
        });
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode parentNode = jsonNodeFactory.objectNode();
        ObjectNode objectNode = parentNode.put("timestamp", timestamp);
        objectNode.setAll(metricNode);
        String valueAsString = "";
        try {
            valueAsString = mapper.writeValueAsString((Object)parentNode);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.SEVERE, "Unable to process JSON string: " + parentNode, e);
        }
        return valueAsString;
    }

    @Override
    public String getHeader(Map<MetricColumn, Object> columnFormatting) {
        return "";
    }
}

