/*
 * Decompiled with CFR 0.152.
 */
package hec.dssgui.script;

import hec.dataTable.HecDataTableFrame;
import hec.dataTable.SavableDataFrame;
import hec.dssgui.SaveAs;
import hec.hecmath.DSS;
import hec.hecmath.DSSFile;
import hec.io.DataContainer;
import hec.model.TsDataSetName;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.table.TableExportOptions;

public class Tabulate {
    private String _title = "Tabulate";
    private HecDataTableFrame _frame = null;
    private Vector _dataSetList = null;
    private int _x = Integer.MIN_VALUE;
    private int _y = Integer.MIN_VALUE;
    private int _width = Integer.MIN_VALUE;
    private int _height = Integer.MIN_VALUE;
    private String _timeWindow = null;

    public Tabulate() {
    }

    public Tabulate(String title) {
        this._title = title;
    }

    public static HecDataTableFrame newTable() {
        HecDataTableFrame table = new HecDataTableFrame(null);
        table.setParent((Object)new SavableDSSFile());
        return table;
    }

    public static HecDataTableFrame newTable(String title) {
        HecDataTableFrame retval = Tabulate.newTable();
        retval.setTitle(title);
        return retval;
    }

    public static TableExportOptions exportOptions() {
        return new TableExportOptions();
    }

    public void setTitle(String title) {
        this._title = title;
        if (this._frame != null) {
            this._frame.setTitle(title);
        }
    }

    public void setTimeWindow(String startTime, String endTime) {
        this._timeWindow = startTime != null && endTime != null ? startTime + ";" + endTime : null;
    }

    public void getData(String source, String path) {
        TsDataSetName dataSet = null;
        if (source.equalsIgnoreCase("dss")) {
            dataSet = new TsDataSetName(false, path);
        } else if (source.equalsIgnoreCase("oracle")) {
            dataSet = new TsDataSetName(true, path);
        } else {
            System.out.println("Plot.getData: unknown source " + source);
            return;
        }
        if (this._dataSetList == null) {
            this._dataSetList = new Vector();
        }
        if (dataSet != null) {
            this._dataSetList.addElement(dataSet);
        }
    }

    public void hide() {
        if (this._frame == null) {
            return;
        }
        this._frame.setVisible(false);
    }

    public void show() {
        if (this._frame == null) {
            return;
        }
        this._frame.setVisible(true);
    }

    public void close() {
        this.hide();
        this._frame = null;
    }

    public void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
        if (this._frame != null) {
            this._frame.setLocation(x, y);
        }
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
        if (this._frame != null) {
            this._frame.setSize(width, height);
            this._frame.invalidate();
            this._frame.validate();
            this._frame.repaint();
        }
    }

    private void setSizeAndLoc() {
        if (this._frame == null) {
            return;
        }
        if (this._x != Integer.MIN_VALUE && this._y != Integer.MIN_VALUE) {
            this._frame.setLocation(this._x, this._y);
        }
        if (this._width != Integer.MIN_VALUE && this._height != Integer.MIN_VALUE) {
            this._frame.setSize(this._width, this._height);
            this._frame.invalidate();
            this._frame.validate();
            this._frame.repaint();
        }
    }

    public HecDataTableFrame getWindow() {
        return this._frame;
    }

    private static class SavableDSSFile
    implements SavableDataFrame {
        private SavableDSSFile() {
        }

        public boolean save(DataContainer dataContainer) {
            boolean success = true;
            String error = "";
            DSSFile dssFile = DSS.open((String)dataContainer.fileName);
            try {
                dssFile.write(dataContainer);
            }
            catch (Exception e) {
                success = false;
                error = e.toString();
            }
            StringBuilder message = new StringBuilder();
            if (success) {
                message.append("Saved record:  ");
            } else {
                message.append("Error in saving record: ");
            }
            message.append(dataContainer.fullName);
            message.append("\nTo file ");
            message.append(dataContainer.fileName);
            if (!success) {
                message.append("\n" + error);
            }
            JOptionPane.showMessageDialog(null, message.toString(), "Saved Data Set", 1);
            return success;
        }

        public boolean saveAs(DataContainer dataContainer) {
            SaveAs saveas = new SaveAs();
            saveas.setPathname(dataContainer.fullName);
            saveas.disableFileBrowser();
            saveas.setVisible(true);
            if (saveas.canceled()) {
                return false;
            }
            dataContainer.fullName = saveas.getPathname().toString();
            return this.save(dataContainer);
        }

        public int save(Vector dataContainers) {
            for (int i = 0; i < dataContainers.size(); ++i) {
                Object obj = dataContainers.elementAt(i);
                if (obj instanceof DataContainer) {
                    boolean success = this.save((DataContainer)obj);
                    if (success) continue;
                    return -1;
                }
                return -1;
            }
            return 0;
        }

        public boolean saveAs(Vector dataContainers) {
            for (int i = 0; i < dataContainers.size(); ++i) {
                Object obj = dataContainers.elementAt(i);
                if (obj instanceof DataContainer) {
                    boolean success = this.saveAs((DataContainer)obj);
                    if (success) continue;
                    return success;
                }
                return false;
            }
            return true;
        }
    }
}

