/*
 * Decompiled with CFR 0.152.
 */
package com.mrsid;

import com.mrsid.LTIGeoCoord;
import java.awt.Dimension;
import java.io.IOException;

public class LTIImage {
    long mFilePtr = -1L;
    boolean mLibLoaded = false;

    private native int getWidthJ(long var1);

    private native int getHeightJ(long var1);

    private native int getGeoCoordJ(long var1, LTIGeoCoord var3);

    private native int getDimsAtMagWidth(long var1, double var3);

    private native int getDimsAtMagHeight(long var1, double var3);

    private native double getMinMagnificationJ(long var1);

    private native double getMaxMagnificationJ(long var1);

    public LTIImage() {
    }

    public LTIImage(long filePtr) {
        this.mFilePtr = filePtr;
    }

    public boolean loaded() {
        return this.mFilePtr > 0L;
    }

    public int getWidth() {
        if (this.mFilePtr < 1L) {
            return 0;
        }
        return this.getWidthJ(this.mFilePtr);
    }

    public int getHeight() {
        if (this.mFilePtr < 1L) {
            return 0;
        }
        return this.getHeightJ(this.mFilePtr);
    }

    public LTIGeoCoord getGeoCoord() throws IOException {
        if (this.mFilePtr == -1L) {
            return null;
        }
        LTIGeoCoord geoCoord = new LTIGeoCoord();
        int success = this.getGeoCoordJ(this.mFilePtr, geoCoord);
        if (success < 0) {
            throw new IOException("Error");
        }
        return geoCoord;
    }

    public Dimension getDimsAtMag(double mag) throws IOException {
        Dimension dim = new Dimension(0, 0);
        if (this.mFilePtr < 1L) {
            return dim;
        }
        dim.width = this.getDimsAtMagWidth(this.mFilePtr, mag);
        dim.height = this.getDimsAtMagHeight(this.mFilePtr, mag);
        if (dim.width < 0 || dim.height < 0) {
            throw new IOException("Error in LTIImage.getDimsAtMag().");
        }
        return dim;
    }

    public double getMinMagnification() {
        if (this.mFilePtr < 1L) {
            return 0.0;
        }
        return this.getMinMagnificationJ(this.mFilePtr);
    }

    public double getMaxMagnification() {
        if (this.mFilePtr < 1L) {
            return 0.0;
        }
        return this.getMaxMagnificationJ(this.mFilePtr);
    }

    static {
        System.loadLibrary("tbb");
        System.loadLibrary("lti_dsdk_9.1");
        System.loadLibrary("MrSidReader");
    }
}

