/*
 * Decompiled with CFR 0.152.
 */
package com.mrsid;

import com.mrsid.LTIGeoCoord;
import com.mrsid.LTIImageStage;
import com.mrsid.LTIScene;
import com.mrsid.LTISceneBuffer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class MrSidImageReader
extends LTIImageStage {
    private native long openFileJ(String var1);

    private native int closeFileJ(long var1);

    private native void displayBoundingBox(long var1);

    private native int getNumLevelsJ(long var1);

    public void openFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            MessageFormat fmt = new MessageFormat(ResourceBundle.getBundle("com/mrsid/mrsidereader").getString("mrsidreader.openfile.fileDoesNotExist"));
            String msg = fmt.format(new String[]{fileName});
            throw new IOException(msg);
        }
        if (!file.canRead()) {
            MessageFormat fmt = new MessageFormat(ResourceBundle.getBundle("com/mrsid/mrsidereader").getString("mrsidreader.openfile.noreadpermission"));
            String msg = fmt.format(new String[]{fileName});
            throw new IOException(msg);
        }
        this.mFilePtr = this.openFileJ(fileName);
        if (this.mFilePtr < 0L) {
            MessageFormat fmt = new MessageFormat(ResourceBundle.getBundle("com/mrsid/mrsidereader").getString("mrsidreader.openfile.fileopenerror"));
            String msg = fmt.format(new String[]{fileName});
            throw new IOException(msg);
        }
    }

    public void closeFile() {
        if (this.mFilePtr == -1L) {
            return;
        }
        int success = this.closeFileJ(this.mFilePtr);
        if (success < 0) {
            // empty if block
        }
        this.mFilePtr = -1L;
    }

    protected void finalize() {
        this.closeFile();
    }

    public int getNumLevels() {
        return this.getNumLevelsJ(this.mFilePtr);
    }

    public static void main(String[] args) {
        System.out.println("------------------------------------------------------------------------------------------------");
        System.out.println("-- Main Testing Class for the Mr Sid Reader");
        System.out.println("------------------------------------------------------------------------------------------------");
        MrSidImageReader reader = new MrSidImageReader();
        String fileName = "J:\\software\\MrSidReader\\dev\\lib\\MrSID_DSDK-9.1.0.4045-win64-vc12\\examples\\data\\meg_cr20.sid";
        System.out.println("*** Opening File: " + fileName);
        LTISceneBuffer buffer = new LTISceneBuffer();
        try {
            reader.openFile(fileName);
            LTIGeoCoord geoCoord = reader.getGeoCoord();
            int width = reader.getWidth();
            int height = reader.getHeight();
            System.out.println(geoCoord);
            Dimension d = reader.getDimsAtMag(4.0);
            LTIScene scene = new LTIScene(0.0, 0.0, d.width, d.height, 4.0);
            reader.read(scene, buffer);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        reader.displayBoundingBox(reader.mFilePtr);
        int WIDTH = buffer.getTotalNumColumns();
        int HEIGHT = buffer.getTotalNumRows();
        BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 1);
        WritableRaster raster = image.getRaster();
        int size = buffer.size();
        byte[] band1 = buffer.getBand1();
        byte[] band2 = buffer.getBand2();
        byte[] band3 = buffer.getBand3();
        int[] color = new int[3];
        for (int i = 0; i < size; ++i) {
            color[0] = band1[i];
            color[1] = band2[i];
            color[2] = band3[i];
            raster.setPixel(i % WIDTH, i / WIDTH, color);
        }
        ImageIcon ii = new ImageIcon(image);
        JLabel label = new JLabel(ii);
        JFrame frame = new JFrame();
        JScrollPane sp = new JScrollPane(label);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)sp, "Center");
        frame.setLocation(500, 500);
        frame.setSize(700, 700);
        frame.setVisible(true);
        reader.closeFile();
        System.out.println("*** Closing File: " + fileName);
    }
}

