/*
 * Decompiled with CFR 0.152.
 */
package com.mrsid.ui;

import com.mrsid.LTIScene;
import com.mrsid.LTISceneBuffer;
import com.mrsid.LTIUtils;
import com.mrsid.MrSidImageReader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class MrSidViewerFrame
extends JFrame {
    MrSidImageReader mReader;
    boolean IGNORE_SLIDER = false;
    BufferedImage IMAGE;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;

    public MrSidViewerFrame() {
        this.initComponents();
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MrSidViewerFrame.this.jSlider1.getValueIsAdjusting()) {
                    return;
                }
                if (MrSidViewerFrame.this.IGNORE_SLIDER) {
                    return;
                }
                MrSidViewerFrame.this.loadImage(MrSidViewerFrame.this.jSlider1.getValue());
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jSlider1 = new JSlider();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setOrientation(1);
        this.jSlider1.setPaintTicks(true);
        this.jMenu1.setText("File");
        this.jMenuItem2.setText("Open");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MrSidViewerFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MrSidViewerFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, GroupLayout.Alignment.TRAILING, -1, 279, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 279, Short.MAX_VALUE));
        this.pack();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        int status;
        String lastDir = Preferences.userNodeForPackage(this.getClass()).get("last.dir", "");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new MrSidFileFilter());
        if (lastDir != null && lastDir.length() > 0) {
            fileChooser.setCurrentDirectory(new File(lastDir));
        }
        if ((status = fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        this.setCursor(3);
        File file = fileChooser.getSelectedFile();
        lastDir = file.getParent();
        Preferences.userNodeForPackage(this.getClass()).put("last.dir", lastDir);
        this.openFile(file);
        this.setCursor(0);
    }

    private void openFile(File file) {
        System.out.println("*** Opening File: " + file.getAbsolutePath());
        this.mReader = new MrSidImageReader();
        try {
            this.mReader.openFile(file.getAbsolutePath());
            int numLevels = this.mReader.getNumLevels();
            this.IGNORE_SLIDER = true;
            int mag = LTIUtils.magToLevel(this.mReader.getMinMagnification());
            this.jSlider1.setMaximum(mag);
            mag = LTIUtils.magToLevel(this.mReader.getMaxMagnification());
            this.jSlider1.setMinimum(mag);
            this.jSlider1.setValue(this.jSlider1.getMaximum());
            this.IGNORE_SLIDER = false;
            this.loadImage(this.jSlider1.getMaximum());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void loadImage(int level) {
        LTISceneBuffer buffer = new LTISceneBuffer();
        Dimension imageDimAtMag = null;
        try {
            double mag = LTIUtils.levelToMag(level);
            System.out.println("Level = " + level + ",  Mag = " + mag);
            imageDimAtMag = this.mReader.getDimsAtMag(mag);
            Dimension scrollPaneDim = this.jScrollPane1.getSize();
            Dimension sceneDim = new Dimension();
            sceneDim.width = scrollPaneDim.width > 0 ? Math.min(imageDimAtMag.width, scrollPaneDim.width) : imageDimAtMag.width;
            sceneDim.height = scrollPaneDim.height > 0 ? Math.min(imageDimAtMag.height, scrollPaneDim.height) : imageDimAtMag.height;
            int x = this.jScrollPane1.getViewport().getX();
            int y = this.jScrollPane1.getViewport().getX();
            LTIScene scene = new LTIScene(x, y, sceneDim.width, sceneDim.height, mag);
            this.mReader.read(scene, buffer);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        int iWIDTH = buffer.getTotalNumColumns();
        int iHEIGHT = buffer.getTotalNumRows();
        this.IMAGE = new BufferedImage(iWIDTH, iHEIGHT, 1);
        WritableRaster raster = this.IMAGE.getRaster();
        int size = buffer.size();
        byte[] band1 = buffer.getBand1();
        byte[] band2 = buffer.getBand2();
        byte[] band3 = buffer.getBand3();
        int[] color = new int[3];
        for (int i = 0; i < size; ++i) {
            color[0] = band1[i];
            color[1] = band2[i];
            color[2] = band3[i];
            raster.setPixel(i % iWIDTH, i / iWIDTH, color);
        }
        ImageIcon ii = new ImageIcon(this.IMAGE);
        JLabel label = new JLabel(ii);
        this.jScrollPane1.setViewportView(label);
        this.jScrollPane1.getVerticalScrollBar().setMinimum(0);
        this.jScrollPane1.getVerticalScrollBar().setMaximum(imageDimAtMag.height);
        this.jScrollPane1.getHorizontalScrollBar().setMinimum(0);
        this.jScrollPane1.getHorizontalScrollBar().setMaximum(imageDimAtMag.width);
    }

    public static void main(String[] args) {
        new MrSidViewerFrame().setVisible(true);
    }

    protected class MrSidFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.getName().endsWith(".sid");
        }

        @Override
        public String getDescription() {
            return "MrSID File Filter";
        }
    }
}

