/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.plugins.montecarlo.client.ClipAtZeroPanel$1;
import hec.rss.plugins.montecarlo.client.ClipAtZeroPanel$2;
import hec.rss.plugins.montecarlo.client.ClipPanelImpl;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJPanel;

public class ClipAtZeroPanel
extends ClipPanelImpl {
    protected RmaJCheckBox _clipZeroCheckbox;
    private RmaJButton _parameterValueReportButton;
    private RmaJPanel _buttonPanel;
    private DistributionPanel _parent;

    public ClipAtZeroPanel(DistributionPanel distributionPanel) {
        this._parent = distributionPanel;
        this.buildPanel();
        this.addListeners();
    }

    private void buildPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder("Distribution Clipping"));
        this._clipZeroCheckbox = new RmaJCheckBox("Clip at zero");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        rmaJPanel.add((Component)this._clipZeroCheckbox, (Object)gridBagConstraints);
        this._buttonPanel = new RmaJPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        ClipAtZeroPanel clipAtZeroPanel = this;
        clipAtZeroPanel.add((Component)clipAtZeroPanel._buttonPanel, gridBagConstraints);
        if (this._parent.isRelative()) {
            this._parameterValueReportButton = new RmaJButton("Parameter Value Report");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 0;
            this._buttonPanel.add((Component)this._parameterValueReportButton, (Object)gridBagConstraints);
            this._parameterValueReportButton.addActionListener((ActionListener)new ClipAtZeroPanel$1(this));
        }
    }

    protected void disableReporting() {
        this._parameterValueReportButton.setEnabled(false);
    }

    protected void enableReporting() {
        this._parameterValueReportButton.setEnabled(true);
    }

    private void addListeners() {
        this._clipZeroCheckbox.addActionListener((ActionListener)new ClipAtZeroPanel$2(this));
    }

    @Override
    protected void updateActions() {
        boolean bl = this._clipZeroCheckbox.isSelected();
        if (this._dist != null && this._dist.getClipData() != null) {
            ClipData clipData = this._dist.getClipData();
            clipData.setMinVal(0.0);
            clipData.setMaxVal(0.0);
            if (clipData.getMinProb() <= 0.5) {
                clipData.setMinClip(bl);
                clipData.setMaxClip(false);
                return;
            }
            clipData.setMinClip(false);
            clipData.setMaxClip(bl);
        }
    }

    @Override
    public void fillPanel(ClipDist clipDist, int n) {
        this._dist = clipDist;
        if (this._dist == null || this._dist.getClipData() == null) {
            return;
        }
        clipDist = this._dist.getClipData();
        this._clipZeroCheckbox.setSelected(clipDist.hasMinClip() || clipDist.hasMaxClip());
        this.updateActions();
    }

    @Override
    protected RmaJCheckBox[] getClipCheckboxes() {
        return new RmaJCheckBox[]{this._clipZeroCheckbox};
    }
}

