/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.heclib.util.HecTime;
import hec.model.SeasonalRecord;
import hec.rss.plugins.montecarlo.client.ClipAtZeroPanel;
import hec.rss.plugins.montecarlo.client.DistributionPanel;
import hec.rss.plugins.montecarlo.model.SeasonalClipData;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import java.util.List;

public class ClipAtZeroSeasonalPanel
extends ClipAtZeroPanel {
    private List<HecTime> _dates;

    public ClipAtZeroSeasonalPanel(DistributionPanel distributionPanel) {
        super(distributionPanel);
    }

    @Override
    public void fillPanel(ClipDist clipDist, int n) {
        SeasonalContinuousDistribution seasonalContinuousDistribution = (SeasonalContinuousDistribution)clipDist;
        HecTime[] hecTimeArray = new HecTime[seasonalContinuousDistribution.getHecTimes().size()];
        AbstractContDist[] abstractContDistArray = new AbstractContDist[seasonalContinuousDistribution.getHecTimes().size()];
        for (int i = 0; i < hecTimeArray.length; ++i) {
            hecTimeArray[i] = seasonalContinuousDistribution.getHecTimes().get(i);
            abstractContDistArray[i] = seasonalContinuousDistribution.getDist(i);
        }
        this._dist = seasonalContinuousDistribution;
        if (clipDist.getClipData().hasMinClip() || clipDist.getClipData().hasMaxClip()) {
            this._clipZeroCheckbox.setSelected(true);
        }
    }

    @Override
    public ClipDist getDistribution() {
        if (this._clipZeroCheckbox.isSelected()) {
            int n;
            this._dist.getClipData().setMinClip(true);
            double[] dArray = ((SeasonalClipData)this._dist.getClipData()).getMaxValRecord().getDataArray();
            double[] dArray2 = ((SeasonalClipData)this._dist.getClipData()).getMinValRecord().getDataArray();
            Object[] objectArray = this.getTimes();
            for (n = 0; n < objectArray.length; ++n) {
                dArray2[n] = 0.0;
            }
            this._dist.getClipData().setMaxClip(true);
            for (n = 0; n < objectArray.length; ++n) {
                dArray[n] = 0.0;
            }
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            seasonalRecord.setArrays(this.getTimes(), dArray);
            ((SeasonalClipData)this._dist.getClipData()).setMaxVal(seasonalRecord);
            SeasonalRecord seasonalRecord2 = new SeasonalRecord();
            seasonalRecord2.setArrays(this.getTimes(), dArray2);
            ((SeasonalClipData)this._dist.getClipData()).setMinVal(seasonalRecord2);
            objectArray = ((SeasonalClipData)this._dist.getClipData()).getMinProbRecord().getDataArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] <= 0.5) {
                    dArray[i] = Double.POSITIVE_INFINITY;
                    continue;
                }
                dArray2[i] = Double.NEGATIVE_INFINITY;
            }
            seasonalRecord.setArrays(this.getTimes(), dArray);
            ((SeasonalClipData)this._dist.getClipData()).setMaxVal(seasonalRecord);
            seasonalRecord2.setArrays(this.getTimes(), dArray2);
            ((SeasonalClipData)this._dist.getClipData()).setMinVal(seasonalRecord2);
        } else {
            this._dist.getClipData().setMinClip(false);
            double[] dArray = ((SeasonalClipData)this._dist.getClipData()).getMaxValRecord().getDataArray();
            double[] dArray3 = ((SeasonalClipData)this._dist.getClipData()).getMinValRecord().getDataArray();
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            SeasonalRecord seasonalRecord3 = new SeasonalRecord();
            for (int i = 0; i < dArray3.length; ++i) {
                dArray[i] = Double.POSITIVE_INFINITY;
                dArray3[i] = Double.NEGATIVE_INFINITY;
            }
            seasonalRecord.setArrays(this.getTimes(), dArray);
            ((SeasonalClipData)this._dist.getClipData()).setMaxVal(seasonalRecord);
            seasonalRecord3.setArrays(this.getTimes(), dArray3);
            ((SeasonalClipData)this._dist.getClipData()).setMinVal(seasonalRecord3);
        }
        return this._dist;
    }

    private int[] getTimes() {
        this._dates = ((SeasonalContinuousDistribution)this._dist).getFullHecTimes();
        int[] nArray = new int[this._dates.size()];
        for (int i = 0; i < this._dates.size(); ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)this._dates.get(i).month(), (int)this._dates.get(i).day()) * 1440;
        }
        return nArray;
    }
}

