/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.ParamDouble;
import hec.heclib.util.HecTime;
import hec.model.SeasonalRecord;
import hec.rss.plugins.montecarlo.client.ClipBySeasonalValuePanel$1;
import hec.rss.plugins.montecarlo.client.ClipBySeasonalValuePanel$2;
import hec.rss.plugins.montecarlo.client.ClipBySeasonalValuePanel$3;
import hec.rss.plugins.montecarlo.client.ClipPanelImpl;
import hec.rss.plugins.montecarlo.model.SeasonalClipData;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipDist;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.TableChangeListener;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModel;

public class ClipBySeasonalValuePanel
extends ClipPanelImpl {
    private RmaJCheckBox _clipMinCheckbox;
    private RmaJDecimalField _minValueField;
    private RmaJDecimalField _minProbField;
    private RmaJCheckBox _clipMaxCheckbox;
    private RmaJDecimalField _maxValueField;
    private RmaJDecimalField _maxProbField;
    private RmaJTable _clippingMaxSeasonalTable;
    private RmaJTable _clippingMinSeasonalTable;
    private RmaJLabel _minValueLabel;
    private RmaJLabel _minProbLabel;
    private RmaJLabel _maxValueLabel;
    private RmaJLabel _maxProbLabel;
    private HecTime[] _dates;
    private int _paramID;
    private DecimalFormat _format = new DecimalFormat("#.####");

    public ClipBySeasonalValuePanel() {
        this.setBorder(BorderFactory.createTitledBorder("Distribution Clipping"));
        this.buildPanel();
        this.addListeners();
    }

    private void buildPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._clipMinCheckbox = new RmaJCheckBox("Clip Min Value");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._clipMinCheckbox, (Object)gridBagConstraints);
        this._minValueLabel = new RmaJLabel("Min Value (%S)");
        this._minValueLabel.setDisplayUnitsSystem(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this._minProbLabel = new RmaJLabel("Prob < Min");
        this._clippingMinSeasonalTable = new RmaJTable((Component)((Object)this));
        JScrollPane jScrollPane = this._clippingMinSeasonalTable.getScrollPane();
        jScrollPane.setPreferredSize(new Dimension(80, 80));
        rmaJPanel.add((Component)jScrollPane, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._clipMaxCheckbox = new RmaJCheckBox("Clip Max Value");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._clipMaxCheckbox, (Object)gridBagConstraints);
        this._maxValueLabel = new RmaJLabel("Max Value (%S)");
        this._maxValueLabel.setDisplayUnitsSystem(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this._maxProbLabel = new RmaJLabel("Prob > Max");
        this._clippingMaxSeasonalTable = new RmaJTable((Component)((Object)this));
        jScrollPane = this._clippingMaxSeasonalTable.getScrollPane();
        jScrollPane.setPreferredSize(new Dimension(80, 80));
        rmaJPanel.add((Component)jScrollPane, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._clipMinCheckbox.addActionListener((ActionListener)new ClipBySeasonalValuePanel$1(this));
        this._clipMaxCheckbox.addActionListener((ActionListener)new ClipBySeasonalValuePanel$2(this));
        this._clippingMinSeasonalTable.addTableChangeListener((TableChangeListener)new ClipBySeasonalValuePanel$3(this));
    }

    private void updateMinCheckboxAction() {
        int n = this._clipMinCheckbox.isSelected();
        if (this._dist != null && this._dist.getClipData() != null) {
            this._dist.getClipData().setMinClip(n != 0);
        }
        if (this._clipMinCheckbox.isSelected()) {
            n = 1;
            while (n < this._clippingMinSeasonalTable.getColumnCount()) {
                this._clippingMinSeasonalTable.setColumnsEnabled(true, new int[]{n++});
            }
            this._clippingMinSeasonalTable.setRowEnabled(false, 1);
            return;
        }
        n = 1;
        while (n < this._clippingMinSeasonalTable.getColumnCount()) {
            this._clippingMinSeasonalTable.setColumnsEnabled(false, new int[]{n++});
        }
        this._clippingMinSeasonalTable.setRowEnabled(false, 1);
    }

    private void updateMaxCheckboxAction() {
        int n = this._clipMaxCheckbox.isSelected();
        if (this._dist != null && this._dist.getClipData() != null) {
            this._dist.getClipData().setMaxClip(n != 0);
        }
        if (this._clipMaxCheckbox.isSelected()) {
            n = 1;
            while (n < this._clippingMinSeasonalTable.getColumnCount()) {
                this._clippingMaxSeasonalTable.setColumnsEnabled(true, new int[]{n++});
            }
            this._clippingMaxSeasonalTable.setRowEnabled(false, 1);
            return;
        }
        n = 1;
        while (n < this._clippingMinSeasonalTable.getColumnCount()) {
            this._clippingMaxSeasonalTable.setColumnsEnabled(false, new int[]{n++});
        }
        this._clippingMaxSeasonalTable.setRowEnabled(false, 1);
    }

    private void updateMinProbAction() {
    }

    private void updateMaxProbAction() {
    }

    @Override
    public void updateActions() {
        this.updateMinCheckboxAction();
        this.updateMaxCheckboxAction();
        this.updateMinProbAction();
        this.updateMaxProbAction();
        this.repaint();
        this.revalidate();
    }

    @Override
    public void fillPanel(ClipDist clipDist, int n) {
        this._paramID = n;
        this._dist = clipDist = (SeasonalContinuousDistribution)clipDist;
        if (this._clippingMinSeasonalTable.getColumnCount() != 1 && this._clippingMinSeasonalTable.getColumnCount() != clipDist.getFullHecTimes().size()) {
            this.rebuildClipData((SeasonalContinuousDistribution)clipDist);
        }
        if (clipDist.getClipData().hasMaxClip()) {
            this._clipMaxCheckbox.setSelected(true);
        }
        if (clipDist.getClipData().hasMinClip()) {
            this._clipMinCheckbox.setSelected(true);
        }
        HecTime[] hecTimeArray = new HecTime[clipDist.getHecTimes().size()];
        AbstractContDist[] abstractContDistArray = new AbstractContDist[clipDist.getHecTimes().size()];
        for (int i = 0; i < hecTimeArray.length; ++i) {
            hecTimeArray[i] = clipDist.getHecTimes().get(i);
            abstractContDistArray[i] = clipDist.getDist(i);
        }
        this._dist = clipDist;
        this.buildTable(hecTimeArray, abstractContDistArray);
    }

    void buildTable(HecTime[] hecTimeArray, AbstractContDist[] abstractContDistArray) {
        this._dates = hecTimeArray;
        RmaJDecimalField rmaJDecimalField = new String[1 + hecTimeArray.length];
        RmaJDecimalField rmaJDecimalField2 = rmaJDecimalField;
        rmaJDecimalField[0] = "Parameter";
        boolean[] blArray = new boolean[((String[])rmaJDecimalField2).length];
        boolean[] blArray2 = blArray;
        blArray[0] = false;
        for (int i = 1; i < ((String[])rmaJDecimalField2).length; ++i) {
            rmaJDecimalField2[i] = this._dates[i - 1].date(14).substring(0, 5);
            blArray2[i] = true;
        }
        RmaTableModel rmaTableModel = new RmaTableModel((String[])rmaJDecimalField2, 1, blArray2, null);
        rmaTableModel.setDisplayUnitsSystem(1);
        this._clippingMinSeasonalTable.setModel((TableModel)rmaTableModel);
        this._clippingMinSeasonalTable.setCellSelectionEnabled(true);
        this._clippingMinSeasonalTable.getSelectionModel().setSelectionMode(2);
        this._clippingMinSeasonalTable.setColumnEnabled(false, 0);
        this._clippingMinSeasonalTable.setRowEnabled(false, 1);
        this._clippingMinSeasonalTable.setUnitsHeaderRenderer();
        String[] stringArray = new String[1 + hecTimeArray.length];
        rmaJDecimalField2 = stringArray;
        stringArray[0] = "Parameter";
        boolean[] blArray3 = new boolean[((String[])rmaJDecimalField2).length];
        blArray2 = blArray3;
        blArray3[0] = false;
        for (int i = 1; i < ((String[])rmaJDecimalField2).length; ++i) {
            rmaJDecimalField2[i] = this._dates[i - 1].date(14).substring(0, 5);
            blArray2[i] = true;
        }
        RmaTableModel rmaTableModel2 = new RmaTableModel((String[])rmaJDecimalField2, 1, blArray2, null);
        rmaTableModel2.setDisplayUnitsSystem(1);
        this._clippingMaxSeasonalTable.setModel((TableModel)rmaTableModel2);
        this._clippingMaxSeasonalTable.setCellSelectionEnabled(true);
        this._clippingMaxSeasonalTable.getSelectionModel().setSelectionMode(2);
        this._clippingMaxSeasonalTable.setColumnEnabled(false, 0);
        this._clippingMaxSeasonalTable.setRowEnabled(false, 1);
        this._clippingMaxSeasonalTable.setUnitsHeaderRenderer();
        this._clippingMaxSeasonalTable.setColumnEditor(0, new RmaCellEditor((JTextField)new RmaJTextField()));
        this._clippingMaxSeasonalTable.setColumnWidth(0, 100);
        rmaTableModel2 = new RmaCellEditor(new RmaJDecimalField());
        rmaTableModel2.setUnitSystem(1);
        this._clippingMinSeasonalTable.setColumnEditor(0, (RmaCellEditor)rmaTableModel2);
        rmaTableModel2 = new RmaCellEditor(new RmaJDecimalField());
        rmaTableModel2.setUnitSystem(1);
        this._clippingMaxSeasonalTable.setColumnEditor(0, (RmaCellEditor)rmaTableModel2);
        for (int i = 1; i < this._clippingMinSeasonalTable.getColumnCount(); ++i) {
            if (i == 1) {
                rmaJDecimalField2 = new RmaJDecimalField();
                this._minValueLabel.setLabelFor((Component)rmaJDecimalField2);
                rmaJDecimalField2.setValue(new ParamDouble(1.2, this._paramID, 1, 2));
                rmaJDecimalField2 = new RmaJDecimalField();
                this._maxValueLabel.setLabelFor((Component)rmaJDecimalField2);
                rmaJDecimalField2.setValue(new ParamDouble(1.2, this._paramID, 1, 2));
                this._clippingMinSeasonalTable.getModel().setValueAt(this._minValueLabel.getText(), 0, 0);
                this._clippingMinSeasonalTable.getModel().setValueAt(this._minProbLabel.getText(), 1, 0);
                this._clippingMaxSeasonalTable.getModel().setValueAt(this._maxValueLabel.getText(), 0, 0);
                this._clippingMaxSeasonalTable.getModel().setValueAt(this._maxProbLabel.getText(), 1, 0);
            }
            if (!(abstractContDistArray[0] instanceof ClipDist)) continue;
            this._clippingMinSeasonalTable.getModel().setValueAt(((ClipDist)abstractContDistArray[i - 1]).getClipData().getMinVal(), 0, i);
            this._clippingMaxSeasonalTable.getModel().setValueAt(((ClipDist)abstractContDistArray[i - 1]).getClipData().getMaxVal(), 0, i);
            this._clippingMinSeasonalTable.getModel().setValueAt(((ClipDist)abstractContDistArray[i - 1]).getClipData().getMinProb(), 1, i);
            this._clippingMaxSeasonalTable.getModel().setValueAt(((ClipDist)abstractContDistArray[i - 1]).getClipData().getMaxProb(), 1, i);
        }
        this.updateMinCheckboxAction();
        this.updateMaxCheckboxAction();
    }

    @Override
    protected RmaJCheckBox[] getClipCheckboxes() {
        return new RmaJCheckBox[]{this._clipMinCheckbox, this._clipMaxCheckbox};
    }

    @Override
    public ClipDist getDistribution() {
        int n;
        double[] dArray;
        SeasonalRecord seasonalRecord;
        if (this._clipMinCheckbox.isSelected()) {
            this._dist.getClipData().setMinClip(true);
            seasonalRecord = new SeasonalRecord();
            dArray = new double[this._clippingMinSeasonalTable.getColumnCount()];
            for (n = 0; n < dArray.length - 1; ++n) {
                dArray[n] = Double.valueOf(this._clippingMinSeasonalTable.getValueAt(0, n + 1).toString());
            }
            dArray[dArray.length - 1] = dArray[0];
            seasonalRecord.setArrays(this.getTimes(), dArray);
            ((SeasonalClipData)this._dist.getClipData()).setMinVal(seasonalRecord);
        } else {
            this._dist.getClipData().setMinClip(false);
        }
        if (this._clipMaxCheckbox.isSelected()) {
            this._dist.getClipData().setMaxClip(true);
            seasonalRecord = new SeasonalRecord();
            dArray = new double[this._clippingMaxSeasonalTable.getColumnCount()];
            for (n = 0; n < dArray.length - 1; ++n) {
                dArray[n] = Double.valueOf(this._clippingMaxSeasonalTable.getValueAt(0, n + 1).toString());
            }
            dArray[dArray.length - 1] = dArray[0];
            seasonalRecord.setArrays(this.getTimes(), dArray);
            ((SeasonalClipData)this._dist.getClipData()).setMaxVal(seasonalRecord);
        } else {
            this._dist.getClipData().setMaxClip(false);
        }
        return this._dist;
    }

    private void rebuildClipData(SeasonalContinuousDistribution seasonalContinuousDistribution) {
        int[] nArray = this.getTimes();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        int[] nArray2 = this.getTimesFromDates();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] != nArray[i]) continue;
                dArray[i] = Double.valueOf(this._clippingMinSeasonalTable.getValueAt(0, n + 1).toString());
                dArray2[i] = Double.valueOf(this._clippingMaxSeasonalTable.getValueAt(0, n + 1).toString());
                break;
            }
            if (n != nArray2.length) continue;
            dArray[i] = Double.NEGATIVE_INFINITY;
            dArray2[i] = Double.POSITIVE_INFINITY;
        }
        dArray[dArray.length - 1] = dArray[0];
        dArray2[dArray.length - 1] = dArray2[0];
        SeasonalRecord seasonalRecord = new SeasonalRecord();
        seasonalRecord.setArrays(nArray, dArray);
        ((SeasonalClipData)seasonalContinuousDistribution.getClipData()).setMinVal(seasonalRecord);
        SeasonalRecord seasonalRecord2 = new SeasonalRecord();
        seasonalRecord2.setArrays(nArray, dArray2);
        ((SeasonalClipData)seasonalContinuousDistribution.getClipData()).setMaxVal(seasonalRecord2);
    }

    private int[] getTimes() {
        List<HecTime> list = ((SeasonalContinuousDistribution)this._dist).getFullHecTimes();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)list.get(i).month(), (int)list.get(i).day()) * 1440;
        }
        return nArray;
    }

    private int[] getTimesFromDates() {
        int[] nArray = new int[this._dates.length];
        for (int i = 0; i < this._dates.length; ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440;
        }
        return nArray;
    }
}

