/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.ParamDouble;
import hec.rss.plugins.montecarlo.client.ClipByValuePanel$1;
import hec.rss.plugins.montecarlo.client.ClipByValuePanel$2;
import hec.rss.plugins.montecarlo.client.ClipByValuePanel$3;
import hec.rss.plugins.montecarlo.client.ClipByValuePanel$4;
import hec.rss.plugins.montecarlo.client.ClipPanelImpl;
import hec.statistics.ClipDist;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;

public class ClipByValuePanel
extends ClipPanelImpl {
    private RmaJCheckBox _clipMinCheckbox;
    private RmaJDecimalField _minValueField;
    private RmaJDecimalField _minProbField;
    private RmaJCheckBox _clipMaxCheckbox;
    private RmaJDecimalField _maxValueField;
    private RmaJDecimalField _maxProbField;

    public ClipByValuePanel() {
        this.setBorder(BorderFactory.createTitledBorder("Distribution Clipping"));
        this.buildPanel();
        this.addListeners();
    }

    private void buildPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._clipMinCheckbox = new RmaJCheckBox("Clip Min Value");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._clipMinCheckbox, (Object)gridBagConstraints);
        RmaJLabel rmaJLabel = new RmaJLabel("Min Value (%S)");
        rmaJLabel.setDisplayUnitsSystem(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._minValueField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._minValueField);
        this._minValueField.setPrecision(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._minValueField, (Object)gridBagConstraints);
        this._minValueField.setEnabled(false);
        rmaJLabel = new RmaJLabel("Prob < Min");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._minProbField = new RmaJDecimalField();
        this._minProbField.setPrecision(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._minProbField, (Object)gridBagConstraints);
        this._minProbField.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._clipMaxCheckbox = new RmaJCheckBox("Clip Max Value");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._clipMaxCheckbox, (Object)gridBagConstraints);
        rmaJLabel = new RmaJLabel("Max Value (%S)");
        rmaJLabel.setDisplayUnitsSystem(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._maxValueField = new RmaJDecimalField();
        rmaJLabel.setLabelFor((Component)this._maxValueField);
        this._maxValueField.setPrecision(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._maxValueField, (Object)gridBagConstraints);
        this._maxValueField.setEnabled(false);
        rmaJLabel = new RmaJLabel("Prob > Max");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._maxProbField = new RmaJDecimalField();
        this._maxProbField.setPrecision(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._maxProbField, (Object)gridBagConstraints);
        this._maxProbField.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._clipMinCheckbox.addActionListener((ActionListener)new ClipByValuePanel$1(this));
        this._clipMaxCheckbox.addActionListener((ActionListener)new ClipByValuePanel$2(this));
        this._minValueField.addFocusListener((FocusListener)new ClipByValuePanel$3(this));
        this._maxValueField.addFocusListener((FocusListener)new ClipByValuePanel$4(this));
    }

    private void updateMinCheckboxAction() {
        boolean bl = this._clipMinCheckbox.isSelected();
        if (this._dist != null && this._dist.getClipData() != null) {
            this._dist.getClipData().setMinClip(bl);
        }
        this._minValueField.setEnabled(bl);
    }

    private void updateMaxCheckboxAction() {
        boolean bl = this._clipMaxCheckbox.isSelected();
        if (this._dist != null && this._dist.getClipData() != null) {
            this._dist.getClipData().setMaxClip(bl);
        }
        this._maxValueField.setEnabled(bl);
    }

    private void updateMinProbAction() {
        if (this._minValueField.getValueUndefined() == Double.NEGATIVE_INFINITY || this._dist == null || this._dist.getClipData() == null) {
            this._minProbField.setValue(Double.NEGATIVE_INFINITY);
            this._maxValueField.setMinValue(Double.NEGATIVE_INFINITY);
            return;
        }
        if (this._maxValueField.getValueUndefined() != Double.NEGATIVE_INFINITY && this._minValueField.getValue() >= this._maxValueField.getValue()) {
            this._minValueField.setValue(this._maxValueField.getValue() - 0.1);
        }
        this._dist.getClipData().setMinVal(this._minValueField.getValue());
        this._minProbField.setValue(this._dist.getClipData().getMinProb());
    }

    private void updateMaxProbAction() {
        if (this._maxValueField.getValueUndefined() == Double.NEGATIVE_INFINITY || this._dist == null || this._dist.getClipData() == null) {
            this._maxProbField.setValue(Double.NEGATIVE_INFINITY);
            this._minValueField.setMaxValue(Double.NEGATIVE_INFINITY);
            return;
        }
        if (this._minValueField.getValueUndefined() != Double.NEGATIVE_INFINITY && this._maxValueField.getValue() <= this._minValueField.getValue()) {
            this._maxValueField.setValue(this._minValueField.getValue() + 0.1);
        }
        this._dist.getClipData().setMaxVal(this._maxValueField.getValue());
        this._maxProbField.setValue(1.0 - this._dist.getClipData().getMaxProb());
    }

    @Override
    public void updateActions() {
        this.updateMinCheckboxAction();
        this.updateMaxCheckboxAction();
        this.updateMinProbAction();
        this.updateMaxProbAction();
    }

    @Override
    public void fillPanel(ClipDist clipDist, int n) {
        this._dist = clipDist;
        if (this._dist == null || this._dist.getClipData() == null) {
            return;
        }
        clipDist = this._dist.getClipData();
        this._clipMinCheckbox.setSelected(clipDist.hasMinClip());
        this._minValueField.setValue(new ParamDouble(0.0, n, 1, 2));
        this._minValueField.setValue(new ParamDouble(clipDist.getMinVal(), n, 1, 2));
        this._clipMaxCheckbox.setSelected(clipDist.hasMaxClip());
        this._maxValueField.setValue(new ParamDouble(clipDist.getMaxVal(), n, 1, 2));
        this.updateActions();
    }

    @Override
    protected RmaJCheckBox[] getClipCheckboxes() {
        return new RmaJCheckBox[]{this._clipMinCheckbox, this._clipMaxCheckbox};
    }
}

