/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.gui.MoverDialog;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.AlphabeticalComboBox;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$1;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$2;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$3;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$4;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$5;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$6;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$7;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$8;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$9;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog$CorTableModel;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.newSetDialog;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.statistics.CorrelationMatrix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;

public class CorrelationMatrixDialog
extends RmaJDialog {
    private RssAlt _alt;
    private RmaJTable _corJTbl;
    private List<String> _selectedSiteList;
    private Map<String, CorrelationMatrix> _corrMatrix = new HashMap<String, CorrelationMatrix>();
    private RmaJButton _newSetButton;
    private RmaJButton _editSetButton;
    private RmaJButton _deleteSetButton;
    private RmaJTextArea _warningText;
    private ButtonCmdPanel _buttonCmdPanel = new ButtonCmdPanel(12);
    private RmaJComboBox _setComboBox;
    private RmaJLabel _setLabel;
    private MCInputPanel _parent;
    private boolean _loadingTable;
    private boolean _addingMatrix;
    private MoverDialog _correlatedVariableSelectionDialog;
    private String _currSetName;
    private List<String> _dialogSelectedNames = new ArrayList<String>();
    private boolean _disposed = false;

    public CorrelationMatrixDialog(Dialog dialog, MCInputPanel mCInputPanel, String string, RssAlt rssAlt) {
        super(dialog, string);
        this._parent = mCInputPanel;
        this._alt = rssAlt;
        if (this._alt.getAltPluginData("Monte Carlo") != null && ((MCAltPluginData)this._alt.getAltPluginData("Monte Carlo")).getCorrelationMap() != null) {
            this._corrMatrix = this.copyCorrelationMap(((MCAltPluginData)this._alt.getAltPluginData("Monte Carlo")).getCorrelationMap());
        }
        this.buildControls();
        this.addListeners();
    }

    private Map<String, CorrelationMatrix> copyCorrelationMap(Map<String, CorrelationMatrix> map) {
        HashMap<String, CorrelationMatrix> hashMap = new HashMap<String, CorrelationMatrix>();
        for (String string : map.keySet()) {
            hashMap.put(string, map.get(string).clone());
        }
        return hashMap;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel object2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)object2, gridBagConstraints);
        this._newSetButton = new RmaJButton("New Set");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        object2.add((Component)this._newSetButton, (Object)gridBagConstraints);
        this._editSetButton = new RmaJButton("Edit Set");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        object2.add((Component)this._editSetButton, (Object)gridBagConstraints);
        this._deleteSetButton = new RmaJButton("Delete Set");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        object2.add((Component)this._deleteSetButton, (Object)gridBagConstraints);
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._setLabel = new RmaJLabel("Correlation Set Name:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        rmaJPanel.add((Component)this._setLabel, (Object)gridBagConstraints);
        this._setComboBox = new AlphabeticalComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)this._setComboBox, (Object)gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._corJTbl = new RmaJTable((Component)((Object)this));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        CorrelationMatrixDialog correlationMatrixDialog = this;
        correlationMatrixDialog.add(correlationMatrixDialog._corJTbl.getScrollPane(), gridBagConstraints);
        this._warningText = new RmaJTextArea("No warnings to report");
        this._warningText.setEditable(false);
        this._warningText.setEnabled(false);
        this._warningText.setForeground(Color.RED);
        JScrollPane jScrollPane = new JScrollPane((Component)this._warningText, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Correlated Variable Information"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        CorrelationMatrixDialog correlationMatrixDialog2 = this;
        correlationMatrixDialog2.add((Component)correlationMatrixDialog2._buttonCmdPanel, gridBagConstraints);
        if (this._corrMatrix != null && !this._corrMatrix.keySet().isEmpty()) {
            for (String string : this._corrMatrix.keySet()) {
                this._setComboBox.addItem((Object)string);
                this._setComboBox.setSelectedItem((Object)string);
                this.loadFromMatrix();
            }
        } else {
            this._editSetButton.setEnabled(false);
        }
        if (this._setComboBox.getItemCount() > 0) {
            this.getWarningText();
        }
    }

    public void setSiteList(List<String> list) {
        int n;
        this.saveToMatrix();
        this._selectedSiteList = list;
        int n2 = this._selectedSiteList.size();
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(this._selectedSiteList.toArray(new String[0]), 0, stringArray, 1, n2);
        boolean[] blArray = new boolean[n2 + 1];
        Object object = new int[n2 + 1];
        blArray[0] = false;
        object[0] = 200;
        for (int i = 0; i < n2; ++i) {
            blArray[i + 1] = true;
            object[i + 1] = 200;
        }
        this._corJTbl.setNumColumns(n2 + 1);
        CorrelationMatrixDialog$CorTableModel correlationMatrixDialog$CorTableModel = new CorrelationMatrixDialog$CorTableModel(this, stringArray, n2, blArray, null);
        this._corJTbl.setModel((TableModel)((Object)correlationMatrixDialog$CorTableModel));
        this._corJTbl.setColumnWidths(object);
        this._corJTbl.setAddRemoveEnabled(false);
        this._corJTbl.setAutoResizeMode(0);
        for (n = 0; n < n2; ++n) {
            RmaJDecimalField rmaJDecimalField = this._corJTbl.setDoubleCellEditor(n + 1);
            object = rmaJDecimalField;
            rmaJDecimalField.setMinValue(-1.0);
            object.setMaxValue(1.0);
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            correlationMatrixDialog$CorTableModel.setValueAt("1.0", n3, n3 + 1);
            correlationMatrixDialog$CorTableModel.setValueAt(stringArray[n + 1], n, 0);
        }
        this.loadFromMatrix();
    }

    private void addListeners() {
        this._corJTbl.addCellEditorListener((CellEditorListener)new CorrelationMatrixDialog$1());
        this._newSetButton.addActionListener((ActionListener)new CorrelationMatrixDialog$2(this));
        this._editSetButton.addActionListener((ActionListener)new CorrelationMatrixDialog$3(this));
        this._deleteSetButton.addActionListener((ActionListener)new CorrelationMatrixDialog$4(this));
        this._setComboBox.addActionListener((ActionListener)new CorrelationMatrixDialog$5(this));
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new CorrelationMatrixDialog$6(this));
        this._parent.getTableModel().addTableModelListener(new CorrelationMatrixDialog$7(this));
    }

    protected void updateTable() {
        if (this._setComboBox.getItemCount() > 0) {
            this._editSetButton.setEnabled(true);
        } else {
            this._editSetButton.setEnabled(false);
        }
        if (!this._addingMatrix) {
            this._loadingTable = true;
            this.loadFromMatrix();
            this._loadingTable = false;
            this.getWarningText();
        }
    }

    private void cmdCancel_Action() {
        this.dispose();
    }

    private void cmdOK_Action() {
        this._corJTbl.commitEdit(true);
        this.saveToMatrix();
        ((MCAltPluginData)this._alt.getAltPluginData("Monte Carlo")).setCorrelationMap(this._corrMatrix);
        this.dispose();
    }

    protected void newSetAction() {
        this._addingMatrix = true;
        List<MCInputVariableImpl> list = this.getAvailableVariables();
        Object object = "Set 1";
        while (this.setNameExists((String)object)) {
            object = "Set " + (Integer.valueOf(((String)object).substring(4, ((String)object).length())) + 1);
        }
        object = new newSetDialog((Dialog)((Object)this), (String)object);
        object.setSize(300, 75);
        object.setVisible(true);
        String string = ((newSetDialog)((Object)object)).getCorrelationSetName();
        if (string == null) {
            object.dispose();
            this._addingMatrix = false;
            return;
        }
        if (string != null) {
            this._dialogSelectedNames.clear();
            this.openMoverBox(string, list, this._dialogSelectedNames);
        }
        this._addingMatrix = false;
    }

    private boolean setNameExists(String string) {
        boolean bl = false;
        for (int i = 0; i < this._setComboBox.getComponentCount(); ++i) {
            if (this._setComboBox.getItemAt(i) == null || !this._setComboBox.getItemAt(i).equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    protected void editSetAction() {
        this._addingMatrix = true;
        List<MCInputVariableImpl> list = this.getAvailableVariables();
        List<MCInputVariableImpl> list2 = this.getSelectedVariables();
        this._dialogSelectedNames = this.getShortNames(list2);
        CorrelationMatrixDialog correlationMatrixDialog = this;
        correlationMatrixDialog.openMoverBox((String)correlationMatrixDialog._setComboBox.getSelectedItem(), list, this._dialogSelectedNames);
        this._addingMatrix = false;
    }

    protected void deleteSetAction() {
        this._addingMatrix = true;
        this._corrMatrix.remove(this._setComboBox.getSelectedItem());
        this._setComboBox.removeItem(this._setComboBox.getSelectedItem());
        if (this._setComboBox.getItemCount() > 0) {
            this._setComboBox.setSelectedIndex(0);
        } else {
            this._corJTbl.setModel((TableModel)((Object)new CorrelationMatrixDialog$CorTableModel(this, new String[0], 0, new boolean[0], null)));
        }
        this._addingMatrix = false;
        if (this._setComboBox.getSelectedItem() != null) {
            this.updateTable();
        }
        this.getWarningText();
    }

    private void initializeJTable() {
        int n;
        this._loadingTable = true;
        if (this._setComboBox.getSelectedItem() == null) {
            return;
        }
        List list = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).getKeys();
        String[] stringArray = new String[list.size() + 1];
        System.arraycopy(list.toArray(new String[0]), 0, stringArray, 1, list.size());
        boolean[] blArray = new boolean[list.size() + 1];
        Object object = new int[list.size() + 1];
        blArray[0] = false;
        object[0] = 200;
        for (int i = 0; i < list.size(); ++i) {
            blArray[i + 1] = true;
            object[i + 1] = 200;
        }
        this._corJTbl.setNumColumns(list.size() + 1);
        CorrelationMatrixDialog$CorTableModel correlationMatrixDialog$CorTableModel = new CorrelationMatrixDialog$CorTableModel(this, stringArray, list.size(), blArray, null);
        this._corJTbl.setModel((TableModel)((Object)correlationMatrixDialog$CorTableModel));
        this._corJTbl.setColumnWidths(object);
        this._corJTbl.setAddRemoveEnabled(false);
        this._corJTbl.setAutoResizeMode(0);
        for (n = 0; n < list.size(); ++n) {
            RmaJDecimalField rmaJDecimalField = this._corJTbl.setDoubleCellEditor(n + 1);
            object = rmaJDecimalField;
            rmaJDecimalField.setMinValue(-1.0);
            object.setMaxValue(1.0);
        }
        for (n = 0; n < list.size(); ++n) {
            int n2 = n;
            correlationMatrixDialog$CorTableModel.setValueAt("1.0", n2, n2 + 1);
            correlationMatrixDialog$CorTableModel.setValueAt(stringArray[n + 1], n, 0);
        }
        correlationMatrixDialog$CorTableModel.addTableModelListener(new CorrelationMatrixDialog$8(this));
        this._loadingTable = false;
    }

    private void openMoverBox(String string, List<MCInputVariableImpl> list, List<String> list2) {
        this._correlatedVariableSelectionDialog = new MoverDialog((JDialog)((Object)this), false);
        this._correlatedVariableSelectionDialog.setSize(1000, 400);
        this._correlatedVariableSelectionDialog.setEditable(true);
        this._correlatedVariableSelectionDialog.setMoveUpDownVisible(true);
        this._correlatedVariableSelectionDialog.setAvailableListLabel("Available Variables (* indicates inactive variables)");
        this._correlatedVariableSelectionDialog.setSelectedListLabel("Selected Variables (* indicates inactive variables)");
        this._correlatedVariableSelectionDialog.setDesc("Correlated Variable Selection: " + string);
        this._correlatedVariableSelectionDialog.setData(this.getShortNames(list), list2);
        this._correlatedVariableSelectionDialog.setVisible(true);
        this._currSetName = string;
        this.addMoverListener();
    }

    private void addMoverListener() {
        this._correlatedVariableSelectionDialog.addWindowListener((WindowListener)new CorrelationMatrixDialog$9(this));
    }

    private boolean disposed() {
        return this._disposed;
    }

    private List<String> getVariableNameList(List<MCInputVariableImpl> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)object.next();
            if (arrayList.contains(mCInputVariableImpl.getShortName())) continue;
            arrayList.add(mCInputVariableImpl.getShortName());
        }
        return arrayList;
    }

    private List<String> getShortNames(List<MCInputVariableImpl> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)object.next();
            arrayList.add(mCInputVariableImpl.getShortName());
            if (mCInputVariableImpl.isActive()) continue;
            ArrayList<String> arrayList2 = arrayList;
            ArrayList<String> arrayList3 = arrayList;
            arrayList2.set(arrayList2.size() - 1, "*" + (String)arrayList3.get(arrayList3.size() - 1));
        }
        return arrayList;
    }

    private void syncSelectedVariables(List<MCInputVariableImpl> list, Object[] objectArray, List<MCInputVariableImpl> list2) {
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        for (MCInputVariableImpl iterator : list) {
            arrayList.add(iterator.clone());
        }
        list.clear();
        block1: for (int i = 0; i < objectArray.length; ++i) {
            for (MCInputVariableImpl mCInputVariableImpl : arrayList) {
                if (!objectArray[i].toString().contains(mCInputVariableImpl.getShortName())) continue;
                list.add(mCInputVariableImpl);
                break;
            }
            for (MCInputVariableImpl mCInputVariableImpl : list2) {
                if (!objectArray[i].toString().contains(mCInputVariableImpl.getShortName())) continue;
                list.add(mCInputVariableImpl);
                continue block1;
            }
        }
    }

    private List<MCInputVariableImpl> getSelectedVariables() {
        List<MCInputVariableImpl> list = this._parent.getInputVariableList();
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        if (!this._corrMatrix.isEmpty()) {
            for (String string : this._corrMatrix.get(this._setComboBox.getSelectedItem()).getKeys()) {
                for (MCInputVariableImpl mCInputVariableImpl : list) {
                    if (!mCInputVariableImpl.getShortName().equals(string)) continue;
                    arrayList.add(mCInputVariableImpl);
                }
            }
        }
        return arrayList;
    }

    private List<MCInputVariableImpl> getSelectedVariablesFromMoverDialog() {
        Object object = this._parent.getInputVariableList();
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        object = object.iterator();
        block0: while (object.hasNext()) {
            MCInputVariableImpl mCInputVariableImpl = (MCInputVariableImpl)object.next();
            for (String string : this._dialogSelectedNames) {
                if (!string.contains(mCInputVariableImpl.getShortName())) continue;
                arrayList.add(mCInputVariableImpl);
                continue block0;
            }
        }
        this._dialogSelectedNames.clear();
        return arrayList;
    }

    private List<MCInputVariableImpl> getAvailableVariables() {
        List<MCInputVariableImpl> list = this._parent.getInputVariableList();
        ArrayList<MCInputVariableImpl> arrayList = new ArrayList<MCInputVariableImpl>();
        for (MCInputVariableImpl object : list) {
            if (object.getCorrelationSetName() != null && !object.getCorrelationSetName().equals("null")) continue;
            arrayList.add(object);
        }
        for (String string : this._corrMatrix.keySet()) {
            for (String string2 : this._corrMatrix.get(string).getKeys()) {
                for (MCInputVariableImpl mCInputVariableImpl : list) {
                    if (!mCInputVariableImpl.getShortName().equals(string2)) continue;
                    arrayList.remove(mCInputVariableImpl);
                }
            }
        }
        return arrayList;
    }

    protected void saveToMatrix() {
        if (this._setComboBox.getSelectedItem() != null) {
            List list = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).getKeys();
            this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).setCorrelationSetName((String)this._setComboBox.getSelectedItem());
            for (int i = 0; i < list.size(); ++i) {
                for (int j = 0; j <= i; ++j) {
                    String string = (String)this._corJTbl.getValueAt(i, j + 1);
                    this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).setCorEntry((String)list.get(i), (String)list.get(j), Double.valueOf(string == null || string.isEmpty() ? Double.NaN : Double.valueOf(string)));
                }
            }
        }
    }

    protected void loadFromMatrix() {
        this.initializeJTable();
        this._loadingTable = true;
        if (this._corrMatrix != null) {
            List list = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).getKeys();
            for (int i = 0; i < list.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    Double d = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).getCorEntry((String)list.get(i), (String)list.get(j));
                    if (d == null || d.isInfinite() || d.isNaN()) continue;
                    this._corJTbl.setValueAt((Object)d.toString(), i, j + 1);
                }
            }
        }
        this._loadingTable = false;
    }

    private void getWarningText() {
        if (this._setComboBox.getSelectedItem() == null) {
            this._warningText.setText("No correlation set available. Please create a new correlation set.");
            this._warningText.revalidate();
            this._warningText.repaint();
            return;
        }
        double[] dArray = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).calculateEigenvalues();
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        Object object = "Eigen Values are [" + decimalFormat.format(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            object = ((String)object).concat(", " + decimalFormat.format(dArray[i]));
        }
        object = ((String)object).concat("]" + System.getProperty("line.separator") + "Positive or zero eigenvalues are required for the matrix to be a correlation matrix.");
        object = this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).cholesky(null) ? (String)object + System.getProperty("line.separator") : (String)object + System.getProperty("line.separator") + System.getProperty("line.separator") + "Error: The current matrix is not positive semi-definite." + System.getProperty("line.separator") + "Correlation matrix is required to be positive semi-definite for generating correlated random variables." + System.getProperty("line.separator");
        object = ((String)object).concat(System.getProperty("line.separator") + this.getVariableWarnings());
        this._warningText.setText((String)object);
        this._warningText.revalidate();
        this._warningText.repaint();
    }

    private String getVariableWarnings() {
        String string = "";
        for (String string2 : this._corrMatrix.get((String)this._setComboBox.getSelectedItem()).getKeys()) {
            MCInputVariableImpl mCInputVariableImpl = this.getVariableByName(string2);
            if (mCInputVariableImpl == null) {
                string = string.concat("WARNING: Variable " + string2 + " has been deleted from the variable list." + System.getProperty("line.separator"));
                continue;
            }
            if (mCInputVariableImpl.isActive()) continue;
            string = string.concat("WARNING: Variable " + string2 + " is inactive. This variable will be ignored when performing Monte Carlo compute." + System.getProperty("line.separator"));
        }
        return string;
    }

    private MCInputVariableImpl getVariableByName(String string) {
        for (MCInputVariableImpl mCInputVariableImpl : this._parent.getInputVariableList()) {
            if (!mCInputVariableImpl.getShortName().equals(string)) continue;
            return mCInputVariableImpl;
        }
        return null;
    }
}

