/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import hec.rss.plugins.montecarlo.client.DependencyGraphDialog$1;
import hec.rss.plugins.montecarlo.client.DependencyGraphDialog$2;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.model.DependencyMatrix;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import rma.swing.RmaJDialog;

public class DependencyGraphDialog
extends RmaJDialog {
    private MCInputPanel _inputPanel;
    private DependencyMatrix _dependMatrix;
    private mxGraph _graph = new DependencyGraphDialog$1();
    mxGraphComponent _graphComp;
    private JMenuBar _menuBar;
    private JMenu _menuFile;
    private JMenuItem _saveItem;

    public DependencyGraphDialog(Dialog dialog, MCInputPanel mCInputPanel) {
        super(dialog, "Dependency Diagram");
        this._inputPanel = mCInputPanel;
        this.buildPanel();
        this.addListeners();
    }

    private void addListeners() {
        this._saveItem.addActionListener(new DependencyGraphDialog$2(this));
    }

    private void buildPanel() {
        this._graphComp = new mxGraphComponent(this._graph);
        DependencyGraphDialog dependencyGraphDialog = this;
        dependencyGraphDialog.add((Component)dependencyGraphDialog._graphComp);
        this.buildGraphModel();
        this.createFileMenu();
    }

    private void createFileMenu() {
        this._menuBar = new JMenuBar();
        this._menuFile = new JMenu("File");
        this._saveItem = new JMenuItem("Save", 83);
        this._menuFile.add(this._saveItem);
        this._menuBar.add(this._menuFile);
        DependencyGraphDialog dependencyGraphDialog = this;
        dependencyGraphDialog.setJMenuBar(dependencyGraphDialog._menuBar);
    }

    private void buildGraphModel() {
        this._dependMatrix = this._inputPanel.getDepencyMatrix();
        Iterator<Object> iterator = this._dependMatrix.getAllEntries();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int[] nArray = new int[100];
        Object object22 = this._dependMatrix.getOrders();
        object22 = object22.values();
        int n = Collections.max(object22);
        int n2 = (Integer)Collections.min(object22);
        if (object22.size() > 1) {
            for (int i = object22.size() - 1; i > n; --i) {
                if (!object22.contains(i)) continue;
                n = i + 1;
                break;
            }
        }
        double d = 1000.0 / (double)(iterator.size() + 1);
        double d2 = 2500.0 / (double)(iterator.size() + 1);
        for (Object object22 : this._dependMatrix.getAllEntries()) {
            Object object3 = this._dependMatrix.getOrder(object22, 0);
            if ((Integer)object3 > n) {
                object3 = n;
            }
            if (this._dependMatrix.isInCircularGroup(object22)) {
                object3 = n + 1;
            }
            double d3 = 10.0 + d * (double)nArray[(Integer)object3];
            double d4 = 10.0 + d2 * (double)((Integer)object3 - n2);
            int n3 = (Integer)object3;
            nArray[n3] = nArray[n3] + 1;
            hashMap.put(object22, this._graph.insertVertex(this._graph.getDefaultParent(), null, object22, d4, d3, (double)(object22.toString().length() * 5 + 20), 50.0));
        }
        for (Object object22 : this._dependMatrix.getAllEntries()) {
            for (Object e : this._dependMatrix.getDependencies(object22)) {
                if (this._dependMatrix.getCircularGroup().contains(object22) && this._dependMatrix.getCircularGroup().contains(e)) {
                    this._graph.insertEdge(this._graph.getDefaultParent(), null, (Object)"", hashMap.get(object22), hashMap.get(e), "strokeWidth=3;strokeColor=red");
                    continue;
                }
                this._graph.insertEdge(this._graph.getDefaultParent(), null, (Object)"", hashMap.get(object22), hashMap.get(e), "strokeWidth=2");
            }
        }
        this._graphComp.setConnectable(false);
    }

    public void saveFile(String object) {
        BufferedImage bufferedImage = new BufferedImage(this._graphComp.getWidth(), this._graphComp.getHeight(), 1);
        this._graphComp.paintComponents((Graphics)bufferedImage.createGraphics());
        try {
            block5: {
                block4: {
                    if (((String)object).length() < 4) break block4;
                    Object object2 = object;
                    if (((String)object2).substring(((String)object2).length() - 4, ((String)object).length()).equals(".png")) break block5;
                }
                object = (String)object + ".png";
            }
            ImageIO.write((RenderedImage)bufferedImage, "png", new File((String)object));
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }
}

