/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.client.ClientApp;
import hec.heclib.dss.DSSPathname;
import hec.lang.NamedType;
import hec.rss.client.AbstractTimeSeriesPanel;
import hec.rss.io.ParseableDSSIdentifier;
import hec.rss.plugins.montecarlo.client.DiscreteConstantPanel$CellEditorListener2;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.statistics.DiscreteDist;
import java.awt.Color;
import java.awt.Component;
import javax.swing.event.CellEditorListener;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class DiscreteConstantPanel
extends AbstractTimeSeriesPanel {
    public DiscreteConstantPanel(Component component) {
        this.customize();
    }

    private void customize() {
        this.timeSeriesTable.setColumnLabels(new String[]{"Weight", "Prob.", "DSS File", "Part A", "Part B", "Part C", "Part E", "Part F", ""});
        this.timeSeriesTable.setColumnBackground(0, Color.WHITE);
        this.timeSeriesTable.setDoubleCellEditor(0);
        this.timeSeriesTable.setColumnPrecision(1, 3);
        this.timeSeriesTable.addCellEditorListener((CellEditorListener)new DiscreteConstantPanel$CellEditorListener2(this));
        this.timeSeriesTable.appendRows(10);
        this.timeSeriesTable.setAddRemoveEnabled(true);
        this.timeSeriesTable.setUnitsHeaderRenderer();
    }

    public boolean isColumnCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public boolean savePanel(NamedType namedType) {
        return true;
    }

    public void computeProbablities() {
        Object object;
        int n = this.timeSeriesTable.getRowCount();
        this.timeSeriesTable.commitEdit(true);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                if (((String)(object = (String)object)).isEmpty()) continue;
                d += Double.parseDouble((String)object);
                continue;
            }
            if (!(object instanceof Double)) continue;
            d += ((Double)object).doubleValue();
        }
        for (int i = 0; i < n; ++i) {
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                if (((String)(object = (String)object)).isEmpty()) continue;
                double d2 = Double.parseDouble((String)object) / d;
                this.timeSeriesTable.setValueAt((Object)d2, i, 1);
                continue;
            }
            if (!(object instanceof Double)) continue;
            double d3 = (Double)object / d;
            this.timeSeriesTable.setValueAt((Object)d3, i, 1);
        }
        this.timeSeriesTable.repaint();
    }

    public boolean isWeightZero() {
        for (int i = 0; i < this.timeSeriesTable.getRowCount(); ++i) {
            double d;
            double d2;
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            Object object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                double d3;
                if (((String)(object = (String)object)).isEmpty()) continue;
                d2 = Double.parseDouble((String)object);
                if (!(d3 > 0.0)) continue;
                return false;
            }
            if (!(object instanceof Double)) continue;
            d2 = (Double)object;
            if (!(d > 0.0)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "Discrete";
    }

    public void fillPanel(NamedType namedType) {
    }

    public void setDiscreteDis(DiscreteDist<ParseableDSSIdentifier> discreteDist) {
        for (int i = 0; i < discreteDist.size(); ++i) {
            ParseableDSSIdentifier parseableDSSIdentifier = (ParseableDSSIdentifier)discreteDist.getValue(i);
            DSSPathname dSSPathname = new DSSPathname(parseableDSSIdentifier.getDSSPath());
            this.timeSeriesTable.setValueAt((Object)discreteDist.getWeight(i), i, 0);
            this.timeSeriesTable.setValueAt((Object)parseableDSSIdentifier.getFileName(), i, 2);
            this.timeSeriesTable.setValueAt((Object)dSSPathname.getAPart(), i, 3);
            this.timeSeriesTable.setValueAt((Object)dSSPathname.getBPart(), i, 4);
            this.timeSeriesTable.setValueAt((Object)dSSPathname.getCPart(), i, 5);
            this.timeSeriesTable.setValueAt((Object)dSSPathname.getEPart(), i, 6);
            this.timeSeriesTable.setValueAt((Object)dSSPathname.getFPart(), i, 7);
        }
        this.computeProbablities();
    }

    public boolean savePanel() {
        return true;
    }

    public MCInputTSVariable getDistributions(MCInputTSVariable mCInputTSVariable) {
        this.timeSeriesTable.commitEdit(true);
        int n = this.timeSeriesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            double d = -1.0;
            ParseableDSSIdentifier parseableDSSIdentifier = new ParseableDSSIdentifier();
            DSSPathname dSSPathname = new DSSPathname();
            if (this.timeSeriesTable.getValueAt(i, 0) != null) {
                object = this.timeSeriesTable.getValueAt(i, 0);
                if (object instanceof String) {
                    String string = (String)object;
                    d = string.isEmpty() ? 0.0 : Double.parseDouble(string);
                } else if (object instanceof Double) {
                    d = (Double)object;
                }
            }
            if (this.timeSeriesTable.getValueAt(i, 2) != null && (object = this.timeSeriesTable.getValueAt(i, 2)) instanceof String) {
                if (((String)object).isEmpty()) continue;
                String string = ClientApp.Workspace().getWorkspacePath();
                parseableDSSIdentifier.setFileName(RMAIO.getRelativePath((String)string, (String)((String)object)));
            }
            if (this.timeSeriesTable.getValueAt(i, 3) != null && (object = this.timeSeriesTable.getValueAt(i, 3)) instanceof String) {
                dSSPathname.setAPart((String)object);
            }
            if (this.timeSeriesTable.getValueAt(i, 4) != null && (object = this.timeSeriesTable.getValueAt(i, 4)) instanceof String) {
                dSSPathname.setBPart((String)object);
            }
            if (this.timeSeriesTable.getValueAt(i, 5) != null && (object = this.timeSeriesTable.getValueAt(i, 5)) instanceof String) {
                dSSPathname.setCPart((String)object);
            }
            if (this.timeSeriesTable.getValueAt(i, 6) != null && (object = this.timeSeriesTable.getValueAt(i, 6)) instanceof String) {
                dSSPathname.setEPart((String)object);
            }
            if (this.timeSeriesTable.getValueAt(i, 7) != null && (object = this.timeSeriesTable.getValueAt(i, 7)) instanceof String) {
                dSSPathname.setFPart((String)object);
            }
            parseableDSSIdentifier.setDSSPath(dSSPathname.getPathname());
            mCInputTSVariable.setDiscreteDssID(d, parseableDSSIdentifier);
        }
        return mCInputTSVariable;
    }

    static /* synthetic */ RmaJTable a(DiscreteConstantPanel discreteConstantPanel) {
        return discreteConstantPanel.timeSeriesTable;
    }
}

