/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.clientapp.client.ClientApp;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.model.SeasonalRecord;
import hec.rss.client.AbstractTimeSeriesPanel;
import hec.rss.client.SeasonalVariationJDialog;
import hec.rss.io.ParseableDSSIdentifier;
import hec.rss.plugins.montecarlo.client.DiscreteSeasonalPanel$1;
import hec.rss.plugins.montecarlo.client.DiscreteSeasonalPanel$2;
import hec.rss.plugins.montecarlo.client.DiscreteSeasonalPanel$3;
import hec.rss.plugins.montecarlo.client.DiscreteSeasonalPanel$CellEditorListener2;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.SeasonalDiscreteDistribution;
import hec.statistics.AbstractContDist;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class DiscreteSeasonalPanel
extends AbstractTimeSeriesPanel {
    private RmaJButton _editSeasonsButton;
    HecTime[] _dates;
    private RmaJComboBox _dateComboBox;
    private int currentDateIndex = 0;
    private boolean _dateChanging;
    private Map<Integer, SeasonalRecord> _weights = new HashMap<Integer, SeasonalRecord>();
    private Map<Integer, SeasonalRecord> _probabilities = new HashMap<Integer, SeasonalRecord>();

    public DiscreteSeasonalPanel() {
        this.customize();
        this.addTableListener();
    }

    private void addTableListener() {
        this.getTableModel().addTableModelListener((TableModelListener)new DiscreteSeasonalPanel$1());
    }

    private void customize() {
        this.timeSeriesTable.setColumnLabels(new String[]{"Weight", "Prob.", "DSS File", "Part A", "Part B", "Part C", "Part E", "Part F", ""});
        this.timeSeriesTable.setColumnBackground(0, Color.WHITE);
        this.timeSeriesTable.setDoubleCellEditor(0);
        this.timeSeriesTable.setColumnPrecision(1, 3);
        this.timeSeriesTable.addCellEditorListener((CellEditorListener)new DiscreteSeasonalPanel$CellEditorListener2(this));
        this.timeSeriesTable.appendRows(10);
        this.timeSeriesTable.setAddRemoveEnabled(true);
        this.timeSeriesTable.setUnitsHeaderRenderer();
    }

    public boolean isColumnCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void buildControls() {
        this._dates = new HecTime[]{new HecTime("01/01/1900")};
        super.buildControls();
        DiscreteSeasonalPanel discreteSeasonalPanel = this;
        discreteSeasonalPanel.remove(discreteSeasonalPanel.timeSeriesTable.getScrollPane());
        DiscreteSeasonalPanel discreteSeasonalPanel2 = this;
        discreteSeasonalPanel2.remove(discreteSeasonalPanel2._buttonPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0555;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this._editSeasonsButton = new RmaJButton("Edit Seasons");
        this._editSeasonsButton.addActionListener((ActionListener)new DiscreteSeasonalPanel$2(this));
        DiscreteSeasonalPanel discreteSeasonalPanel3 = this;
        discreteSeasonalPanel3.add((Component)discreteSeasonalPanel3._editSeasonsButton, gridBagConstraints);
        gridBagConstraints.insets = RmaInsets.INSETS0555;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        Object[] objectArray = new String[this._dates.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this._dates[i].date(14).substring(0, 5);
        }
        this._dateComboBox = new RmaJComboBox(objectArray);
        this._dateComboBox.addActionListener((ActionListener)new DiscreteSeasonalPanel$3(this));
        DiscreteSeasonalPanel discreteSeasonalPanel4 = this;
        discreteSeasonalPanel4.add((Component)discreteSeasonalPanel4._dateComboBox, gridBagConstraints);
        JScrollPane jScrollPane = this.timeSeriesTable.getScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        DiscreteSeasonalPanel discreteSeasonalPanel5 = this;
        discreteSeasonalPanel5.add(discreteSeasonalPanel5._buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 14, 2, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
    }

    private boolean checkForDSSFile(int n) {
        if (!this.isDateChanging() && (this.timeSeriesTable.getModel().getRowCount() == 0 || this.timeSeriesTable.getModel().getValueAt(n, 3).equals("") || this.timeSeriesTable.getModel().getValueAt(n, 5).equals("") || this.timeSeriesTable.getModel().getValueAt(n, 6).equals("") || this.timeSeriesTable.getModel().getValueAt(n, 7).equals("") || this.timeSeriesTable.getModel().getValueAt(n, 8).equals(""))) {
            JOptionPane.showMessageDialog(new JFrame(), "DSS file must be set for each date before the variable may be created." + System.getProperty("line.separator") + " Please check the DSS file names and paths for selected time series", "Error", 0);
            return false;
        }
        return true;
    }

    public void computeProbablities() {
        Object object;
        int n = this.timeSeriesTable.getRowCount();
        this.timeSeriesTable.commitEdit(true);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                if (((String)(object = (String)object)).isEmpty()) continue;
                d += Double.parseDouble((String)object);
                continue;
            }
            if (!(object instanceof Double)) continue;
            d += ((Double)object).doubleValue();
        }
        for (int i = 0; i < n; ++i) {
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                if (((String)(object = (String)object)).isEmpty()) continue;
                double d2 = Double.parseDouble((String)object) / d;
                this.timeSeriesTable.setValueAt((Object)d2, i, 1);
            } else if (object instanceof Double) {
                double d3 = (Double)object / d;
                this.timeSeriesTable.setValueAt((Object)d3, i, 1);
            }
            object = this.timeSeriesTable.getValueAt(i, 0) instanceof String ? Double.valueOf((String)this.timeSeriesTable.getValueAt(i, 0)) : (Double)this.timeSeriesTable.getValueAt(i, 0);
            Double d4 = this.timeSeriesTable.getValueAt(i, 1) instanceof String ? Double.valueOf((String)this.timeSeriesTable.getValueAt(i, 1)) : (Double)this.timeSeriesTable.getValueAt(i, 1);
            this.addWeightToRecord(i, this._dates[this._dateComboBox.getSelectedIndex()], (Double)object, d4);
        }
        this.timeSeriesTable.repaint();
    }

    private void addWeightToRecord(Integer n, HecTime object, Double d, Double d2) {
        double[] dArray;
        double[] dArray2;
        int[] nArray;
        int n2 = HecTime.iymdjl((int)1900, (int)object.month(), (int)object.day()) * 1440;
        if (!this._weights.keySet().contains(n)) {
            this._weights.put(n, new SeasonalRecord());
            this._weights.get(n).setInterpolationType(2);
            this._probabilities.put(n, new SeasonalRecord());
            this._probabilities.get(n).setInterpolationType(2);
            nArray = new int[]{n2};
            dArray2 = new double[]{d};
            dArray = new double[]{d2};
        } else {
            object = this._weights.get(n).getTimeArray();
            double[] dArray3 = this._weights.get(n).getDataArray();
            double[] dArray4 = this._probabilities.get(n).getDataArray();
            nArray = new int[this._dates.length];
            dArray2 = new double[this._dates.length];
            dArray = new double[this._dates.length];
            block0: for (int i = 0; i < this._dates.length; ++i) {
                for (int j = 0; j < ((HecTime)object).length; ++j) {
                    if (n2 == HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440) {
                        nArray[i] = n2;
                        dArray2[i] = d;
                        dArray[i] = d2;
                        continue block0;
                    }
                    if (object[j] == HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440) {
                        nArray[i] = (int)object[j];
                        dArray2[i] = dArray3[j];
                        dArray[i] = dArray4[j];
                        continue block0;
                    }
                    if (j != ((HecTime)object).length - 1) continue;
                    nArray[i] = HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440;
                    dArray2[i] = 0.0;
                    dArray[i] = 0.0;
                }
            }
        }
        this._weights.get(n).setArrays(nArray, dArray2);
        this._probabilities.get(n).setArrays(nArray, dArray);
    }

    public void fillPanel(AbstractContDist abstractContDist, int n) {
    }

    public void fillPanel() {
    }

    void editSeasonAction() {
        int[] nArray = this.getTimes();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        window = new SeasonalVariationJDialog((Window)((Dialog)window), true);
        window.fillForm(nArray, 0);
        window.removeInterpPanel();
        window.setVisible(true);
        if (window.isCanceled()) {
            return;
        }
        nArray = window.getDateTimes();
        if (nArray.length > 1) {
            this.resetTimes(window.getDateTimes());
        }
        this._dateComboBox.setSelectedIndex(0);
        this.fillPanel();
    }

    private void _dateComboBoxAction() {
        this._dateChanging = true;
        this.currentDateIndex = this._dateComboBox.getSelectedIndex();
        int n = HecTime.iymdjl((int)1900, (int)this._dates[this.currentDateIndex].month(), (int)this._dates[this.currentDateIndex].day()) * 1440;
        for (int i = 0; i < this.timeSeriesTable.getRowCount(); ++i) {
            if (!this._weights.keySet().contains(i)) continue;
            this.timeSeriesTable.getModel().setValueAt(0.0, i, 0);
            for (int j = 0; j < this._weights.get(i).getDataArray().length; ++j) {
                int n2 = this._weights.get(i).getTimeArray()[j];
                if (n2 != n) continue;
                this.timeSeriesTable.getModel().setValueAt(this._weights.get(i).getDataArray()[j], i, 0);
            }
        }
        this.computeProbablities();
        this._dateChanging = false;
    }

    private boolean isDateChanging() {
        return this._dateChanging;
    }

    private void resetTimes(int[] nArray) {
        this.getTimes();
        new ArrayList();
        this._dates = new HecTime[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this._dates[i] = new HecTime(nArray[i] + 1440, 1);
        }
        String[] stringArray = new String[this._dates.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this._dates[i].date(14).substring(0, 5);
        }
        this._dateComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.timeSeriesTable.setUnitsHeaderRenderer();
    }

    private int[] getTimes() {
        int[] nArray = new int[this._dates.length];
        for (int i = 0; i < this._dates.length; ++i) {
            nArray[i] = HecTime.iymdjl((int)1900, (int)this._dates[i].month(), (int)this._dates[i].day()) * 1440;
        }
        return nArray;
    }

    public MCInputVariable getDistributions(MCInputTSVariable mCInputTSVariable) {
        this.timeSeriesTable.commitEdit(true);
        int n = this.timeSeriesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            ParseableDSSIdentifier parseableDSSIdentifier = new ParseableDSSIdentifier();
            DSSPathname dSSPathname = new DSSPathname();
            boolean bl = false;
            for (int j = 0; j < this.timeSeriesTable.getColumnCount(); ++j) {
                if (j == 1 || this.timeSeriesTable.getValueAt(i, j) == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            if (this.timeSeriesTable.getValueAt(i, 2) != null && (object6 = this.timeSeriesTable.getValueAt(i, 2)) instanceof String) {
                if (((String)object6).isEmpty()) continue;
                String string = ClientApp.Workspace().getWorkspacePath();
                parseableDSSIdentifier.setFileName(RMAIO.getRelativePath((String)string, (String)((String)object6)));
            }
            if (this.timeSeriesTable.getValueAt(i, 3) != null && (object5 = this.timeSeriesTable.getValueAt(i, 3)) instanceof String) {
                dSSPathname.setAPart((String)object5);
            }
            if (this.timeSeriesTable.getValueAt(i, 4) != null && (object4 = this.timeSeriesTable.getValueAt(i, 4)) instanceof String) {
                dSSPathname.setBPart((String)object4);
            }
            if (this.timeSeriesTable.getValueAt(i, 5) != null && (object3 = this.timeSeriesTable.getValueAt(i, 5)) instanceof String) {
                dSSPathname.setCPart((String)object3);
            }
            if (this.timeSeriesTable.getValueAt(i, 6) != null && (object2 = this.timeSeriesTable.getValueAt(i, 6)) instanceof String) {
                dSSPathname.setEPart((String)object2);
            }
            if (this.timeSeriesTable.getValueAt(i, 7) != null && (object = this.timeSeriesTable.getValueAt(i, 7)) instanceof String) {
                dSSPathname.setFPart((String)object);
            }
            parseableDSSIdentifier.setDSSPath(dSSPathname.getPathname());
            this.addDec31toWeights(i);
            mCInputTSVariable.setDiscreteDssID(this._weights.get(i), parseableDSSIdentifier);
        }
        return mCInputTSVariable;
    }

    private void addDec31toWeights(int n) {
        int[] nArray = new int[this._weights.get(n).getTimeArray().length + 1];
        double[] dArray = new double[this._weights.get(n).getTimeArray().length + 1];
        double[] dArray2 = new double[this._weights.get(n).getTimeArray().length + 1];
        for (int i = 0; i < dArray.length - 1; ++i) {
            nArray[i] = this._weights.get(n).getTimeArray()[i];
            dArray[i] = this._weights.get(n).getDataArray()[i];
            dArray2[i] = this._probabilities.get(n).getDataArray()[i];
        }
        nArray[dArray.length - 1] = 525600;
        dArray[dArray.length - 1] = this._weights.get(n).getDataArray()[dArray.length - 2];
        dArray2[dArray.length - 1] = this._probabilities.get(n).getDataArray()[dArray.length - 2];
        this._weights.get(n).setArrays(nArray, dArray);
        this._probabilities.get(n).setArrays(nArray, dArray2);
    }

    private void removeDec31fromWeights() {
        for (Integer n : this._weights.keySet()) {
            if (this._weights.get(n).getTimeArray()[this._weights.get(n).getTimeArray().length - 1] != 525600) {
                return;
            }
            int[] nArray = new int[this._weights.get(n).getTimeArray().length - 1];
            double[] dArray = new double[this._weights.get(n).getTimeArray().length - 1];
            double[] dArray2 = new double[this._weights.get(n).getTimeArray().length - 1];
            for (int i = 0; i < dArray.length; ++i) {
                nArray[i] = this._weights.get(n).getTimeArray()[i];
                dArray[i] = this._weights.get(n).getDataArray()[i];
                dArray2[i] = this._probabilities.get(n).getDataArray()[i];
            }
            this._weights.get(n).setArrays(nArray, dArray);
            this._probabilities.get(n).setArrays(nArray, dArray);
        }
    }

    private String getIntervalString(int n) {
        String string = n < 60 ? n + "MINUTE" : (n < 1440 ? n / 60 + "HOUR" : n / 1440 + "DAY");
        return string;
    }

    private List<ParseableDSSIdentifier> getPaths(int n) {
        ArrayList<ParseableDSSIdentifier> arrayList = new ArrayList<ParseableDSSIdentifier>();
        for (int i = 0; i < this._dates.length; ++i) {
            ParseableDSSIdentifier parseableDSSIdentifier = new ParseableDSSIdentifier();
            parseableDSSIdentifier.setDSSPath(this.getPathName(i, n).getPathname());
            parseableDSSIdentifier.setFileName(ClientApp.Workspace().makeAbsolutePath(this.getFileName(i, n)));
            parseableDSSIdentifier.setStartTime(new HecTime("01Jan1900 0000"));
            HecTime hecTime = new HecTime();
            hecTime.setCurrent();
            parseableDSSIdentifier.setEndTime(hecTime);
            arrayList.add(parseableDSSIdentifier);
        }
        return arrayList;
    }

    protected Vector<TimeSeriesContainer> getSelectedData() {
        int n = this.timeSeriesTable.getSelectedRow();
        Vector<TimeSeriesContainer> vector = new Vector<TimeSeriesContainer>();
        if (this.checkForDSSFile(n)) {
            vector.add(this.getTSDataSet(n));
        }
        return vector;
    }

    private TimeSeriesContainer getTSDataSet(int n) {
        String string = this.getFileName(0, n);
        DSSPathname dSSPathname = this.getPathName(0, n);
        HecTime hecTime = new HecTime();
        hecTime.setCurrent();
        RemoteWrapper remoteWrapper = null;
        try {
            remoteWrapper = ClientApp.Workspace().getData().getDSSFileManager();
        }
        catch (RemoteException remoteException) {
            System.out.println("RemoteException " + String.valueOf(remoteException));
            remoteException.printStackTrace();
        }
        DSSManager dSSManager = (DSSManager)remoteWrapper.getRemote();
        string = ClientApp.Workspace().makeAbsolutePath(string);
        dSSPathname = new DSSIdentifier(string, dSSPathname.getPathname());
        dSSPathname.setStartTime(new HecTime("01Jan1900 0000"));
        dSSPathname.setEndTime(hecTime);
        System.out.println("plotDssPathAction:plotting " + dSSPathname.getDSSPath() + " from " + dSSPathname.getFileName());
        string = null;
        try {
            string = dSSManager.readTS((DSSIdentifier)dSSPathname, true);
        }
        catch (FileNotFoundException | NullPointerException | RemoteException exception) {}
        return string;
    }

    private void createWeightsRecord() {
        int n;
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this._dateComboBox.getModel().getSize(); ++i) {
            arrayList.add(new HecTime((String)this._dateComboBox.getModel().getElementAt(i)));
            arrayList2.add(i);
            if (i == this._dateComboBox.getModel().getSize() - 1 && !"31Dec".equals(this._dateComboBox.getModel().getElementAt(i))) {
                arrayList.add(new HecTime("31Dec"));
                arrayList2.add(null);
                continue;
            }
            if (i != 0 || "01Jan".equals(this._dateComboBox.getModel().getElementAt(i))) continue;
            arrayList.add(0, new HecTime("01Jan"));
            arrayList2.add(0, null);
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray[n] = HecTime.iymdjl((int)1900, (int)((HecTime)arrayList.get(n)).month(), (int)((HecTime)arrayList.get(n)).day()) * 1440;
        }
        block2: for (n = 0; n < arrayList.size(); ++n) {
            int n2;
            double[] dArray = new double[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                if (arrayList2.get(n2) == null && (n == 1 || n == arrayList.size() - 2)) {
                    if (n2 == 0) {
                        int n3 = nArray[1];
                        int n4 = arrayList2.get(arrayList.size() - 1) == null ? nArray[arrayList.size() - 2] : nArray[arrayList.size() - 1];
                        if (n == 1) {
                            dArray[n2] = 1.0 - (double)n3 / ((double)n3 + (525600.0 - (double)n4));
                            continue;
                        }
                        dArray[n2] = 1.0 - (525600.0 - (double)n4) / ((double)n3 + (525600.0 - (double)n4));
                        continue;
                    }
                    dArray[n2] = dArray[0];
                    continue;
                }
                if (n2 != n || arrayList2.get(n2) == null) continue;
                dArray[n2] = 1.0;
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (!(dArray[n2] > 0.0)) continue;
                SeasonalRecord seasonalRecord = new SeasonalRecord();
                seasonalRecord.setArrays(nArray, dArray);
                seasonalRecord.setInterpolationType(0);
                continue block2;
            }
        }
    }

    private Vector<TimeSeriesContainer> getTSDataSets(int n) {
        Vector<TimeSeriesContainer> vector = new Vector<TimeSeriesContainer>();
        for (int i = 0; i < this._dates.length; ++i) {
            String string = this.getFileName(i, n);
            DSSPathname dSSPathname = this.getPathName(i, n);
            HecTime hecTime = new HecTime();
            hecTime.setCurrent();
            RemoteWrapper remoteWrapper = null;
            try {
                remoteWrapper = ClientApp.Workspace().getData().getDSSFileManager();
            }
            catch (RemoteException remoteException) {
                System.out.println("RemoteException " + String.valueOf(remoteException));
                remoteException.printStackTrace();
            }
            DSSManager dSSManager = (DSSManager)remoteWrapper.getRemote();
            string = ClientApp.Workspace().makeAbsolutePath(string);
            string = new DSSIdentifier(string, dSSPathname.getPathname());
            string.setStartTime(new HecTime("01Jan1900 0000"));
            string.setEndTime(hecTime);
            System.out.println("plotDssPathAction:plotting " + string.getDSSPath() + " from " + string.getFileName());
            dSSPathname = null;
            try {
                dSSPathname = dSSManager.readTS((DSSIdentifier)string, true);
            }
            catch (FileNotFoundException | NullPointerException | RemoteException exception) {}
            vector.add((TimeSeriesContainer)dSSPathname);
        }
        return vector;
    }

    private String getFileName(int n, int n2) {
        String string = (String)this.timeSeriesTable.getModel().getValueAt(n2, 3);
        return string;
    }

    private DSSPathname getPathName(int n, int n2) {
        DSSPathname dSSPathname = new DSSPathname();
        RmaTableModel rmaTableModel = (RmaTableModel)this.timeSeriesTable.getModel();
        String string = "";
        String string2 = (String)rmaTableModel.getValueAt(n2, 5);
        String string3 = (String)rmaTableModel.getValueAt(n2, 6);
        String string4 = (String)rmaTableModel.getValueAt(n2, 7);
        String string5 = (String)rmaTableModel.getValueAt(n2, 8);
        dSSPathname.setAPart(string);
        dSSPathname.setBPart(string2);
        dSSPathname.setCPart(string3);
        dSSPathname.setEPart(string4);
        dSSPathname.setFPart(string5);
        return dSSPathname;
    }

    public boolean savePanel() {
        return false;
    }

    public void fillPanel(NamedType namedType) {
    }

    public boolean savePanel(NamedType namedType) {
        return false;
    }

    public RmaTableModel getTableModel() {
        return (RmaTableModel)this.timeSeriesTable.getModel();
    }

    public RmaTableModel copyTableModel() {
        RmaTableModel rmaTableModel = new RmaTableModel();
        for (int i = 0; i < this.getTableModel().getColumnCount(); ++i) {
            rmaTableModel.addColumn(this.getTableModel().getColumnName(i));
            rmaTableModel.setColumnName(i, this.timeSeriesTable.getColumnLabel(i));
            for (int j = 0; j < this.getTableModel().getRowCount(); ++j) {
                rmaTableModel.setValueAt(this.getTableModel().getValueAt(j, i), j, i);
            }
        }
        return rmaTableModel;
    }

    public void setTableModel(RmaTableModel rmaTableModel) {
        this.timeSeriesTable.setModel((TableModel)rmaTableModel);
    }

    public void setDiscreteDis(SeasonalDiscreteDistribution<ParseableDSSIdentifier> seasonalDiscreteDistribution) {
        this.customize();
        if (!seasonalDiscreteDistribution.getValueList().isEmpty()) {
            CloneNotSupportedException cloneNotSupportedException;
            for (int i = 0; i < seasonalDiscreteDistribution.size(); ++i) {
                try {
                    this._weights.put(i, (SeasonalRecord)seasonalDiscreteDistribution.getWeightRecord(i).clone());
                    this._probabilities.put(i, (SeasonalRecord)seasonalDiscreteDistribution.getProbRecord(i).clone());
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException2) {
                    cloneNotSupportedException = cloneNotSupportedException2;
                    cloneNotSupportedException2.printStackTrace();
                }
            }
            this.removeDec31fromWeights();
            DiscreteSeasonalPanel discreteSeasonalPanel = this;
            discreteSeasonalPanel.setDates(discreteSeasonalPanel._weights.get(0).getTimeArray());
            for (int i = 0; i < seasonalDiscreteDistribution.size(); ++i) {
                ParseableDSSIdentifier parseableDSSIdentifier = seasonalDiscreteDistribution.getValue(i);
                cloneNotSupportedException = new DSSPathname(parseableDSSIdentifier.getDSSPath());
                this.timeSeriesTable.setValueAt((Object)seasonalDiscreteDistribution.getWeight(i, 0), i, 0);
                this.timeSeriesTable.setValueAt((Object)parseableDSSIdentifier.getFileName(), i, 2);
                this.timeSeriesTable.setValueAt((Object)cloneNotSupportedException.getAPart(), i, 3);
                this.timeSeriesTable.setValueAt((Object)cloneNotSupportedException.getBPart(), i, 4);
                this.timeSeriesTable.setValueAt((Object)cloneNotSupportedException.getCPart(), i, 5);
                this.timeSeriesTable.setValueAt((Object)cloneNotSupportedException.getEPart(), i, 6);
                this.timeSeriesTable.setValueAt((Object)cloneNotSupportedException.getFPart(), i, 7);
            }
            this.computeProbablities();
        }
    }

    private void setDates(int[] nArray) {
        int n;
        ArrayList<HecTime> arrayList = new ArrayList<HecTime>();
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            HecTime hecTime = new HecTime(nArray[n], 11);
            hecTime.showTimeAsBeginningOfDay(true);
            boolean bl = false;
            int n2 = 0;
            for (HecTime hecTime2 : arrayList) {
                if (hecTime.julian() < hecTime2.julian()) {
                    arrayList.add(n2, hecTime);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            arrayList.add(hecTime);
        }
        this._dates = new HecTime[arrayList.size()];
        for (n = 0; n < this._dates.length; ++n) {
            this._dates[n] = (HecTime)arrayList.get(n);
            nArray2[n] = this._dates[n].julian() * 1440;
        }
        for (n = 0; n < nArray2.length; ++n) {
            this._dates[n] = new HecTime(nArray2[n] + 1440, 1);
        }
        String[] stringArray = new String[this._dates.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this._dates[i].date(14).substring(0, 5);
        }
        this._dateComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.fillPanel();
    }

    public boolean isWeightZero() {
        for (int i = 0; i < this.timeSeriesTable.getRowCount(); ++i) {
            double d;
            double d2;
            if (this.timeSeriesTable.getValueAt(i, 0) == null) continue;
            Object object = this.timeSeriesTable.getValueAt(i, 0);
            if (object instanceof String) {
                double d3;
                if (((String)(object = (String)object)).isEmpty()) continue;
                d2 = Double.parseDouble((String)object);
                if (!(d3 > 0.0)) continue;
                return false;
            }
            if (!(object instanceof Double)) continue;
            d2 = (Double)object;
            if (!(d > 0.0)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ RmaJTable a(DiscreteSeasonalPanel discreteSeasonalPanel) {
        return discreteSeasonalPanel.timeSeriesTable;
    }
}

