/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.Parameter;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimplePairedValuesData;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.ClipDist;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalClipDist;
import hec.statistics.EmpiricalDist;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Vector;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;

public class DistPlotPanel
extends RmaJPanel {
    private static int a = 50;
    private G2dPanel _pdfPlot;
    private G2dPanel _cdfPlot;
    private int _paramId = Parameter.PARAMID_ELEV;

    public DistPlotPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildPanel();
        this.addListeners();
    }

    private void buildPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS0000;
        this._pdfPlot = new G2dPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        DistPlotPanel distPlotPanel = this;
        distPlotPanel.add((Component)distPlotPanel._pdfPlot, gridBagConstraints);
        this._cdfPlot = new G2dPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        DistPlotPanel distPlotPanel2 = this;
        distPlotPanel2.add((Component)distPlotPanel2._cdfPlot, gridBagConstraints);
    }

    private void addListeners() {
    }

    public void setParamId(int n) {
        this._paramId = n;
    }

    void configurePlotPanel(G2dPanel g2dPanel, String string) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        String string2 = Parameter.getParamString((int)this._paramId);
        String string3 = string2;
        g2dPlotProp.x1AxisProp.label = string3 + (string3.equals("%") ? "" : " (%S)");
        g2dPlotProp.x1AxisProp.name = string2;
        g2dPlotProp.y1AxisProp.name = string;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void updatePlots(ContDist contDist) {
        ClipDist clipDist;
        double d;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        ContDist contDist2;
        Object object;
        this._pdfPlot.clearPanel();
        DistPlotPanel distPlotPanel = this;
        distPlotPanel.configurePlotPanel(distPlotPanel._pdfPlot, "PDF");
        this._cdfPlot.clearPanel();
        DistPlotPanel distPlotPanel2 = this;
        distPlotPanel2.configurePlotPanel(distPlotPanel2._cdfPlot, "CDF");
        if (contDist == null) {
            return;
        }
        Vector<SimplePairedValuesData> vector = new Vector<SimplePairedValuesData>();
        Vector<SimplePairedValuesData> vector2 = new Vector<SimplePairedValuesData>();
        Vector<G2dLineProperties> vector3 = new Vector<G2dLineProperties>();
        if (contDist instanceof ClipDist && (!(contDist instanceof SeasonalContinuousDistribution) || !contDist.getType().contains("Empirical") && !contDist.getType().contains("Discrete"))) {
            object = (ClipDist)contDist.clone();
            object.getClipData().setMinClip(false);
            object.getClipData().setMaxClip(false);
            contDist2 = (ContDist)object.clone();
        } else {
            contDist2 = (ContDist)contDist.clone();
        }
        if (contDist2 instanceof EmpiricalDist || contDist2 instanceof SeasonalContinuousDistribution && contDist2.getType().contains("Empirical")) {
            EmpiricalDist empiricalDist = contDist2 instanceof SeasonalContinuousDistribution ? (EmpiricalDist)((SeasonalContinuousDistribution)contDist2).getDist() : (EmpiricalDist)contDist2;
            dArray3 = empiricalDist.getValues();
            var12_14 = dArray3.length;
            dArray2 = new double[3 * var12_14];
            object = new double[3 * var12_14];
            dArray = new double[3 * var12_14];
            for (int i = 0; i < var12_14; ++i) {
                d = dArray3[i];
                dArray2[3 * i] = d * 0.999999999999;
                dArray2[3 * i + 1] = d;
                dArray2[3 * i + 2] = d * 1.000000000001;
                object[3 * i] = (ClipDist)empiricalDist.getCDF(dArray2[3 * i]);
                object[3 * i + 1] = (ClipDist)empiricalDist.getCDF(dArray2[3 * i + 1]);
                object[3 * i + 2] = (ClipDist)empiricalDist.getCDF(dArray2[3 * i + 2]);
                dArray[3 * i] = empiricalDist.getPDF(dArray2[3 * i]);
                dArray[3 * i + 1] = empiricalDist.getPDF(dArray2[3 * i + 1]);
                dArray[3 * i + 2] = empiricalDist.getPDF(dArray2[3 * i + 2]);
            }
        } else {
            dArray2 = new double[a];
            object = new double[a];
            dArray = new double[a];
            double d2 = 1.0 / (double)a;
            for (var12_14 = 0; var12_14 < a; ++var12_14) {
                int n = var12_14;
                object[n] = (ClipDist)(((double)n + 0.5) * d2);
                dArray2[var12_14] = contDist2.invCDF((double)object[var12_14]);
                dArray[var12_14] = contDist2.getPDF(dArray2[var12_14]);
            }
        }
        for (int i = 0; i < ((ClipDist)object).length; ++i) {
            if (object[i] > 1.0) {
                object[i] = (ClipDist)1.0;
            }
            if (object[i] < 0.0) {
                object[i] = (ClipDist)0.0;
            }
            if (dArray[i] == Double.POSITIVE_INFINITY) {
                dArray[i] = 0.0;
            }
            if (Double.isNaN(dArray[i])) {
                dArray[i] = 0.0;
            }
            if (!(dArray[i] < 0.0)) continue;
            dArray[i] = 0.0;
        }
        SimplePairedValuesData simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xdata = dArray2;
        simplePairedValuesData.ydata = (double[])object;
        simplePairedValuesData.yunits = "CDF";
        simplePairedValuesData.xunits = Parameter.getParamString((int)this._paramId);
        simplePairedValuesData.setXParameterId(this._paramId);
        simplePairedValuesData.name = "CDF - Original";
        vector.add(simplePairedValuesData);
        simplePairedValuesData = new SimplePairedValuesData();
        new SimplePairedValuesData().xdata = dArray2;
        simplePairedValuesData.ydata = dArray;
        simplePairedValuesData.yunits = "PDF";
        simplePairedValuesData.xunits = Parameter.getParamString((int)this._paramId);
        simplePairedValuesData.setXParameterId(this._paramId);
        simplePairedValuesData.name = "PDF - Original";
        vector2.add(simplePairedValuesData);
        if (contDist instanceof ClipDist && (!(contDist2 instanceof SeasonalContinuousDistribution) || !contDist2.getType().contains("Empirical") && !contDist2.getType().contains("Discrete")) && (clipDist = (ClipDist)contDist).getClipData().hasMinClip() | clipDist.getClipData().hasMaxClip()) {
            double[] dArray4;
            double[] dArray5;
            if (clipDist instanceof EmpiricalClipDist) {
                EmpiricalClipDist empiricalClipDist = (EmpiricalClipDist)clipDist;
                double[] dArray6 = empiricalClipDist.getValues();
                var5_22 = dArray6.length;
                dArray5 = new double[3 * var5_22];
                dArray3 = new double[3 * var5_22];
                dArray4 = new double[3 * var5_22];
                for (int i = 0; i < var5_22; ++i) {
                    d = dArray6[i];
                    dArray5[3 * i] = d * 0.999999999999;
                    dArray5[3 * i + 1] = d;
                    dArray5[3 * i + 2] = d * 1.000000000001;
                    dArray3[3 * i] = empiricalClipDist.getCDF(dArray5[3 * i]);
                    dArray3[3 * i + 1] = empiricalClipDist.getCDF(dArray5[3 * i + 1]);
                    dArray3[3 * i + 2] = empiricalClipDist.getCDF(dArray5[3 * i + 2]);
                    dArray4[3 * i] = empiricalClipDist.getPDF(dArray5[3 * i]);
                    dArray4[3 * i + 1] = empiricalClipDist.getPDF(dArray5[3 * i + 1]);
                    dArray4[3 * i + 2] = empiricalClipDist.getPDF(dArray5[3 * i + 2]);
                }
            } else {
                dArray5 = new double[a];
                dArray3 = new double[a];
                dArray4 = new double[a];
                double d3 = 1.0 / (double)a;
                for (var5_22 = 0; var5_22 < a; ++var5_22) {
                    int n = var5_22;
                    dArray3[n] = ((double)n + 0.5) * d3;
                    dArray5[var5_22] = clipDist.invCDF(dArray3[var5_22]);
                    dArray4[var5_22] = clipDist.getPDF(dArray5[var5_22]);
                }
            }
            for (int i = 0; i < ((ClipDist)object).length; ++i) {
                if (dArray3[i] > 1.0) {
                    dArray3[i] = 1.0;
                }
                if (dArray3[i] < 0.0) {
                    dArray3[i] = 0.0;
                }
                if (dArray4[i] == Double.POSITIVE_INFINITY) {
                    dArray4[i] = 0.0;
                }
                if (Double.isNaN(dArray4[i])) {
                    dArray4[i] = 0.0;
                }
                if (!(dArray4[i] < 0.0)) continue;
                dArray4[i] = 0.0;
            }
            SimplePairedValuesData simplePairedValuesData2 = new SimplePairedValuesData();
            new SimplePairedValuesData().xdata = dArray5;
            simplePairedValuesData2.ydata = dArray3;
            simplePairedValuesData2.yunits = "CDF";
            simplePairedValuesData2.xunits = Parameter.getParamString((int)this._paramId);
            simplePairedValuesData2.setXParameterId(this._paramId);
            simplePairedValuesData2.name = "CDF - Clipped";
            vector.add(simplePairedValuesData2);
            simplePairedValuesData2 = new SimplePairedValuesData();
            new SimplePairedValuesData().xdata = dArray5;
            simplePairedValuesData2.ydata = dArray4;
            simplePairedValuesData2.yunits = "PDF";
            simplePairedValuesData2.xunits = Parameter.getParamString((int)this._paramId);
            simplePairedValuesData2.setXParameterId(this._paramId);
            simplePairedValuesData2.name = "PDF - Clipped";
            vector2.add(simplePairedValuesData2);
        }
        G2dLineProperties g2dLineProperties = new G2dLineProperties();
        new G2dLineProperties()._drawLine = true;
        g2dLineProperties._lineColor = Color.BLUE;
        g2dLineProperties._drawPoints = false;
        vector3.add(g2dLineProperties);
        g2dLineProperties = new G2dLineProperties();
        new G2dLineProperties()._drawLine = true;
        g2dLineProperties._lineColor = Color.RED;
        g2dLineProperties._drawPoints = false;
        vector3.add(g2dLineProperties);
        if (contDist instanceof SeasonalContinuousDistribution) {
            this._pdfPlot.setTitle("Distribution on " + ((SeasonalContinuousDistribution)contDist).getCurrentTimeString());
        }
        this._pdfPlot.setPlotObjects(vector2, vector3);
        this._pdfPlot.setDisplayUnitsSystem(1);
        this._pdfPlot.revalidate();
        this._pdfPlot.repaint();
        this._cdfPlot.setPlotObjects(vector, vector3);
        this._cdfPlot.setDisplayUnitsSystem(1);
        this._cdfPlot.revalidate();
        this._cdfPlot.repaint();
    }

    protected void setPlotsEnabled(boolean bl) {
        this._cdfPlot.setVisible(bl);
        this._pdfPlot.setVisible(bl);
    }
}

