/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.data.Parameter;
import hec.rss.plugins.montecarlo.client.DistPlotPanel;
import hec.rss.plugins.montecarlo.client.DistributionPanel$1;
import hec.rss.plugins.montecarlo.client.DistributionPanel$2;
import hec.rss.plugins.montecarlo.client.DistributionPanel$3;
import hec.rss.plugins.montecarlo.client.DistributionPanel$4;
import hec.rss.plugins.montecarlo.client.DistributionPanel$5;
import hec.rss.plugins.montecarlo.client.DistributionPanel$6;
import hec.rss.plugins.montecarlo.client.MCContinuousDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.ParamsCnstPanel;
import hec.rss.plugins.montecarlo.client.ParamsPanel;
import hec.rss.plugins.montecarlo.client.ParamsSeasonalPanel;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.statistics.AbstractContDist;
import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.MultiParametrizadDist;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;

public class DistributionPanel
extends RmaJPanel {
    protected AbstractContDist _dist;
    protected ParamsPanel _paramPanel;
    protected DistPlotPanel _plotPanel;
    private double _defaultValue;
    private boolean _isRelative;
    private boolean _isSeasonal;
    protected MCVariableWizardDialog _parent;
    private int _paramId;
    RmaJRadioButton _linearScaleRadio;
    private AbstractButton _logScaleRadio;
    private RmaJPanel _logScalePanel = new RmaJPanel((LayoutManager)new GridBagLayout());
    private RmaJTextArea _warningText;
    private MCContinuousDistributionWizardPanelImpl _distWizPanel;
    private boolean _ignoreTableModelEvents = false;
    private boolean _hasCriticalWarnings = false;

    public DistributionPanel(AbstractContDist abstractContDist, MCVariableWizardDialog mCVariableWizardDialog, boolean bl, boolean bl2, int n, MCContinuousDistributionWizardPanelImpl mCContinuousDistributionWizardPanelImpl) {
        super((LayoutManager)new GridBagLayout());
        this._dist = abstractContDist;
        this._isRelative = bl;
        this._isSeasonal = bl2;
        this._parent = mCVariableWizardDialog;
        this._paramId = n;
        this._distWizPanel = mCContinuousDistributionWizardPanelImpl;
        this.buildPanel();
        this.addListeners();
    }

    private void buildPanel() {
        Serializable serializable;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS5505;
        this._paramPanel = this.isSeasonal() ? new ParamsSeasonalPanel(this._dist, this) : new ParamsCnstPanel(this._dist.getClass(), this);
        if (this.isRelative()) {
            this._paramId = Parameter.PARAMID_PERCENT;
        }
        this._paramPanel.fillPanel(this._dist, this._paramId, new HashMap<Integer, String>());
        if (this._dist instanceof MultiParametrizadDist) {
            this._logScalePanel.setBorder((Border)BorderFactory.createTitledBorder("Parameter Scale"));
            this._logScaleRadio = new RmaJRadioButton("Logarithmic-scale");
            this._logScaleRadio.setSelected(true);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            this._logScalePanel.add((Component)this._logScaleRadio, (Object)gridBagConstraints);
            this._linearScaleRadio = new RmaJRadioButton("Linear-scale");
            this._linearScaleRadio.setSelected(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            this._logScalePanel.add((Component)this._linearScaleRadio, (Object)gridBagConstraints);
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add(this._logScaleRadio);
            ((ButtonGroup)serializable).add((AbstractButton)this._linearScaleRadio);
            this._linearScaleRadio.addActionListener((ActionListener)new DistributionPanel$1(this));
            this._logScaleRadio.addActionListener(new DistributionPanel$2(this));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            DistributionPanel distributionPanel = this;
            distributionPanel.add((Component)distributionPanel._logScalePanel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 2;
        } else {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 3;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        DistributionPanel distributionPanel = this;
        distributionPanel.add((Component)((Object)distributionPanel._paramPanel), gridBagConstraints);
        this._plotPanel = new DistPlotPanel();
        this._plotPanel.setParamId(this._paramId);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        DistributionPanel distributionPanel2 = this;
        distributionPanel2.add((Component)((Object)distributionPanel2._plotPanel), gridBagConstraints);
        this._warningText = new RmaJTextArea("No warnings to report");
        this._warningText.setEditable(false);
        this._warningText.setEnabled(false);
        this._warningText.setForeground(Color.RED);
        serializable = new JScrollPane((Component)this._warningText, 20, 30);
        ((JComponent)serializable).setPreferredSize(new Dimension(10, 10));
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Input Variable Warnings"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)serializable, gridBagConstraints);
    }

    public boolean isRelative() {
        return this._isRelative;
    }

    public boolean isSeasonal() {
        return this._isSeasonal;
    }

    private String getWarnings() {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        this._paramPanel.checkWarning(stringArray2, this._parent._alt);
        if (stringArray2[0].trim().isEmpty()) {
            stringArray2[0] = "No warnings to report";
        }
        return stringArray2[0];
    }

    public AbstractContDist getDistribution() {
        if (this._paramPanel.getDistribution() == null) {
            return this._dist;
        }
        return this._paramPanel.getDistribution();
    }

    public String getName() {
        if (this._dist instanceof EmpiricalDist) {
            if (((EmpiricalDist)this._dist).getInterpType() == EmpiricalDist.InterpType.LINEAR) {
                return "Empirical";
            }
            return "Discrete";
        }
        return this._dist.getType();
    }

    public double getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(double d) {
        this._defaultValue = d;
    }

    protected void updateDistribution() {
        AbstractContDist abstractContDist = this._paramPanel.getDistribution();
        if (abstractContDist != null) {
            if (!(abstractContDist instanceof EmpiricalDist) || ((EmpiricalDist)abstractContDist).getCumProbs().length > 0) {
                this.updateWarningText();
            }
            this._dist = abstractContDist;
            if (this._dist instanceof ClipDist && (!(this._dist instanceof SeasonalContinuousDistribution) || !this._dist.getType().contains("Empirical") && !this._dist.getType().contains("Discrete"))) {
                this._paramPanel.updateDistParams((ClipDist)this._dist);
                this._dist = (AbstractContDist)this._paramPanel.getClipDist();
            }
            if (this._hasCriticalWarnings) {
                this._plotPanel.updatePlots((ContDist)new EmpiricalDist());
                return;
            }
            this._plotPanel.updatePlots((ContDist)this._dist);
            return;
        }
        this._plotPanel.updatePlots((ContDist)new EmpiricalDist());
    }

    private void updateWarningText() {
        this._warningText.setText(this.getWarnings());
        this._warningText.setCaretPosition(0);
        this._warningText.repaint();
        this._warningText.revalidate();
        this._hasCriticalWarnings = false;
        Object object = new ArrayList<String>();
        object.add("ERROR: Discrete Distribution Data is not valid. Probabilities must add up to 1.\n");
        object.add("Your input data may not save correctly");
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (this._warningText.getText() == null || !this._warningText.getText().contains(string)) continue;
            this._hasCriticalWarnings = true;
            return;
        }
    }

    private boolean checkClipErrors(AbstractContDist abstractContDist) {
        boolean bl = false;
        ClipData clipData = ((ClipDist)this._dist).getClipData();
        if (clipData.hasMaxClip() && clipData.getMaxVal() <= abstractContDist.invCDF(0.0)) {
            bl = true;
        }
        if (clipData.hasMinClip() && clipData.getMinVal() >= abstractContDist.invCDF(1.0)) {
            bl = true;
        }
        return bl;
    }

    public void setIgnoreTableModelEvents(boolean bl) {
        this._ignoreTableModelEvents = bl;
    }

    protected void addListeners() {
        Object object;
        DistributionPanel$3 distributionPanel$3 = new DistributionPanel$3(this);
        DistributionPanel$4 distributionPanel$4 = new DistributionPanel$4(this);
        DistributionPanel$5 distributionPanel$5 = new DistributionPanel$5(this);
        DistributionPanel$6 distributionPanel$6 = new DistributionPanel$6(this);
        Component[] componentArray = this._paramPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component[] componentArray2 = ((RmaJPanel)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                Component component = componentArray2[j];
                if (component instanceof RmaJDecimalField) {
                    ((RmaJDecimalField)component).addFocusListener((FocusListener)distributionPanel$4);
                    continue;
                }
                if (component instanceof RmaJRadioButton) {
                    ((RmaJRadioButton)component).addActionListener((ActionListener)distributionPanel$5);
                    continue;
                }
                if (component instanceof RmaJCheckBox) {
                    ((RmaJCheckBox)component).addActionListener((ActionListener)distributionPanel$5);
                    continue;
                }
                if (component instanceof RmaJTable) {
                    ((RmaJTable)component).addTableModelListener((TableModelListener)distributionPanel$6);
                    ((RmaJTable)component).addMouseListener((MouseListener)distributionPanel$3);
                    continue;
                }
                if (component instanceof JScrollPane) {
                    object = ((JScrollPane)component).getViewport().getView();
                    if (!(object instanceof RmaJTable)) continue;
                    ((RmaJTable)object).addTableModelListener((TableModelListener)distributionPanel$6);
                    ((RmaJTable)object).addMouseListener((MouseListener)distributionPanel$3);
                    continue;
                }
                if (!(component instanceof RmaJPanel)) continue;
                object = ((RmaJPanel)component).getComponents();
                for (int k = 0; k < ((Component[])object).length; ++k) {
                    component = object[k];
                    if (component instanceof RmaJDecimalField) {
                        ((RmaJDecimalField)component).addFocusListener((FocusListener)distributionPanel$4);
                        continue;
                    }
                    if (!(component instanceof RmaJButton)) continue;
                    ((RmaJButton)component).addActionListener((ActionListener)distributionPanel$5);
                }
            }
        }
        if (this._paramPanel._clipPanel != null) {
            Component[] componentArray3 = this._paramPanel._clipPanel.getComponents();
            for (int i = 0; i < componentArray3.length; ++i) {
                Component[] componentArray4 = ((RmaJPanel)componentArray3[i]).getComponents();
                for (int j = 0; j < componentArray4.length; ++j) {
                    Component component;
                    object = componentArray4[j];
                    if (object instanceof RmaJDecimalField) {
                        ((RmaJDecimalField)object).addFocusListener((FocusListener)distributionPanel$4);
                        continue;
                    }
                    if (object instanceof RmaJRadioButton) {
                        ((RmaJRadioButton)object).addActionListener((ActionListener)distributionPanel$5);
                        continue;
                    }
                    if (object instanceof RmaJCheckBox) {
                        ((RmaJCheckBox)object).addActionListener((ActionListener)distributionPanel$5);
                        continue;
                    }
                    if (object instanceof RmaJTable) {
                        ((RmaJTable)object).addTableModelListener((TableModelListener)distributionPanel$6);
                        ((RmaJTable)object).addMouseListener((MouseListener)distributionPanel$3);
                        continue;
                    }
                    if (!(object instanceof JScrollPane) || !((component = ((JScrollPane)object).getViewport().getView()) instanceof RmaJTable)) continue;
                    ((RmaJTable)component).addTableModelListener((TableModelListener)distributionPanel$6);
                    ((RmaJTable)component).addMouseListener((MouseListener)distributionPanel$3);
                }
            }
        }
    }

    public void fillPanel(AbstractContDist abstractContDist, int n, Map<Integer, String> map) {
        this._dist = abstractContDist;
        if (this.isRelative()) {
            n = Parameter.PARAMID_PERCENT;
        }
        this._paramPanel.fillPanel(this._dist, n, map);
        this._plotPanel.setParamId(n);
        this._plotPanel.updatePlots((ContDist)this.getDistribution());
        if (!(abstractContDist instanceof EmpiricalDist) || ((EmpiricalDist)abstractContDist).getCumProbs().length != 0) {
            this._warningText.setText(this.getWarnings());
            this._warningText.setCaretPosition(0);
            this._warningText.repaint();
            this._warningText.revalidate();
            this.updateWarningText();
            if (this._hasCriticalWarnings) {
                this._plotPanel.updatePlots((ContDist)new EmpiricalDist());
                return;
            }
            this._plotPanel.updatePlots((ContDist)this._dist);
        }
    }

    public Map<Integer, String> getDependentVariableNames() {
        return this._paramPanel.getDependentVariableNames();
    }

    public void setStepInterp() {
        this._paramPanel._stepInterpRadio.setSelected(true);
    }

    public void resetAllSeasons(int[] nArray) {
        for (String string : this._distWizPanel._distMap.keySet()) {
            ((ParamsSeasonalPanel)this._distWizPanel._distMap.get((Object)string)._paramPanel).resetTimes(nArray);
        }
    }

    public void refreshWarnings() {
        this._warningText.setText(this.getWarnings());
        this._warningText.setCaretPosition(0);
        this._warningText.repaint();
        this._warningText.revalidate();
    }

    protected void setPlotPanelEnabled(boolean bl) {
        this._plotPanel.setPlotsEnabled(bl);
    }
}

