/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import com.google.common.flogger.FluentLogger;
import hec.rss.client.AlternativeEditor;
import hec.rss.model.RssAlt;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.montecarlo.client.MCControlPanel$1;
import hec.rss.plugins.montecarlo.client.MCControlPanel$2;
import hec.rss.plugins.montecarlo.client.MCControlPanel$ValidatingIntegerFieldManager;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCPanel;
import hec.rss.plugins.montecarlo.client.MCSampleScriptDialog;
import hec.rss.plugins.montecarlo.client.MonteCarloPanel;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputTSMultiplierVariable;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJIntegerSetField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.util.RMAConst;

public class MCControlPanel
extends EnabledJPanel
implements MCPanel {
    public static final String TAB = "MC Controls";
    protected static final int a = 100;
    protected static final int b = 1000;
    protected static final String c = "1-10";
    protected static final double d = 0.0;
    protected static final String e = "Monte Carlo Data Check";
    private boolean listenersAttached = false;
    private boolean _suppressListeners = false;
    private final transient MCControlPanel$ValidatingIntegerFieldManager f = new MCControlPanel$ValidatingIntegerFieldManager(this);
    private RmaJIntegerField _minIterationField;
    private RmaJIntegerField _maxIterationField;
    private RmaJRadioButton _continueRadio;
    private RmaJRadioButton _clearRadio;
    private RmaJRadioButton _simulateRadio;
    private RmaJIntegerSetField _iterationField;
    private MonteCarloPanel _parent;
    private JButton _preSampleScript;
    private JButton _postSampleScript;
    private RmaJButton _dataCheckButton;
    private RmaJDecimalField _randomNumberSeedField;
    private RssAlt _alt;
    private MCAltPluginData _data;

    public MCControlPanel(MonteCarloPanel monteCarloPanel) {
        super((LayoutManager)new GridBagLayout());
        this._parent = monteCarloPanel;
        this.buildControls();
        this.addActionListeners();
    }

    private void buildControls() {
        this._suppressListeners = true;
        try {
            Object object = new RmaJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)object, gridBagConstraints);
            RmaJLabel rmaJLabel = new RmaJLabel("Minimum Number of Iterations ");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)rmaJLabel, (Object)gridBagConstraints);
            this._minIterationField = new RmaJIntegerField();
            this._minIterationField.setMinValue(0);
            this._minIterationField.setShowErrorMsg(false);
            this._minIterationField.setVerifyInputWhenFocusTarget(false);
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._minIterationField, (Object)gridBagConstraints);
            this._minIterationField.setModifiable(true);
            this._minIterationField.getDocument().addDocumentListener(this.f.createDocumentListener(this._minIterationField));
            rmaJLabel = new RmaJLabel("Maximum Number of Iterations ");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)rmaJLabel, (Object)gridBagConstraints);
            this._maxIterationField = new RmaJIntegerField();
            this._maxIterationField.setMinValue(0);
            this._maxIterationField.setShowErrorMsg(false);
            this._maxIterationField.setVerifyInputWhenFocusTarget(false);
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = RmaInsets.INSETS5555;
            object.add((Component)this._maxIterationField, (Object)gridBagConstraints);
            this._maxIterationField.setModifiable(true);
            this._maxIterationField.getDocument().addDocumentListener(this.f.createDocumentListener(this._maxIterationField));
            rmaJLabel = new RmaJLabel("Stand-Alone Random Number Seed ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)rmaJLabel, (Object)gridBagConstraints);
            this._randomNumberSeedField = new MCControlPanel$1(this);
            this._randomNumberSeedField.setMinValue(0.0);
            this._randomNumberSeedField.setMaxValue(1.0);
            this._randomNumberSeedField.setVerifyInputWhenFocusTarget(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = RmaInsets.INSETS5555;
            object.add((Component)this._randomNumberSeedField, (Object)gridBagConstraints);
            this._randomNumberSeedField.setModifiable(true);
            object = new RmaJPanel((LayoutManager)new GridBagLayout());
            object.setBorder((Border)BorderFactory.createTitledBorder("Simulation Options"));
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)object, gridBagConstraints);
            this._continueRadio = new RmaJRadioButton("Continue to add iterations to previous Monte Carlo results");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._continueRadio, (Object)gridBagConstraints);
            this._clearRadio = new RmaJRadioButton("Clear previous Monte Carlo results and start first iteration");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._clearRadio, (Object)gridBagConstraints);
            rmaJLabel = new RmaJPanel((LayoutManager)new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = RmaInsets.INSETS0000;
            object.add((Component)rmaJLabel, (Object)gridBagConstraints);
            this._simulateRadio = new RmaJRadioButton("Simulate and save results for iteration(s) ");
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            rmaJLabel.add((Component)this._simulateRadio, (Object)gridBagConstraints);
            this._iterationField = new RmaJIntegerSetField();
            gridBagConstraints = new GridBagConstraints();
            new GridBagConstraints().gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            rmaJLabel.add((Component)this._iterationField, (Object)gridBagConstraints);
            object = new ButtonGroup();
            ((ButtonGroup)object).add((AbstractButton)this._simulateRadio);
            ((ButtonGroup)object).add((AbstractButton)this._clearRadio);
            ((ButtonGroup)object).add((AbstractButton)this._continueRadio);
            object = new RmaJPanel((LayoutManager)new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)object, gridBagConstraints);
            this._preSampleScript = new RmaJButton("Pre-Sample Script");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._preSampleScript, (Object)gridBagConstraints);
            this._postSampleScript = new RmaJButton("Post-Sample Script");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._postSampleScript, (Object)gridBagConstraints);
            object = new RmaJPanel((LayoutManager)new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)object, gridBagConstraints);
            this._dataCheckButton = new RmaJButton("Data Check");
            this._dataCheckButton.setEnabled(true);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = RmaInsets.INSETS5505;
            object.add((Component)this._dataCheckButton, (Object)gridBagConstraints);
            return;
        }
        finally {
            this._suppressListeners = false;
        }
    }

    private void addActionListeners() {
        this._preSampleScript.addActionListener(actionEvent -> this.addPreSampleScriptAction());
        this._postSampleScript.addActionListener(actionEvent -> this.addPostSampleScriptAction());
        this._dataCheckButton.addActionListener(actionEvent -> this.dataCheckAction());
    }

    public void addPreSampleScriptAction() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof AlternativeEditor) {
            object = (RmaJDialog)object;
            object = new MCSampleScriptDialog((RmaJDialog)object, false, true);
            ((MCSampleScriptDialog)((Object)object)).fillPanel(this._data, this._alt);
            object.setVisible(true);
        }
    }

    public void addPostSampleScriptAction() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof AlternativeEditor) {
            object = (RmaJDialog)object;
            object = new MCSampleScriptDialog((RmaJDialog)object, false, false);
            ((MCSampleScriptDialog)((Object)object)).fillPanel(this._data, this._alt);
            object.setVisible(true);
        }
    }

    public void dataCheckAction() {
        String[] stringArray;
        MCInputPanel mCInputPanel = this._parent.getInputVariablePanel();
        Object object = this._parent.getOutputVariablePanel();
        if (mCInputPanel.isModified() || object.isModified()) {
            stringArray = new StringBuilder("<html>Unsaved changes detected in:<br>");
            if (mCInputPanel.isModified()) {
                stringArray.append("- Input variables<br>");
            }
            if (object.isModified()) {
                stringArray.append("- Output variables<br>");
            }
            stringArray.append("<br>Would you like to save changes now?</html>");
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), stringArray.toString(), e, 0);
            if (n != 0) {
                return;
            }
            this._parent.savePanel(this._alt);
        }
        stringArray = new String[1];
        boolean bl = this.checkError(stringArray);
        object = new String[1];
        boolean bl2 = this.checkWarning((String[])object);
        object = stringArray[0] + object[0];
        if (((String[])(object = object.split(System.lineSeparator()))).length > 25) {
            String[] stringArray2 = Arrays.copyOfRange(object, 0, 26);
            object = stringArray2;
            stringArray2[25] = "... list truncated due to volume of errors/warnings.";
        }
        if (bl2 && bl) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No errors or warnings to report", e, 1);
            return;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), object, e, 2);
    }

    public boolean checkError(String[] stringArray) {
        return ((MCAltPluginData)this._alt.getAltPluginData(AltPluginDataFactory.MC)).dataOK(stringArray);
    }

    public boolean checkWarning(String[] stringArray) {
        int n;
        stringArray[0] = "";
        boolean bl = true;
        for (n = 0; n < this._data.getInputVariables().size(); ++n) {
            MCInputVariable mCInputVariable = this._data.getInputVariables().get(n);
            if (mCInputVariable == null) continue;
            boolean bl2 = bl = mCInputVariable.checkWarnings(stringArray, this._alt) && bl;
            if (this.isDuplicated(mCInputVariable.getType(), mCInputVariable.getLocation(), mCInputVariable.getParameter())) {
                stringArray[0] = stringArray[0].concat("WARNING: Input variable " + mCInputVariable.getClassName() + " at " + mCInputVariable.getLocation() + " is duplicated in the input table ... this may lead to errors in Monte Carlo sampling." + System.getProperty("line.separator"));
            }
            if (!(mCInputVariable instanceof MCInputTSMultiplierVariable) && !(mCInputVariable instanceof MCInputTSVariable) || !this.isTSConflict(mCInputVariable.getType(), mCInputVariable.getLocation(), mCInputVariable.getParameter()) || stringArray[0].contains("WARNING: Input time series at " + mCInputVariable.getLocation())) continue;
            stringArray[0] = stringArray[0].concat("WARNING: Input time series at " + mCInputVariable.getLocation() + " has discrete sampling and a multiplier defined ... this may lead to errors in Monte Carlo sampling." + System.getProperty("line.separator"));
        }
        n = 1;
        for (int i = 0; i < this._data.getOutputVariables().size(); ++i) {
            MCOutputVariable mCOutputVariable = this._data.getOutputVariables().get(i);
            if (mCOutputVariable == null) continue;
            n = n != 0 && mCOutputVariable.checkWarnings(stringArray, this._alt) ? 1 : 0;
        }
        return bl && n != 0;
    }

    public boolean isDuplicated(int n, String string, String string2) {
        int n2 = 0;
        List<MCInputVariableImpl> list = this._data.getInputVariables();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            int n3 = object.getType();
            String string3 = object.getLocation();
            object = object.getParameter();
            if (n3 != n || !string3.equals(string) || !((String)object).equals(string2) || ++n2 != 2) continue;
            return true;
        }
        return false;
    }

    public boolean isTSConflict(int n, String string, String string2) {
        List<MCInputVariableImpl> list = this._data.getInputVariables();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            int n2 = object.getType();
            String string3 = object.getLocation();
            object = object.getParameter();
            if ((n2 != 0 || n != 4) && (n2 != 4 || n != 0) || !string3.equals(string) || !((String)object).equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void fillPanel(MCAltPluginData mCAltPluginData, RssAlt rssAlt) {
        this._suppressListeners = true;
        try {
            this._alt = rssAlt;
            this._data = mCAltPluginData;
            if (mCAltPluginData == null) {
                this.applyDefaultsToUI();
                return;
            }
            this.applyDataToUI(RMAConst.isValidValue((int)mCAltPluginData.getMinIterations()) ? mCAltPluginData.getMinIterations() : 100, RMAConst.isValidValue((int)mCAltPluginData.getMaxIterations()) ? mCAltPluginData.getMaxIterations() : 1000, mCAltPluginData.getStandaloneSeed(), mCAltPluginData.getSimulationOption(), mCAltPluginData.getIterationString().isEmpty() ? c : mCAltPluginData.getIterationString());
            if (!this.listenersAttached) {
                this.attachFocusListeners();
                this.listenersAttached = true;
            }
            return;
        }
        finally {
            this._suppressListeners = false;
        }
    }

    private void attachFocusListeners() {
        this._minIterationField.addFocusListener(this.f.createFocusListener(this._minIterationField, 100, this._data::setMinIterations));
        this._maxIterationField.addFocusListener(this.f.createFocusListener(this._maxIterationField, 1000, this._data::setMaxIterations));
        this._randomNumberSeedField.addFocusListener((FocusListener)new MCControlPanel$2(this));
    }

    private void applyDataToUI(int n, int n2, double d, int n3, String string) {
        this._minIterationField.setValue(n);
        this._maxIterationField.setValue(n2);
        this.f.setInitialValues(this._minIterationField, n);
        this.f.setInitialValues(this._maxIterationField, n2);
        this._randomNumberSeedField.setValue(d);
        this.selectSimulationOption(n3);
        this._iterationField.setText(string);
    }

    private void applyDefaultsToUI() {
        this.applyDataToUI(100, 1000, 0.0, 2, c);
    }

    private void selectSimulationOption(int n) {
        switch (n) {
            case 0: {
                this._continueRadio.setSelected(true);
                return;
            }
            case 1: {
                this._clearRadio.setSelected(true);
                return;
            }
            case 2: {
                this._simulateRadio.setSelected(true);
                return;
            }
        }
        ((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).log("Unexpected simulation option %d defaulting to SIMULATE_AND_SAVE.", n);
    }

    public void clear() {
        this._suppressListeners = true;
        try {
            this._continueRadio.setSelected(true);
            this._iterationField.clearPerformed();
            this._minIterationField.setText("");
            this._maxIterationField.setText("");
            this._randomNumberSeedField.setText("");
            return;
        }
        finally {
            this._suppressListeners = false;
        }
    }

    public boolean savePanel(MCAltPluginData mCAltPluginData) {
        boolean bl = true;
        mCAltPluginData.setMinIterations(this._minIterationField.getValue());
        mCAltPluginData.setMaxIterations(this._maxIterationField.getValue());
        if (this._randomNumberSeedField.isValid(true)) {
            mCAltPluginData.setStandaloneSeed(this._randomNumberSeedField.getValue());
        } else {
            bl = false;
        }
        if (this._continueRadio.isSelected()) {
            mCAltPluginData.setSimulationOption(0);
        } else if (this._clearRadio.isSelected()) {
            mCAltPluginData.setSimulationOption(1);
        } else if (this._simulateRadio.isSelected()) {
            mCAltPluginData.setSimulationOption(2);
        }
        mCAltPluginData.setIterationString(this._iterationField.getText());
        mCAltPluginData.setIterations(this._iterationField.getIntegerSet());
        if (this._data != null) {
            mCAltPluginData.setMCScripts(this._data.getMCScripts(true), true);
            mCAltPluginData.setMCScripts(this._data.getMCScripts(false), false);
        }
        return bl;
    }

    public void setAlt(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public void setClearResultsRadio() {
        this._clearRadio.doClick(0);
    }

    public boolean isClearResultsRadioSelected() {
        return this._clearRadio.isSelected();
    }
}

