/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;

public class MCConvergencePanel
extends EnabledJPanel {
    public static final String TAB = "Convergence Variables";
    private RmaJTable _inputTable;
    private JCheckBox _isActiveCheckbox;
    private AlternativePanel _parent;
    private RssAlt _alt;
    private List<MCOutputVariable> _variableList = new ArrayList<MCOutputVariable>();

    public MCConvergencePanel(AlternativePanel alternativePanel) {
        super((LayoutManager)new GridBagLayout());
        this._parent = alternativePanel;
        this.buildControls();
    }

    private void buildControls() {
        this._inputTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Active", "Location", "Parameter", "Statistic", "Confidence (%)", "Tolerance (%)"});
        this._isActiveCheckbox = this._inputTable.setCheckBoxCellEditor(0);
        this._inputTable.setColumnEnabled(false, 1);
        this._inputTable.setColumnEnabled(false, 2);
        this._inputTable.setColumnEnabled(false, 3);
        this._inputTable.setColumnEnabled(false, 4);
        this._inputTable.setColumnEnabled(false, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MCConvergencePanel mCConvergencePanel = this;
        mCConvergencePanel.add(mCConvergencePanel._inputTable.getScrollPane(), gridBagConstraints);
        this._inputTable.setAutoResizeMode(4);
        this._inputTable.setColumnWidth(0, this._inputTable.getColumnWidthFromData(0));
        this._inputTable.setColumnWidth(5, this._inputTable.getColumnWidthFromData(5));
    }

    public void clear() {
        this._inputTable.selectAll();
        this._inputTable.deleteRow();
        this._variableList = new ArrayList<MCOutputVariable>();
    }

    public void removeVariable(MCOutputVariable mCOutputVariable) {
        if (this._variableList.contains(mCOutputVariable)) {
            int n = this._variableList.indexOf(mCOutputVariable);
            if (this._inputTable.getRowCount() < n + 1) {
                return;
            }
            this._inputTable.deleteRow(n);
            this._variableList.remove(n);
        }
    }

    public void addVariable(MCOutputVariable mCOutputVariable) {
        if (!mCOutputVariable.hasConv()) {
            if (this._variableList.contains(mCOutputVariable)) {
                int n = this._variableList.indexOf(mCOutputVariable);
                if (this._inputTable.getRowCount() < n + 1) {
                    return;
                }
                this._inputTable.deleteRow(n);
                this._variableList.remove(n);
            }
            return;
        }
        if (this._variableList.contains(mCOutputVariable)) {
            MCConvergencePanel mCConvergencePanel = this;
            mCConvergencePanel.addVariable(mCConvergencePanel._variableList.indexOf(mCOutputVariable), mCOutputVariable);
            return;
        }
        MCConvergencePanel mCConvergencePanel = this;
        mCConvergencePanel.addVariable(mCConvergencePanel._variableList.size(), mCOutputVariable);
    }

    public void addVariable(int n, MCOutputVariable mCOutputVariable) {
        if (n == -1) {
            if (this._inputTable.getRowCount() == 1) {
                Object object = this._inputTable.getValueAt(0, 1);
                if (object == null) {
                    n = 0;
                } else if (object instanceof String) {
                    if (((String)object).isEmpty() || ((String)object).equals(" ")) {
                        n = 0;
                    } else {
                        this._inputTable.appendRow();
                        n = this._inputTable.getRowCount() - 1;
                    }
                } else {
                    this._inputTable.appendRow();
                    n = this._inputTable.getRowCount() - 1;
                }
            } else {
                this._inputTable.appendRow();
                n = this._inputTable.getRowCount() - 1;
            }
        }
        if (this._variableList.size() != n && (this._variableList.size() > n || this._variableList.get(n) != null)) {
            this._variableList.set(n, mCOutputVariable);
        } else {
            this._variableList.add(n, mCOutputVariable);
        }
        this._inputTable.setValueAt((Object)mCOutputVariable.isActive(), n, 0);
        this._isActiveCheckbox.setSelected(mCOutputVariable.isActive());
        this._inputTable.setValueAt((Object)this._alt.getSystem().getNameForKeyString(mCOutputVariable.getProxyName()), n, 1);
        this._inputTable.setValueAt((Object)RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()), n, 2);
        this._inputTable.setValueAt((Object)mCOutputVariable.getStatistic(), n, 3);
        this._inputTable.setValueAt((Object)mCOutputVariable.getConfidence(), n, 4);
        this._inputTable.setValueAt((Object)mCOutputVariable.getRelTol(), n, 5);
        this._inputTable.setColumnEnabled(false, 0);
        this._inputTable.setColumnEnabled(false, 1);
        this._inputTable.setColumnEnabled(false, 2);
        this._inputTable.setColumnEnabled(false, 3);
        this._inputTable.setColumnEnabled(false, 4);
        this._inputTable.setColumnEnabled(false, 5);
    }

    public int getSelectedRow() {
        return this._inputTable.getSelectedRow();
    }

    public void fillPanel(MCAltPluginData object, RssAlt object2) {
        this.clear();
        this._alt = object2;
        this._variableList.clear();
        if (object == null) {
            return;
        }
        object2 = ((MCAltPluginData)((Object)object)).getOutputVariables();
        int n = 0;
        for (int i = 0; i < object2.size(); ++i) {
            object = (MCOutputVariable)object2.get(i);
            if (!((MCOutputVariable)object).hasConv()) continue;
            this._variableList.add((MCOutputVariable)object);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).isActive(), n, 0);
            this._isActiveCheckbox.setSelected(((MCOutputVariable)object).isActive());
            this._inputTable.setCellEnabled(false, n, 0);
            this._inputTable.setValueAt((Object)this._alt.getSystem().getNameForKeyString(((MCOutputVariable)object).getProxyName()), n, 1);
            this._inputTable.setCellEnabled(false, n, 1);
            this._inputTable.setValueAt((Object)RssModelVariableSet.getParamName((int)((MCOutputVariable)object).getModelVariableId()), n, 2);
            this._inputTable.setCellEnabled(false, n, 2);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getStatistic(), n, 3);
            this._inputTable.setCellEnabled(false, n, 3);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getConfidence(), n, 4);
            this._inputTable.setCellEnabled(false, n, 4);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getRelTol(), n, 5);
            this._inputTable.setCellEnabled(false, n, 5);
            ++n;
        }
    }
}

