/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.client.AbstractTimeSeriesPanel;
import hec.rss.model.RssAlt;
import hec.rss.plugins.montecarlo.client.DiscreteConstantPanel;
import hec.rss.plugins.montecarlo.client.DiscreteSeasonalPanel;
import hec.rss.plugins.montecarlo.client.MCVariableDistributionWizardPanelImpl;
import hec.rss.plugins.montecarlo.model.MCInputTSVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalDiscreteDistribution;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;

public class MCDiscreteDistributionWizardPanel
extends MCVariableDistributionWizardPanelImpl {
    public static final String PANEL_NAME = "Distribution";
    public static final int DISCRETE = 0;
    private RmaJComboBox<String> _distributionType;
    private AbstractTimeSeriesPanel _discretePanel;
    private JPanel _cardPanel;
    private boolean _isSeasonal;
    private RssAlt _alt;

    public MCDiscreteDistributionWizardPanel(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    public void buildPanel(boolean bl) {
        this.removeAll();
        this.setSeasonal(bl);
        this._discretePanel = this.isSeasonal() ? new DiscreteSeasonalPanel() : new DiscreteConstantPanel((Component)((Object)this));
        JLabel jLabel = new JLabel("Select Distribution Parameters");
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Variable");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._variableNameField, gridBagConstraints);
        this._variableNameField.setEnabled(false);
        jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add(jPanel, gridBagConstraints);
        jLabel = new JLabel("Distribution Type");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._distributionType = new RmaJComboBox((Object[])new String[]{"Discrete"});
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        jPanel.add((Component)this._distributionType, gridBagConstraints);
        this._cardPanel = new JPanel();
        this._cardPanel.setLayout(new CardLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        MCDiscreteDistributionWizardPanel mCDiscreteDistributionWizardPanel = this;
        mCDiscreteDistributionWizardPanel.add(mCDiscreteDistributionWizardPanel._cardPanel, gridBagConstraints);
        this._cardPanel.add(this._discretePanel.getName(), (Component)this._discretePanel);
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, this._discretePanel.getName());
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        return true;
    }

    public int getDistributionType() {
        return this._distributionType.getSelectedIndex();
    }

    public MCInputVariable getInputVariable() {
        Object object = this._variableNameField.getText();
        object = ((String)object).substring(((String)object).indexOf(45) + 1, ((String)object).length());
        String string = ((String)object).substring(0, ((String)object).indexOf(":")).trim();
        String string2 = object;
        object = string2.substring(string2.indexOf(":") + 1, ((String)object).length());
        object = new MCInputTSVariable(string, (String)object, 0, this.isSeasonal());
        if (this.isSeasonal()) {
            ((DiscreteSeasonalPanel)this._discretePanel).getDistributions((MCInputTSVariable)object);
        } else {
            ((DiscreteConstantPanel)this._discretePanel).getDistributions((MCInputTSVariable)object);
        }
        object.setParameterEqualString(this._variableNameField.getText());
        return object;
    }

    public void fillEditPanel(MCInputTSVariable mCInputTSVariable) {
        if (mCInputTSVariable != null && mCInputTSVariable.getDistributionType() == 0) {
            this.buildPanel(mCInputTSVariable.isSeasonal());
            this._distributionType.setSelectedIndex(0);
            if (this.isSeasonal()) {
                ((DiscreteSeasonalPanel)this._discretePanel).setDiscreteDis((SeasonalDiscreteDistribution)mCInputTSVariable.getDiscreteDist());
            } else {
                ((DiscreteConstantPanel)this._discretePanel).setDiscreteDis(mCInputTSVariable.getDiscreteDist());
            }
            this._variableNameField.setText(((MCInputVariableImpl)mCInputTSVariable).getParameterEqualString());
        }
    }

    public boolean isTotalWeightZero() {
        if (this.isSeasonal()) {
            return ((DiscreteSeasonalPanel)this._discretePanel).isWeightZero();
        }
        return ((DiscreteConstantPanel)this._discretePanel).isWeightZero();
    }

    public boolean isSeasonal() {
        return this._isSeasonal;
    }

    public void setSeasonal(boolean bl) {
        this._isSeasonal = bl;
    }
}

