/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.heclib.util.HecTime;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.RssAlt;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.montecarlo.client.CorrelationMatrixDialog;
import hec.rss.plugins.montecarlo.client.DependencyGraphDialog;
import hec.rss.plugins.montecarlo.client.MCInputPanel$1;
import hec.rss.plugins.montecarlo.client.MCInputPanel$10;
import hec.rss.plugins.montecarlo.client.MCInputPanel$2;
import hec.rss.plugins.montecarlo.client.MCInputPanel$3;
import hec.rss.plugins.montecarlo.client.MCInputPanel$4;
import hec.rss.plugins.montecarlo.client.MCInputPanel$5;
import hec.rss.plugins.montecarlo.client.MCInputPanel$6;
import hec.rss.plugins.montecarlo.client.MCInputPanel$7;
import hec.rss.plugins.montecarlo.client.MCInputPanel$8;
import hec.rss.plugins.montecarlo.client.MCInputPanel$9;
import hec.rss.plugins.montecarlo.client.MCInputPanel$MCVariableTableModel;
import hec.rss.plugins.montecarlo.client.MCPanel;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.client.MonteCarloPanel;
import hec.rss.plugins.montecarlo.model.DependencyMatrix;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCInputScriptVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import hec.rss.plugins.montecarlo.model.SeasonalContinuousDistribution;
import hec.rss.server.JunctionDialog;
import hec.statistics.CorrelationMatrix;
import hec.statistics.EmpiricalDist;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableModel;
import rma.swing.CollapsableJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;

public class MCInputPanel
extends RmaJPanel
implements MCPanel {
    public static final String TAB = "Input Variables";
    public static final String REFERENCE_ABSOLUTE = "Absolute";
    public static final String REFERENCE_RELATIVE = "Relative";
    public static final String SEASONALITY_CONSTANT = "Constant";
    public static final String SEASONALITY_SEASONAL = "Seasonal";
    public static final String VAR_TYPE_TIMESERIES = "TimeSeries";
    public static final String VAR_TYPE_RULE_PARAM = "Rule Parameter";
    public static final String VAR_TYPE_RATING_CURVE = "Rating Curve";
    public static final String VAR_TYPE_LOOKBACK = "Lookback";
    public static final String VAR_TYPE_TS_MULTIPLIER = "TS Multiplier";
    public static final String VAR_TYPE_SCRIPT = "Script";
    public static final String DIST_TYPE_DISCRETE = "Discrete";
    public static final String DIST_TYPE_NORMAL = "Normal";
    public static final String DIST_TYPE_UNIFORM = "Uniform";
    public static final String DIST_TYPE_TRIANGULAR = "Triangular";
    public static final String DIST_TYPE_LOG_NORMAL = "Log Normal";
    public static final String DIST_TYPE_LOG_NORMAL_10 = "Log Normal 10";
    public static final String DIST_TYPE_GAMMA = "Gamma";
    public static final String DIST_TYPE_EMPIRICAL = "Empirical";
    public static final String STATE_ACTIVE = "Active";
    public static final String STATE_INACTIVE = "Inactive";
    private static final String[] a = new String[]{" Active", " Type", " Location", " Parameter", "Distribution", "Reference", "Seasonality", "Group", "Edit"};
    private final MonteCarloPanel _parentMCPanel;
    private JButton _add;
    private JButton _remove;
    private JButton _editButtons;
    private RmaJTable _inputTable;
    private JCheckBox _isActiveCheckbox;
    private RssAlt _alt;
    private List<MCInputVariableImpl> _variableList = new ArrayList<MCInputVariableImpl>();
    private RmaJComboBox<String> _activityComboBox;
    private RmaJComboBox<String> _variableTypeComboBox;
    private RmaJComboBox<String> _locationComboBox;
    private RmaJComboBox<String> _parameterComboBox;
    private RmaJComboBox<String> _referenceComboBox;
    private RmaJComboBox<String> _seasonalityComboBox;
    private ItemListener _il;
    boolean comboInitFlag;
    boolean tableEditFlag = false;
    private RmaJTextArea _warningText;
    private JButton _correlation;
    private JButton _checkDependencies;
    private List<MCVariableWizardDialog> _listenerList = new ArrayList<MCVariableWizardDialog>();
    List<ReservoirJFrame> _reservoirEditor = new ArrayList<ReservoirJFrame>();
    List<JunctionDialog> _junctionDialog = new ArrayList<JunctionDialog>();
    private List<Window> _editorListener = new ArrayList<Window>();
    private MCVariableWizardDialog _wizardDlg;
    private boolean _wizardDlgWasVisible;
    private MCVariableWizardDialog _editWizardDlg;
    private int _editWizardRow = -1;
    private boolean _editWizardDlgWasVisible;
    private MCInputPanel$MCVariableTableModel _inputTableModel;
    private boolean _firstTimeModified;
    private CollapsableJPanel _filterCpanel;

    public MCInputPanel(MonteCarloPanel monteCarloPanel) {
        super((LayoutManager)new GridBagLayout());
        this._parentMCPanel = monteCarloPanel;
        this.buildControls();
        this.addActionListeners();
    }

    private void buildControls() {
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS5505;
        Object object = new RmaJPanel((LayoutManager)new GridBagLayout());
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0000;
        this.add((Component)object, serializable);
        this._add = new JButton("Add");
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        object.add((Component)this._add, (Object)serializable);
        this._remove = new JButton("Remove");
        this._remove.setEnabled(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        object.add((Component)this._remove, (Object)serializable);
        object = this.buildFilterPanel();
        this._filterCpanel = new CollapsableJPanel("Filters ", (JPanel)object);
        this._filterCpanel.setCollapsed(true);
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS0000;
        MCInputPanel mCInputPanel = this;
        mCInputPanel.add((Component)mCInputPanel._filterCpanel, serializable);
        object = new JSplitPane(0);
        ((JSplitPane)object).setResizeWeight(0.75);
        ((JComponent)object).setBorder(new EtchedBorder());
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        this.add((Component)object, serializable);
        MCInputPanel mCInputPanel2 = this;
        this._inputTable = new MCInputPanel$1(mCInputPanel2, (Component)((Object)mCInputPanel2), a);
        this._inputTableModel = new MCInputPanel$MCVariableTableModel(this);
        this._inputTable.setModel((TableModel)((Object)this._inputTableModel));
        this._isActiveCheckbox = this._inputTable.setCheckBoxCellEditor(0);
        this._inputTable.getColumnModel().getColumn(0).setPreferredWidth(45);
        this._editButtons = this._inputTable.setButtonCellEditor(8);
        this._inputTable.setCellSelectionEnabled(false);
        this._inputTable.setRowSelectionAllowed(true);
        this._inputTable.setColumnEnabled(false, 1);
        this._inputTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this._inputTable.setColumnEnabled(false, 2);
        this._inputTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this._inputTable.setColumnEnabled(false, 3);
        this._inputTable.setColumnEnabled(false, 4);
        this._inputTable.setColumnEnabled(false, 5);
        this._inputTable.getColumnModel().getColumn(5).setPreferredWidth(70);
        this._inputTable.setColumnEnabled(false, 6);
        this._inputTable.setColumnEnabled(false, 7);
        this._inputTable.getColumnModel().getColumn(8).setPreferredWidth(55);
        this._inputTable.getSelectionModel().setSelectionMode(1);
        serializable = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        serializable.add(this._inputTable.getScrollPane(), gridBagConstraints);
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        serializable.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this._correlation = new JButton("Correlation");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._correlation, (Object)gridBagConstraints);
        this._checkDependencies = new JButton("Check Dependencies");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._checkDependencies, (Object)gridBagConstraints);
        ((JSplitPane)object).setTopComponent((Component)serializable);
        this._warningText = new RmaJTextArea();
        this._warningText.setEditable(false);
        this._warningText.setEnabled(false);
        this._warningText.setForeground(Color.RED);
        serializable = new JScrollPane((Component)this._warningText, 20, 30);
        ((JComponent)serializable).setPreferredSize(new Dimension(10, 30));
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Input Variable Warnings"));
        ((JSplitPane)object).setBottomComponent((Component)serializable);
        EventQueue.invokeLater(() -> MCInputPanel.a((JSplitPane)object));
    }

    private String getWarnings() {
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        for (int i = 0; i < this._variableList.size(); ++i) {
            this._variableList.get(i).checkErrors(stringArray2);
            this._variableList.get(i).checkWarnings(stringArray2, this._alt);
        }
        this.checkCircularDependency(stringArray2);
        this.allDependeciesAreActive(stringArray2);
        this.checkCorrelations(stringArray2);
        if (stringArray2[0].isEmpty()) {
            stringArray2[0] = "No warnings to report";
        }
        return stringArray2[0];
    }

    private void checkCorrelations(String[] stringArray) {
        if (this._alt == null) {
            return;
        }
        if (this._alt.getAltPluginData(AltPluginDataFactory.MC) == null) {
            return;
        }
        Map<String, CorrelationMatrix> map = ((MCAltPluginData)this._alt.getAltPluginData(AltPluginDataFactory.MC)).getCorrelationMap();
        block0: for (String string : map.keySet()) {
            for (String string2 : map.get(string).getKeys()) {
                boolean bl = false;
                for (MCInputVariableImpl mCInputVariableImpl : this._variableList) {
                    if (!string2.equals(mCInputVariableImpl.getShortName()) || !mCInputVariableImpl.isActive()) continue;
                    bl = true;
                }
                if (bl) continue;
                stringArray[0] = stringArray[0].concat("WARNING: Correlation set " + string + " contains variables that are do not exist or are inactive" + System.getProperty("line.separator"));
                continue block0;
            }
        }
        for (String string : map.keySet()) {
            if (map.get(string).isValid()) continue;
            stringArray[0] = stringArray[0].concat("Correlation matrix for \"" + string + "\" is not positive semi-definite. Matrix must be positive semi-definite to generate correlated random variables." + System.lineSeparator());
        }
    }

    private void allDependeciesAreActive(String[] stringArray) {
        for (MCInputVariableImpl mCInputVariableImpl : this._variableList) {
            Map<Integer, String> map = mCInputVariableImpl.getInputVariableNames();
            for (Integer n : map.keySet()) {
                boolean bl = false;
                for (MCInputVariableImpl mCInputVariableImpl2 : this._variableList) {
                    if (!map.get(n).equals(mCInputVariableImpl2.getShortName()) || !mCInputVariableImpl2.isActive()) continue;
                    bl = true;
                }
                if (bl) continue;
                stringArray[0] = stringArray[0].concat("ERROR: " + mCInputVariableImpl.getShortName() + " depends on " + map.get(n) + " but the variable is inactive or does not exist." + System.lineSeparator());
            }
        }
    }

    private void checkCircularDependency(String[] stringArray) {
        DependencyMatrix dependencyMatrix = this.getDepencyMatrix();
        if (dependencyMatrix.containsCircularDependency()) {
            stringArray[0] = stringArray[0].concat("ERROR: Defined variables contain at least one circular dependency. Check the dependency diagram to diagnose the problem.");
        }
    }

    public DependencyMatrix getDepencyMatrix() {
        DependencyMatrix dependencyMatrix = new DependencyMatrix();
        for (MCInputVariableImpl mCInputVariableImpl : this._variableList) {
            Map<Integer, String> map = mCInputVariableImpl.getInputVariableNames();
            for (Integer n : map.keySet()) {
                dependencyMatrix.addEntry(mCInputVariableImpl.getShortName(), map.get(n));
            }
        }
        dependencyMatrix.orderComponents();
        return dependencyMatrix;
    }

    private RmaJPanel buildFilterPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS5505;
        gridBagConstraints.gridheight = 1;
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder("Filter"));
        JLabel jLabel = new JLabel("Active: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._activityComboBox = new RmaJComboBox((Object[])new String[]{"", STATE_ACTIVE, STATE_INACTIVE});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._activityComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Variable Type: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._variableTypeComboBox = new RmaJComboBox((Object[])new String[]{"", VAR_TYPE_LOOKBACK, VAR_TYPE_TIMESERIES, VAR_TYPE_RATING_CURVE, VAR_TYPE_TS_MULTIPLIER, VAR_TYPE_RULE_PARAM});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._variableTypeComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Location: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._locationComboBox = new RmaJComboBox((Object[])new String[]{""});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._locationComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Parameter: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._parameterComboBox = new RmaJComboBox((Object[])new String[]{""});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._parameterComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Reference: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._referenceComboBox = new RmaJComboBox((Object[])new String[]{"", REFERENCE_ABSOLUTE, REFERENCE_RELATIVE});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._referenceComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Seasonality: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._seasonalityComboBox = new RmaJComboBox((Object[])new String[]{"", SEASONALITY_CONSTANT, SEASONALITY_SEASONAL});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._seasonalityComboBox, (Object)gridBagConstraints);
        this._il = new MCInputPanel$2(this);
        this._activityComboBox.addItemListener(this._il);
        this._variableTypeComboBox.addItemListener(this._il);
        this._parameterComboBox.addItemListener(this._il);
        this._locationComboBox.addItemListener(this._il);
        this._referenceComboBox.addItemListener(this._il);
        this._seasonalityComboBox.addItemListener(this._il);
        return rmaJPanel;
    }

    public void clear() {
        this._inputTableModel.setMCVariables(new ArrayList<MCInputVariable>());
        this._variableList = new ArrayList<MCInputVariableImpl>();
        this._warningText.setText("");
    }

    public void isActiveCheckboxAction() {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setActive(this._isActiveCheckbox.isSelected());
    }

    private void addActionListeners() {
        this._add.addActionListener(new MCInputPanel$3(this));
        this._remove.addActionListener(new MCInputPanel$4(this));
        this._correlation.addActionListener(new MCInputPanel$5(this));
        this._checkDependencies.addActionListener(new MCInputPanel$6(this));
        this._editButtons.addActionListener(new MCInputPanel$7(this));
        this._isActiveCheckbox.addActionListener(new MCInputPanel$8(this));
        this._inputTable.getModel().addTableModelListener(new MCInputPanel$9(this));
        this._inputTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.tableRowSelected());
        Window[] windowArray = Frame.getWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            this.addVariableChangeListener(windowArray[i]);
        }
    }

    private void tableRowSelected() {
        int n = this._inputTable.getSelectedRow();
        this._remove.setEnabled(n >= 0);
    }

    private void addVariableChangeListener(Window window) {
        if (window != null) {
            window.addWindowListener(new MCInputPanel$10(this));
        }
    }

    private void editParameterComboBox() {
        if (this._inputTable.getModel().getRowCount() == 0) {
            return;
        }
        String string = (String)this._parameterComboBox.getSelectedItem();
        this._parameterComboBox.removeAllItems();
        this._parameterComboBox.addItem((Object)"");
        for (int i = 0; i < this._inputTable.getColumnCount(); ++i) {
            if (!this._inputTable.getModel().getColumnName(i).equals(" Parameter")) continue;
            for (int j = 0; j < this._inputTable.getRowCount(); ++j) {
                String string2;
                String string3 = (String)this._inputTable.getModel().getValueAt(j, i);
                int n = this._parameterComboBox.getModel().getSize();
                for (int k = 0; k < n && (!string3.equals(string2 = (String)this._parameterComboBox.getModel().getElementAt(k)) || string3.isEmpty()); ++k) {
                    int n2;
                    if (k != n - 1 || string3.isEmpty()) continue;
                    int n3 = this._parameterComboBox.getItemCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((String)this._parameterComboBox.getItemAt(n2)).compareTo(string3) <= 0) continue;
                        this._parameterComboBox.insertItemAt((Object)string3, n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    this._parameterComboBox.insertItemAt((Object)string3, n2);
                }
            }
        }
        this._parameterComboBox.setSelectedItem((Object)string);
    }

    private void editLocationComboBox() {
        String string = (String)this._locationComboBox.getSelectedItem();
        this._locationComboBox.removeAllItems();
        this._locationComboBox.addItem((Object)"");
        for (int i = 0; i < this._inputTable.getColumnCount(); ++i) {
            if (!this._inputTable.getModel().getColumnName(i).equals(" Location")) continue;
            for (int j = 0; j < this._inputTable.getRowCount(); ++j) {
                String string2;
                String string3 = (String)this._inputTable.getModel().getValueAt(j, i);
                int n = this._locationComboBox.getModel().getSize();
                for (int k = 0; k < n && (!string3.equals(string2 = (String)this._locationComboBox.getModel().getElementAt(k)) || string3.isEmpty()); ++k) {
                    int n2;
                    if (k != n - 1 || string3.isEmpty()) continue;
                    int n3 = this._locationComboBox.getItemCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((String)this._locationComboBox.getItemAt(n2)).compareTo(string3) <= 0) continue;
                        this._locationComboBox.insertItemAt((Object)string3, n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    this._locationComboBox.insertItemAt((Object)string3, n2);
                }
            }
        }
        this._locationComboBox.setSelectedItem((Object)string);
    }

    private void filterTable(Object object) {
        Object object2;
        this.tableEditFlag = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (object.equals(this._activityComboBox)) {
            object2 = this._activityComboBox.getSelectedItem();
            if (object2 != null) {
                string = object2.toString();
            }
            string2 = (String)this._variableTypeComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._locationComboBox.getSelectedItem();
            string5 = (String)this._referenceComboBox.getSelectedItem();
            string6 = (String)this._seasonalityComboBox.getSelectedItem();
        }
        if (object.equals(this._variableTypeComboBox)) {
            object2 = this._variableTypeComboBox.getSelectedItem();
            if (object2 != null) {
                string2 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._locationComboBox.getSelectedItem();
            string5 = (String)this._referenceComboBox.getSelectedItem();
            string6 = (String)this._seasonalityComboBox.getSelectedItem();
        }
        if (object.equals(this._parameterComboBox)) {
            object2 = this._parameterComboBox.getSelectedItem();
            if (object2 != null) {
                string3 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._variableTypeComboBox.getSelectedItem();
            string4 = (String)this._locationComboBox.getSelectedItem();
            string5 = (String)this._referenceComboBox.getSelectedItem();
            string6 = (String)this._seasonalityComboBox.getSelectedItem();
        }
        if (object.equals(this._locationComboBox)) {
            object2 = this._locationComboBox.getSelectedItem();
            if (object2 != null) {
                string4 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._variableTypeComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string5 = (String)this._referenceComboBox.getSelectedItem();
            string6 = (String)this._seasonalityComboBox.getSelectedItem();
        }
        if (object.equals(this._referenceComboBox)) {
            object2 = this._referenceComboBox.getSelectedItem();
            if (object2 != null) {
                string5 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._variableTypeComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._locationComboBox.getSelectedItem();
            string6 = (String)this._seasonalityComboBox.getSelectedItem();
        }
        if (object.equals(this._seasonalityComboBox)) {
            object2 = this._seasonalityComboBox.getSelectedItem();
            if (object2 != null) {
                string6 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._variableTypeComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._locationComboBox.getSelectedItem();
            string5 = (String)this._referenceComboBox.getSelectedItem();
        }
        this.fillForm(string, string2, string3, string4, string5, string6);
        this.tableEditFlag = false;
    }

    private void fillForm(String string, String string2, String string3, String string4, String string5, String string6) {
        int n = this._variableList.size();
        ArrayList<MCInputVariable> arrayList = new ArrayList<MCInputVariable>();
        for (int i = 0; i < n; ++i) {
            MCInputVariable mCInputVariable = this._variableList.get(i);
            if (!this.passesFilter(mCInputVariable.isActive(), string) || !this.passesFilter(mCInputVariable.getType(), string2) || !this.passesFilter(mCInputVariable.getParameter(), string3) || !this.passesFilter(mCInputVariable.getLocation(), string4) || (!(mCInputVariable instanceof MCInputStochasticVariableImpl) || !this.passesFilter(((MCInputStochasticVariableImpl)mCInputVariable).isRelative(), string5)) && !(mCInputVariable instanceof MCInputScriptVariable) || (!(mCInputVariable instanceof MCInputStochasticVariableImpl) || !this.passesFilter(((MCInputStochasticVariableImpl)mCInputVariable).isSeasonal(), string6)) && !(mCInputVariable instanceof MCInputScriptVariable)) continue;
            arrayList.add(mCInputVariable);
        }
        this._inputTableModel.setMCVariables(arrayList);
        this.checkAllWarnings();
    }

    private boolean passesFilter(Boolean bl, String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        return !(bl == false ? STATE_ACTIVE.equals(string) || string.equals(REFERENCE_RELATIVE) || string.equals(SEASONALITY_SEASONAL) : !STATE_ACTIVE.equals(string) && !string.equals(REFERENCE_RELATIVE) && !string.equals(SEASONALITY_SEASONAL));
    }

    private boolean passesFilter(int n, String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (n < 0) {
            return false;
        }
        return n == 0 && string.equals(VAR_TYPE_TIMESERIES) || 1 == n && string.equals(VAR_TYPE_RULE_PARAM) || 2 == n && string.equals(VAR_TYPE_LOOKBACK) || 3 == n && string.equals(VAR_TYPE_RATING_CURVE) || 4 == n && string.equals(VAR_TYPE_TS_MULTIPLIER);
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public void addButtonAction() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof AlternativeEditor) {
            window = (AlternativeEditor)window;
            if (this._editWizardDlg != null && this._editWizardDlg.isVisible()) {
                JOptionPane.showMessageDialog(window, "There is already a Random Variable Editor opened.  Please close the open editor before Adding a Variable", "Multiple Editors", 1);
                return;
            }
            if (this._wizardDlg != null && this._wizardDlg.isVisible()) {
                this._wizardDlg.toFront();
                return;
            }
            this._wizardDlg = new MCVariableWizardDialog((Dialog)window, false, this);
            this._wizardDlg.setSize(800, 700);
            this._wizardDlg.fillPanels(this._alt, null);
            this._wizardDlg.setVisible(true);
        }
    }

    public void correlationButtonAction() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof AlternativeEditor) {
            object = (AlternativeEditor)object;
            object = new CorrelationMatrixDialog((Dialog)object, this, "Correlation Matrix", this._alt);
            object.setSize(1000, 500);
            object.setVisible(true);
            this._inputTable.setModified(true);
        }
    }

    public void checkDependenciesButtonAction() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (object instanceof AlternativeEditor) {
            object = (AlternativeEditor)object;
            if (!this.getDepencyMatrix().getAllEntries().isEmpty()) {
                object = new DependencyGraphDialog((Dialog)object, this);
                object.setSize(1500, 750);
                object.setVisible(true);
                return;
            }
            JOptionPane.showMessageDialog(object, "No dependent variables have been defined. Cannot draw dependency diagram.", "Error!", 0);
        }
    }

    public int getSelectedRow() {
        return this._inputTable.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this._inputTable.getSelectedRows();
    }

    public void addVariable(int n, MCInputStochasticVariableImpl mCInputStochasticVariableImpl) {
        if (n == -1) {
            Object object;
            n = this._inputTable.getRowCount() == 1 ? ((object = this._inputTable.getValueAt(0, 1)) == null ? 0 : (object instanceof String ? (((String)object).isEmpty() || ((String)object).equals(" ") ? 0 : this._inputTable.getRowCount()) : this._inputTable.getRowCount())) : this._inputTable.getRowCount();
        }
        this.addVariableToListandTable(n, mCInputStochasticVariableImpl);
        this.checkAllWarnings();
    }

    private void addVariableToListandTable(int n, MCInputVariableImpl mCInputVariableImpl) {
        if (this._variableList.size() != n && (this._variableList.size() > n || this._variableList.get(n) != null)) {
            this._variableList.set(n, mCInputVariableImpl);
            this._inputTableModel.setVariable(mCInputVariableImpl, n);
            return;
        }
        this._variableList.add(n, mCInputVariableImpl);
        this._inputTableModel.addVariable(mCInputVariableImpl, n);
    }

    private Object getDistributionName(MCInputStochasticVariableImpl mCInputStochasticVariableImpl) {
        if (mCInputStochasticVariableImpl.getDistributionType() == 0) {
            return DIST_TYPE_DISCRETE;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 1) {
            return DIST_TYPE_NORMAL;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 2) {
            return DIST_TYPE_UNIFORM;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 3) {
            return DIST_TYPE_TRIANGULAR;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 4) {
            return DIST_TYPE_LOG_NORMAL;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 7) {
            return DIST_TYPE_LOG_NORMAL_10;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 5) {
            return DIST_TYPE_GAMMA;
        }
        if (mCInputStochasticVariableImpl.getDistributionType() == 6) {
            if (mCInputStochasticVariableImpl.getDist() instanceof SeasonalContinuousDistribution) {
                if (((EmpiricalDist)((SeasonalContinuousDistribution)mCInputStochasticVariableImpl.getDist()).getDist()).getInterpType() == EmpiricalDist.InterpType.STEP) {
                    return DIST_TYPE_DISCRETE;
                }
                return DIST_TYPE_EMPIRICAL;
            }
            if (((EmpiricalDist)mCInputStochasticVariableImpl.getDist()).getInterpType() == EmpiricalDist.InterpType.STEP) {
                return DIST_TYPE_DISCRETE;
            }
            return DIST_TYPE_EMPIRICAL;
        }
        return "";
    }

    public void addVariable(int n, MCInputScriptVariable mCInputScriptVariable) {
        if (n == -1) {
            Object object;
            n = this._inputTable.getRowCount() == 1 ? ((object = this._inputTable.getValueAt(0, 1)) == null ? 0 : (object instanceof String ? (((String)object).isEmpty() || ((String)object).equals(" ") ? 0 : this._inputTable.getRowCount()) : this._inputTable.getRowCount())) : this._inputTable.getRowCount();
        }
        this.addVariableToListandTable(n, mCInputScriptVariable);
        this.checkAllWarnings();
    }

    public static int getVariableType(String string) {
        if (string.equals(VAR_TYPE_TIMESERIES)) {
            return 0;
        }
        if (string.equals(VAR_TYPE_RULE_PARAM)) {
            return 1;
        }
        if (string.equals(VAR_TYPE_RATING_CURVE)) {
            return 3;
        }
        if (string.equals(VAR_TYPE_TS_MULTIPLIER)) {
            return 4;
        }
        if (string.equals(VAR_TYPE_LOOKBACK)) {
            return 2;
        }
        return 5;
    }

    public void removeButtonAction() {
        int[] nArray = this._inputTable.getSelectedRows();
        if (this._editWizardDlg != null && this._editWizardDlg.isVisible()) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Please close the Variable Editor before removing a Variable", "Warning", 1);
            return;
        }
        int n = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "OK to remove the selected Input Variables?", "Confirm Removal", 0);
        if (n != 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] == -1) {
                return;
            }
            MCInputVariable mCInputVariable = this._inputTableModel.deleteVariable(nArray[i]);
            if (mCInputVariable == null || !this._variableList.remove(mCInputVariable)) continue;
            this.setModified(true);
        }
        this.checkAllWarnings();
    }

    public void deleteVariable(int n) {
        this._inputTable.setSelectedIndices(new int[]{n});
        MCInputVariable mCInputVariable = this._inputTableModel.deleteVariable(n);
        if (mCInputVariable != null) {
            this._variableList.remove(mCInputVariable);
        }
    }

    public void editButtonAction() {
        Window window;
        int n = this._inputTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        ArrayList<MCInputVariable> arrayList = new ArrayList<MCInputVariable>();
        if (this._variableList.get(n).getGroupNumber() > 0) {
            for (int i = 0; i < this._variableList.size(); ++i) {
                if (this._variableList.get(i).getGroupNumber() != this._variableList.get(n).getGroupNumber()) continue;
                arrayList.add(this._variableList.get(i));
            }
        } else {
            arrayList.add(this._variableList.get(n));
        }
        MCInputVariableImpl[] mCInputVariableImplArray = new MCInputVariableImpl[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            mCInputVariableImplArray[i] = (MCInputVariableImpl)arrayList.get(i);
        }
        if ((this._variableList != null || this._variableList.get(n) != null) && this.checkInputConsistency() && (window = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof AlternativeEditor) {
            if (this._editWizardDlg != null && this._editWizardDlg.isVisible() && this._editWizardRow != n) {
                JOptionPane.showMessageDialog(window, "There is already a row being edited.  Please close the open editor before editing a different row", "Multiple Editors", 1);
                return;
            }
            this._editWizardRow = n;
            AlternativeEditor alternativeEditor = (AlternativeEditor)window;
            if (this._wizardDlg != null && this._wizardDlg.isVisible()) {
                JOptionPane.showMessageDialog(window, "There is already a Random Variable Editor opened.  Please close the open editor before editing a row", "Multiple Editors", 1);
                return;
            }
            if (this._editWizardDlg != null && this._editWizardDlg.isVisible()) {
                this._editWizardDlg.toFront();
                return;
            }
            this._editWizardDlg = new MCVariableWizardDialog((Dialog)alternativeEditor, false, this);
            this._editWizardDlg.setSize(800, 700);
            this._editWizardDlg.fillPanels(this._alt, mCInputVariableImplArray);
            this._editWizardDlg.setVisible(true);
        }
    }

    private boolean checkInputConsistency() {
        int n;
        int n2;
        int[] nArray = this._inputTable.getSelectedRows();
        if (nArray.length == 1) {
            return true;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!(this._variableList.get(nArray[n2]) instanceof MCInputStochasticVariableImpl)) {
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables are group editable. Please select consistent relative variables when group editing.", "Editor Warning", 2);
                return false;
            }
            if (((MCInputStochasticVariableImpl)this._variableList.get(nArray[n2])).isRelative()) continue;
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables are of relative reference. Please select consistent relative variables when group editing.", "Editor Warning", 2);
            return false;
        }
        n2 = this._variableList.get(nArray[0]).getType();
        for (n = 1; n < nArray.length; ++n) {
            if (this._variableList.get(nArray[n]).getType() == n2) continue;
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables of the same type. Please select consistent relative variables when group editing.", "Editor Warning", 2);
            return false;
        }
        n2 = ((MCInputStochasticVariableImpl)this._variableList.get(nArray[0])).getDistributionType();
        for (n = 1; n < nArray.length; ++n) {
            if (((MCInputStochasticVariableImpl)this._variableList.get(nArray[n])).getDistributionType() == n2) continue;
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables have the same distribution type. Please select consistent relative variables when group editing.", "Editor Warning", 2);
            return false;
        }
        if (((MCInputStochasticVariableImpl)this._variableList.get(nArray[0])).getDist() instanceof SeasonalContinuousDistribution) {
            List<HecTime> list = ((SeasonalContinuousDistribution)((MCInputStochasticVariableImpl)this._variableList.get(nArray[0])).getDist()).getHecTimes();
            for (HecTime hecTime : list) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    ((SeasonalContinuousDistribution)((MCInputStochasticVariableImpl)this._variableList.get(nArray[n2])).getDist()).setTime(hecTime);
                }
                double[] dArray = ((MCInputStochasticVariableImpl)this._variableList.get(nArray[0])).getDist().getParamVals();
                for (int i = 1; i < nArray.length; ++i) {
                    for (int j = 0; j < dArray.length; ++j) {
                        double d;
                        double d2 = Math.abs(((MCInputStochasticVariableImpl)this._variableList.get(nArray[i])).getDist().getParamVals()[j] - dArray[j]);
                        if (!(d >= 0.001)) continue;
                        JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables have the same distribution parameters. Please select consistent relative variables when group editing.", "Editor Warning", 2);
                        return false;
                    }
                }
            }
        }
        double[] dArray = ((MCInputStochasticVariableImpl)this._variableList.get(nArray[0])).getDist().getParamVals();
        for (n2 = 1; n2 < nArray.length; ++n2) {
            for (int i = 0; i < dArray.length; ++i) {
                double d;
                double d3 = Math.abs(((MCInputStochasticVariableImpl)this._variableList.get(nArray[n2])).getDist().getParamVals()[i] - dArray[i]);
                if (!(d >= 0.001)) continue;
                JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)((Object)this)), "Multiple variables have been selected, but not all selected variables have the same distribution parameters. Please select consistent relative variables when group editing.", "Editor Warning", 2);
                return false;
            }
        }
        return true;
    }

    public void fillPanel(MCAltPluginData object, RssAlt rssAlt) {
        this.clear();
        if (this._alt != rssAlt) {
            this._wizardDlgWasVisible = false;
            this._wizardDlg = null;
            this._editWizardDlgWasVisible = false;
            this._editWizardDlg = null;
            this._firstTimeModified = true;
        }
        this._alt = rssAlt;
        if (object == null) {
            return;
        }
        this._variableList = object.getInputVariables();
        object = new ArrayList<MCInputVariableImpl>();
        object.addAll(this._variableList);
        this._inputTableModel.setMCVariables((List<MCInputVariable>)object);
        this.checkAllWarnings();
    }

    public void savePanel(MCAltPluginData mCAltPluginData) {
        this._inputTable.commitEdit(true);
        if (mCAltPluginData == null) {
            mCAltPluginData = new MCAltPluginData();
        }
        mCAltPluginData.setInputVaribales(this._variableList);
        MCAltPluginData mCAltPluginData2 = (MCAltPluginData)this._alt.getAltPluginData("Monte Carlo");
        if (mCAltPluginData2 != null) {
            mCAltPluginData.setCorrelationMap(mCAltPluginData2.copyCorrelationMap());
        }
        this.setModified(false);
    }

    public List<MCInputStochasticVariableImpl> getStochasticInputVariableList() {
        ArrayList<MCInputStochasticVariableImpl> arrayList = new ArrayList<MCInputStochasticVariableImpl>();
        for (MCInputVariableImpl mCInputVariableImpl : this._variableList) {
            if (!(mCInputVariableImpl instanceof MCInputStochasticVariableImpl)) continue;
            arrayList.add((MCInputStochasticVariableImpl)mCInputVariableImpl.clone());
        }
        return arrayList;
    }

    public List<MCInputVariableImpl> getInputVariableList() {
        return this._variableList;
    }

    public TableModel getTableModel() {
        return this._inputTable.getModel();
    }

    public int[] getGroupRows(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this._inputTable.getRowCount(); ++i) {
            if (this._inputTable.getValueAt(i, 7).equals("None") || (double)((Integer)this._inputTable.getValueAt(i, 7)).intValue() != (double)n) continue;
            arrayList.add(i);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this._inputTable.getSelectedRow());
        }
        int[] nArray = new int[arrayList.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)arrayList.get(n);
        }
        return nArray;
    }

    public void checkAllWarnings() {
        this._warningText.setText(this.getWarnings());
        this._warningText.setCaretPosition(0);
        this._warningText.repaint();
        this._warningText.revalidate();
        if (!this._listenerList.isEmpty()) {
            for (MCVariableWizardDialog mCVariableWizardDialog : this._listenerList) {
                mCVariableWizardDialog.refreshWarnings();
            }
        }
    }

    public void addWarningCheckListener(MCVariableWizardDialog mCVariableWizardDialog) {
        this._listenerList.add(mCVariableWizardDialog);
    }

    public void removeWarningCheckListener(MCVariableWizardDialog mCVariableWizardDialog) {
        this._listenerList.remove((Object)mCVariableWizardDialog);
    }

    public void setAlt(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    protected RssAlt getAlt() {
        return this._alt;
    }

    @Override
    public void switchedFrom() {
        if (this._editWizardDlg != null && this._editWizardDlg.isVisible()) {
            this._editWizardDlg.setVisible(false);
            this._editWizardDlgWasVisible = true;
        } else {
            this._editWizardDlgWasVisible = false;
        }
        if (this._wizardDlg != null && this._wizardDlg.isVisible()) {
            this._wizardDlg.setVisible(false);
            this._wizardDlgWasVisible = true;
            return;
        }
        this._wizardDlgWasVisible = false;
    }

    @Override
    public void switchedTo() {
        if (this._wizardDlgWasVisible && this._wizardDlg != null) {
            this._wizardDlg.setVisible(true);
            return;
        }
        if (this._editWizardDlgWasVisible && this._editWizardDlg != null) {
            this._editWizardDlg.setVisible(true);
        }
    }

    private String getVariableTypeString(int n) {
        switch (n) {
            case 0: {
                return VAR_TYPE_TIMESERIES;
            }
            case 1: {
                return VAR_TYPE_RULE_PARAM;
            }
            case 3: {
                return VAR_TYPE_RATING_CURVE;
            }
            case 2: {
                return VAR_TYPE_LOOKBACK;
            }
            case 4: {
                return VAR_TYPE_TS_MULTIPLIER;
            }
        }
        return VAR_TYPE_SCRIPT;
    }

    public void setModified(boolean bl) {
        if (bl && this._firstTimeModified) {
            EventQueue.invokeLater(() -> this._parentMCPanel.tellUserClearSelected("Input"));
            this._firstTimeModified = false;
        }
        super.setModified(bl);
    }

    private static /* synthetic */ void a(JSplitPane jSplitPane) {
        jSplitPane.setDividerLocation(0.3);
    }
}

