/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.lang.NamedType;
import hec.model.ModelVariable;
import hec.rss.model.HindcastData;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.plugins.montecarlo.client.MCInputPanel;
import hec.rss.plugins.montecarlo.client.MCLookbackLocationWizardPanel$1;
import hec.rss.plugins.montecarlo.client.MCLookbackLocationWizardPanel$2;
import hec.rss.plugins.montecarlo.client.MCVariableLocationWizardPanelImpl;
import hec.rss.plugins.montecarlo.client.MCVariableWizardDialog;
import hec.rss.plugins.montecarlo.model.MCInputLookbackVariable;
import hec.rss.plugins.montecarlo.model.MCInputStochasticVariableImpl;
import hec.rss.plugins.montecarlo.model.MCInputVariable;
import hec.rss.plugins.montecarlo.model.MCInputVariableImpl;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MCLookbackLocationWizardPanel
extends MCVariableLocationWizardPanelImpl {
    public static final String PANEL_NAME = "Lookback Location and Parameter";
    int _paramID;
    private Vector _paramIDS;
    private RssAlt _alt;

    public MCLookbackLocationWizardPanel(MCInputPanel mCInputPanel, MCVariableWizardDialog mCVariableWizardDialog) {
        super(mCInputPanel, mCVariableWizardDialog);
        this.buildPanel();
    }

    private void buildPanel() {
        MCLookbackLocationWizardPanel mCLookbackLocationWizardPanel = this;
        super.buildPanel(mCLookbackLocationWizardPanel, "Lookback Values", new String[]{"Location", "Variable", "Default Value"});
        this._variableTable.getSelectionModel().addListSelectionListener(new MCLookbackLocationWizardPanel$1(this));
    }

    @Override
    protected void addListeners() {
        this._variableTable.addMouseListener((MouseListener)new MCLookbackLocationWizardPanel$2(this));
    }

    public String[] getSelectedTimeSeries() {
        int n = this._variableTable.getSelectedRow();
        String[] stringArray = new String[2];
        if (this._variableTable.getValueAt(n, 0) != null && this._variableTable.getValueAt(n, 0) instanceof String) {
            stringArray[0] = (String)this._variableTable.getValueAt(n, 0);
        }
        if (this._variableTable.getValueAt(n, 1) != null && this._variableTable.getValueAt(n, 1) instanceof String) {
            stringArray[1] = (String)this._variableTable.getValueAt(n, 1);
        }
        if (this._variableTable.getValueAt(n, 2) != null && this._variableTable.getValueAt(n, 2) instanceof String) {
            stringArray[1] = stringArray[1] + "=" + (String)this._variableTable.getValueAt(n, 2);
        }
        return stringArray;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void fillPanel(NamedType namedType) {
    }

    public int getParamID() {
        return this._paramID;
    }

    @Override
    public boolean fillCurrentPanel(RssAlt object, MCInputVariableImpl[] mCInputVariableImplArray) {
        int n;
        this._alt = object;
        RssSystem rssSystem = object.getSystem();
        this._paramIDS = new Vector();
        if (rssSystem == null) {
            return true;
        }
        if (object.getHindcastData() == null) {
            return true;
        }
        if (mCInputVariableImplArray == null) {
            mCInputVariableImplArray = new MCInputStochasticVariableImpl[1];
        } else {
            this._paramID = mCInputVariableImplArray[0].getParamId();
        }
        this._variableTable.clearSelection();
        this._variableTable.setNumRows(0);
        this._variableTable.deleteCells();
        if (rssSystem == null) {
            return true;
        }
        if ((object = object.getHindcastData()) == null) {
            return true;
        }
        int n2 = ((Vector)object).size();
        for (n = 0; n < n2; ++n) {
            HindcastData hindcastData = (HindcastData)((Vector)object).elementAt(n);
            Object object2 = rssSystem.getNameForKeyString(hindcastData.getObjectKey());
            String string = RssModelVariableSet.getVariableName((int)hindcastData.getVariableId());
            if (hindcastData == null || this.existsInTable(2, rssSystem.getNameForKeyString(hindcastData.getObjectKey()), RssModelVariableSet.getVariableName((int)hindcastData.getVariableId()))) {
                if (mCInputVariableImplArray[0] == null) continue;
                boolean bl = false;
                for (int i = 0; i < mCInputVariableImplArray.length; ++i) {
                    if (!((String)object2).equals(mCInputVariableImplArray[i].getLocation()) || !string.equals(mCInputVariableImplArray[i].getParameter())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (hindcastData.getType() != 1) continue;
            object2 = new Vector<Boolean>();
            ((Vector)object2).addElement(Boolean.FALSE);
            ((Vector)object2).addElement(rssSystem.getNameForKeyString(hindcastData.getObjectKey()));
            ((Vector)object2).addElement(RssModelVariableSet.getVariableName((int)hindcastData.getVariableId()));
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable((int)hindcastData.getVariableId());
            this._paramIDS.add(modelVariable.getParamId());
            ((Vector)object2).addElement(hindcastData.getValueString());
            this._variableTable.appendRow((Vector)object2);
        }
        for (n = 0; n < mCInputVariableImplArray.length; ++n) {
            for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
                if (mCInputVariableImplArray[n] == null || !this._variableTable.getValueAt(i, 1).equals(mCInputVariableImplArray[n].getLocation()) || !this._variableTable.getValueAt(i, 2).equals(mCInputVariableImplArray[n].getParameter())) continue;
                this._variableTable.setSelectedIndices(new int[]{i});
                this._variableTable.setValueAt((Object)Boolean.TRUE, this._variableTable.getSelectedRow(), 0);
            }
        }
        return mCInputVariableImplArray == null || mCInputVariableImplArray[0] == null || !(mCInputVariableImplArray[0] instanceof MCInputLookbackVariable);
    }

    private boolean rowExists(Vector vector) {
        for (int i = 0; i < this._variableTable.getRowCount(); ++i) {
            if (!vector.get(1).equals(this._variableTable.getValueAt(i, 1)) || !vector.get(2).equals(this._variableTable.getValueAt(i, 2))) continue;
            return true;
        }
        return false;
    }

    public void fillEditPanel(MCInputVariable mCInputVariable, String string) {
        if (mCInputVariable.getType() == 2) {
            this._variableNameField.setText(string);
        }
    }

    @Override
    public Double[] getDefaultValue() {
        MCLookbackLocationWizardPanel mCLookbackLocationWizardPanel = this;
        return ((MCVariableLocationWizardPanelImpl)mCLookbackLocationWizardPanel).getDefaultValue(((MCVariableLocationWizardPanelImpl)mCLookbackLocationWizardPanel).getCurrentVariableLocation(), ((MCVariableLocationWizardPanelImpl)this).getCurrentVariableParameter());
    }

    @Override
    public Double[] getDefaultValue(String string, String string2) {
        RssSystem rssSystem = this._alt.getSystem();
        Vector vector = this._alt.getHindcastData();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            HindcastData hindcastData = (HindcastData)vector.elementAt(i);
            if (hindcastData.getType() != 1 || !string.equals(rssSystem.getNameForKeyString(hindcastData.getObjectKey())) || !string2.equals(RssModelVariableSet.getVariableName((int)hindcastData.getVariableId()))) continue;
            return new Double[]{Double.valueOf(hindcastData.getValueString())};
        }
        return null;
    }

    @Override
    public String getCurrentVariableLocation() {
        return (String)this.getCurrentVariableVector().get(1);
    }

    @Override
    public String getCurrentVariableParameter() {
        return (String)this.getCurrentVariableVector().get(2);
    }

    @Override
    public void setSelection() {
        super.setSelection();
        for (int i = 0; i < this._variableTable.getNumRows(); ++i) {
            if (((Boolean)this._variableTable.getValueAt(i, 0)).booleanValue() && this._variableTable.getValueAt(i, 3).equals("")) {
                this._isValid = false;
                this._parent.setValidPanelControlsNextButton(true);
                JOptionPane.showMessageDialog((Component)((Object)this._parent), "Cannot create MC variable from lookback without a default value.\nIn order to create this variable, close the Random Variable Wizard,\nthen specify a value for this variable in the lookback tab.\nOnce a value is specified, you may use the Random Variable Wizard to create this variable.", "Lookback Variable Error", 0);
                return;
            }
            this._isValid = true;
            this._parent.setValidPanelControlsNextButton(true);
        }
    }
}

