/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.montecarlo.client;

import hec.rss.client.AlternativeEditor;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.plugins.montecarlo.client.MCConvergencePanel;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$1;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$10;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$11;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$12;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$2;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$3;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$4;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$5;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$6;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$7;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$8;
import hec.rss.plugins.montecarlo.client.MCOutputPanel$9;
import hec.rss.plugins.montecarlo.client.MCPanel;
import hec.rss.plugins.montecarlo.client.MonteCarloPanel;
import hec.rss.plugins.montecarlo.client.OutputVarWizardDialog;
import hec.rss.plugins.montecarlo.model.MCAltPluginData;
import hec.rss.plugins.montecarlo.model.MCOutputVariable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellEditor;

public class MCOutputPanel
extends RmaJPanel
implements MCPanel {
    public static final String TAB = "Output Variables";
    private JButton _editButtons;
    private JCheckBox _isActiveCheckbox;
    private JButton _add;
    private JButton _remove;
    private RmaJTable _inputTable;
    private JCheckBox _testCheckbox;
    private JCheckBox _convergenceCheckbox;
    private JCheckBox _saveOutputFlagCheckbox;
    private MonteCarloPanel _parent;
    private RssAlt _alt;
    private List<MCOutputVariable> _variableList = new ArrayList<MCOutputVariable>();
    private RmaJComboBox<String> _activityComboBox;
    private RmaJComboBox<String> _locationComboBox;
    private RmaJComboBox<String> _parameterComboBox;
    private RmaJComboBox<String> _statisticComboBox;
    private RmaJComboBox<String> _flagComboBox;
    private RmaJComboBox<String> _convergenceComboBox;
    private ItemListener _il;
    private boolean tableEditFlag = false;
    private boolean comboInitFlag;
    private TableColumn _locationColumn;
    private JComboBox<String> _testComboBox;
    private RmaCellEditor _thresholdField;
    private RmaCellEditor _confidenceField;
    private RmaCellEditor _toleranceField;
    private OutputVarWizardDialog _wizardDlg;
    private boolean _wizardDlgWasVisible;
    private boolean _firstTimeModified;
    private boolean _clearing;

    public MCOutputPanel(MonteCarloPanel monteCarloPanel, MCConvergencePanel mCConvergencePanel) {
        super((LayoutManager)new GridBagLayout());
        this._parent = monteCarloPanel;
        this.buildControls();
        this.addActionListeners();
    }

    private void buildControls() {
        this._add = new JButton("Add");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MCOutputPanel mCOutputPanel = this;
        mCOutputPanel.add(mCOutputPanel._add, gridBagConstraints);
        this._remove = new JButton("Remove");
        this._remove.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MCOutputPanel mCOutputPanel2 = this;
        mCOutputPanel2.add(mCOutputPanel2._remove, gridBagConstraints);
        RmaJPanel rmaJPanel = this.buildFilterPanel();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._inputTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Active", "Location", "Parameter", "Statistic", "Flag", "Test", "Threshold", "Convergence", "Confidence", "Tolerance", "Edit"});
        this._isActiveCheckbox = this._inputTable.setCheckBoxCellEditor(0);
        this._testCheckbox = this._inputTable.setCheckBoxCellEditor(4);
        this._testComboBox = this._inputTable.setComboBoxEditor(5, (Object[])new String[]{"<", ">", "="});
        this._thresholdField = new RmaCellEditor(new RmaJDecimalField());
        this._inputTable.setColumnEditor(6, this._thresholdField);
        this._convergenceCheckbox = this._inputTable.setCheckBoxCellEditor(7);
        this._confidenceField = new RmaCellEditor(new RmaJDecimalField());
        this._inputTable.setColumnEditor(8, this._confidenceField);
        this._toleranceField = new RmaCellEditor(new RmaJDecimalField());
        this._inputTable.setColumnEditor(9, this._toleranceField);
        this._editButtons = this._inputTable.setButtonCellEditor(10);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        MCOutputPanel mCOutputPanel3 = this;
        mCOutputPanel3.add(mCOutputPanel3._inputTable.getScrollPane(), gridBagConstraints);
        this._inputTable.setAutoResizeMode(0);
        this._inputTable.setColumnWidth(0, this._inputTable.getColumnWidthFromData(0));
        this._inputTable.setColumnWidth(4, this._inputTable.getColumnWidthFromData(4));
    }

    private RmaJPanel buildFilterPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().insets = RmaInsets.INSETS5505;
        gridBagConstraints.gridheight = 1;
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder("Filter"));
        JLabel jLabel = new JLabel("Activity: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._activityComboBox = new RmaJComboBox((Object[])new String[]{"", "Active", "Inactive"});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._activityComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Location: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._locationComboBox = new RmaJComboBox((Object[])new String[]{""});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._locationComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Parameter: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._parameterComboBox = new RmaJComboBox((Object[])new String[]{""});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._parameterComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Statistic: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._statisticComboBox = new RmaJComboBox((Object[])new String[]{""});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._statisticComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Flag: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._flagComboBox = new RmaJComboBox((Object[])new String[]{"", "Flagged", "Unflagged"});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._flagComboBox, (Object)gridBagConstraints);
        jLabel = new JLabel("Convergence: ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._convergenceComboBox = new RmaJComboBox((Object[])new String[]{"", "Convergence", "Not Convergence"});
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        rmaJPanel.add(this._convergenceComboBox, (Object)gridBagConstraints);
        this._il = new MCOutputPanel$1(this);
        this._activityComboBox.addItemListener(this._il);
        this._locationComboBox.addItemListener(this._il);
        this._parameterComboBox.addItemListener(this._il);
        this._statisticComboBox.addItemListener(this._il);
        this._flagComboBox.addItemListener(this._il);
        this._convergenceComboBox.addItemListener(this._il);
        return rmaJPanel;
    }

    private void filterTable(Object object) {
        Object object2;
        this.tableEditFlag = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (object.equals(this._activityComboBox)) {
            object2 = this._activityComboBox.getSelectedItem();
            if (object2 != null) {
                string = object2.toString();
            }
            string2 = (String)this._locationComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._statisticComboBox.getSelectedItem();
            string5 = (String)this._flagComboBox.getSelectedItem();
            string6 = (String)this._convergenceComboBox.getSelectedItem();
        }
        if (object.equals(this._locationComboBox)) {
            object2 = this._locationComboBox.getSelectedItem();
            if (object2 != null) {
                string2 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._statisticComboBox.getSelectedItem();
            string5 = (String)this._flagComboBox.getSelectedItem();
            string6 = (String)this._convergenceComboBox.getSelectedItem();
        }
        if (object.equals(this._parameterComboBox)) {
            object2 = this._parameterComboBox.getSelectedItem();
            if (object2 != null) {
                string3 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._locationComboBox.getSelectedItem();
            string4 = (String)this._statisticComboBox.getSelectedItem();
            string5 = (String)this._flagComboBox.getSelectedItem();
            string6 = (String)this._convergenceComboBox.getSelectedItem();
        }
        if (object.equals(this._statisticComboBox)) {
            object2 = this._statisticComboBox.getSelectedItem();
            if (object2 != null) {
                string4 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._locationComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string5 = (String)this._flagComboBox.getSelectedItem();
            string6 = (String)this._convergenceComboBox.getSelectedItem();
        }
        if (object.equals(this._flagComboBox)) {
            object2 = this._flagComboBox.getSelectedItem();
            if (object2 != null) {
                string5 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._locationComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._statisticComboBox.getSelectedItem();
            string6 = (String)this._convergenceComboBox.getSelectedItem();
        }
        if (object.equals(this._convergenceComboBox)) {
            object2 = this._convergenceComboBox.getSelectedItem();
            if (object2 != null) {
                string6 = object2.toString();
            }
            string = (String)this._activityComboBox.getSelectedItem();
            string2 = (String)this._locationComboBox.getSelectedItem();
            string3 = (String)this._parameterComboBox.getSelectedItem();
            string4 = (String)this._statisticComboBox.getSelectedItem();
            string5 = (String)this._flagComboBox.getSelectedItem();
        }
        this.fillForm(string, string2, string3, string4, string5, string6);
        this.tableEditFlag = false;
    }

    private void fillForm(String string, String string2, String string3, String string4, String string5, String string6) {
        this._inputTable.selectAll();
        this._inputTable.deleteRow();
        int n = this._variableList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            MCOutputPanel mCOutputPanel = this;
            if (!mCOutputPanel.passesFilter(mCOutputPanel._variableList.get(i).isActive(), string)) continue;
            MCOutputPanel mCOutputPanel2 = this;
            if (!mCOutputPanel2.passesFilter(mCOutputPanel2._alt.getSystem().getNameForKeyString(this._variableList.get(i).getProxyName()), string2)) continue;
            MCOutputPanel mCOutputPanel3 = this;
            if (!mCOutputPanel3.passesFilter(RssModelVariableSet.getParamName((int)mCOutputPanel3._variableList.get(i).getModelVariableId()), string3)) continue;
            MCOutputPanel mCOutputPanel4 = this;
            if (!mCOutputPanel4.passesFilter(mCOutputPanel4._variableList.get(i).getStatistic(), string4)) continue;
            MCOutputPanel mCOutputPanel5 = this;
            if (!mCOutputPanel5.passesFilter(mCOutputPanel5._variableList.get(i).hasTest(), string5)) continue;
            MCOutputPanel mCOutputPanel6 = this;
            if (!mCOutputPanel6.passesFilter(mCOutputPanel6._variableList.get(i).hasConv(), string6)) continue;
            this.addRow(n2, this._variableList.get(i));
            ++n2;
        }
    }

    private boolean passesFilter(Boolean bl, String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        if (string.toLowerCase().contains("active")) {
            return bl.equals(string.equals("Active"));
        }
        if (string.toLowerCase().contains("flag")) {
            return bl.equals(string.equals("Flagged"));
        }
        if (string.toLowerCase().contains("converge")) {
            return bl.equals(string.equals("Convergence"));
        }
        return false;
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public void clear() {
        this._clearing = true;
        try {
            this._inputTable.selectAll();
            this._inputTable.deleteRow();
            this._variableList = new ArrayList<MCOutputVariable>();
            return;
        }
        finally {
            this._clearing = false;
        }
    }

    private void addActionListeners() {
        this._add.addActionListener(new MCOutputPanel$2(this));
        this._remove.addActionListener(new MCOutputPanel$3(this));
        this._editButtons.addActionListener(new MCOutputPanel$4(this));
        this._isActiveCheckbox.addActionListener(new MCOutputPanel$5(this));
        this._testCheckbox.addActionListener(new MCOutputPanel$6(this));
        this._testComboBox.addItemListener(new MCOutputPanel$7(this));
        this._thresholdField.addCellEditorListener((CellEditorListener)new MCOutputPanel$8(this));
        this._convergenceCheckbox.addActionListener(new MCOutputPanel$9(this));
        this._confidenceField.addCellEditorListener((CellEditorListener)new MCOutputPanel$10(this));
        this._toleranceField.addCellEditorListener((CellEditorListener)new MCOutputPanel$11(this));
        this._inputTable.getModel().addTableModelListener(new MCOutputPanel$12(this));
        this._inputTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.tableRowSelected());
    }

    private void tableRowSelected() {
        int n = this._inputTable.getSelectedRow();
        this._remove.setEnabled(n >= 0);
    }

    private void editLocationComboBox() {
        String string = (String)this._locationComboBox.getSelectedItem();
        this._locationComboBox.removeAllItems();
        this._locationComboBox.addItem((Object)"");
        for (int i = 0; i < this._inputTable.getColumnCount(); ++i) {
            if (!this._inputTable.getModel().getColumnName(i).equals("Location")) continue;
            for (int j = 0; j < this._inputTable.getRowCount(); ++j) {
                String string2;
                String string3 = (String)this._inputTable.getModel().getValueAt(j, i);
                int n = this._locationComboBox.getModel().getSize();
                for (int k = 0; k < n && (!string3.equals(string2 = (String)this._locationComboBox.getModel().getElementAt(k)) || string3.isEmpty()); ++k) {
                    int n2;
                    if (k != n - 1 || string3.isEmpty()) continue;
                    int n3 = this._locationComboBox.getItemCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((String)this._locationComboBox.getItemAt(n2)).compareTo(string3) <= 0) continue;
                        this._locationComboBox.insertItemAt((Object)string3, n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    this._locationComboBox.insertItemAt((Object)string3, n2);
                }
            }
        }
        this._locationComboBox.setSelectedItem((Object)string);
    }

    private void editParameterComboBox() {
        String string = (String)this._parameterComboBox.getSelectedItem();
        this._parameterComboBox.removeAllItems();
        this._parameterComboBox.addItem((Object)"");
        for (int i = 0; i < this._inputTable.getColumnCount(); ++i) {
            if (!this._inputTable.getModel().getColumnName(i).equals("Parameter")) continue;
            for (int j = 0; j < this._inputTable.getRowCount(); ++j) {
                String string2;
                String string3 = (String)this._inputTable.getModel().getValueAt(j, i);
                int n = this._parameterComboBox.getModel().getSize();
                for (int k = 0; k < n && (!string3.equals(string2 = (String)this._parameterComboBox.getModel().getElementAt(k)) || string3.isEmpty()); ++k) {
                    int n2;
                    if (k != n - 1 || string3.isEmpty()) continue;
                    int n3 = this._parameterComboBox.getItemCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((String)this._parameterComboBox.getItemAt(n2)).compareTo(string3) <= 0) continue;
                        this._parameterComboBox.insertItemAt((Object)string3, n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    this._parameterComboBox.insertItemAt((Object)string3, n2);
                }
            }
        }
        this._parameterComboBox.setSelectedItem((Object)string);
    }

    private void editStatisticComboBox() {
        String string = (String)this._statisticComboBox.getSelectedItem();
        this._statisticComboBox.removeAllItems();
        this._statisticComboBox.addItem((Object)"");
        for (int i = 0; i < this._inputTable.getColumnCount(); ++i) {
            if (!this._inputTable.getModel().getColumnName(i).equals("Statistic")) continue;
            for (int j = 0; j < this._inputTable.getRowCount(); ++j) {
                String string2;
                String string3 = (String)this._inputTable.getModel().getValueAt(j, i);
                int n = this._statisticComboBox.getModel().getSize();
                for (int k = 0; k < n && (!string3.equals(string2 = (String)this._statisticComboBox.getModel().getElementAt(k)) || string3.isEmpty()); ++k) {
                    int n2;
                    if (k != n - 1 || string3.isEmpty()) continue;
                    int n3 = this._statisticComboBox.getItemCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (((String)this._statisticComboBox.getItemAt(n2)).compareTo(string3) <= 0) continue;
                        this._statisticComboBox.insertItemAt((Object)string3, n2);
                        break;
                    }
                    if (n2 != n3) continue;
                    this._statisticComboBox.insertItemAt((Object)string3, n2);
                }
            }
        }
        this._statisticComboBox.setSelectedItem((Object)string);
    }

    public void addButtonAction() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof AlternativeEditor) {
            window = (AlternativeEditor)window;
            if (this._wizardDlg != null && this._wizardDlg.isVisible()) {
                this._wizardDlg.toFront();
                return;
            }
            this._wizardDlg = new OutputVarWizardDialog((Dialog)window, false, this);
            this._wizardDlg.fillPanels(this._alt, null);
            this._wizardDlg.setVisible(true);
        }
    }

    public void addVariable(int n, MCOutputVariable mCOutputVariable) {
        if (n == -1) {
            if (this._inputTable.getRowCount() == 1) {
                Object object = this._inputTable.getValueAt(0, 1);
                if (object == null) {
                    n = 0;
                } else if (object instanceof String) {
                    if (((String)object).isEmpty() || ((String)object).equals(" ")) {
                        n = 0;
                    } else {
                        this._inputTable.appendRow();
                        n = this._inputTable.getRowCount() - 1;
                    }
                } else {
                    this._inputTable.appendRow();
                    n = this._inputTable.getRowCount() - 1;
                }
            } else {
                this._inputTable.appendRow();
                n = this._inputTable.getRowCount() - 1;
            }
        }
        if (this._variableList.size() != n && (this._variableList.size() > n || this._variableList.get(n) != null)) {
            this._variableList.set(n, mCOutputVariable);
        } else {
            this._variableList.add(n, mCOutputVariable);
        }
        this._inputTable.setValueAt((Object)mCOutputVariable.isActive(), n, 0);
        this._isActiveCheckbox.setSelected(mCOutputVariable.isActive());
        this._inputTable.setValueAt((Object)this._alt.getSystem().getNameForKeyString(mCOutputVariable.getProxyName()), n, 1);
        this._inputTable.setValueAt((Object)RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()), n, 2);
        this._inputTable.setValueAt((Object)mCOutputVariable.getStatistic(), n, 3);
        this._inputTable.setValueAt((Object)mCOutputVariable.hasTest(), n, 4);
        this._inputTable.setValueAt((Object)mCOutputVariable.getTestOp(), n, 5);
        this._inputTable.setValueAt((Object)mCOutputVariable.getTestVal(), n, 6);
        this._inputTable.setValueAt((Object)mCOutputVariable.hasConv(), n, 7);
        this._inputTable.setValueAt((Object)mCOutputVariable.getConfidence(), n, 8);
        this._inputTable.setValueAt((Object)mCOutputVariable.getRelTol(), n, 9);
        this._inputTable.setValueAt((Object)"Edit", n, 10);
        this._inputTable.setColumnEnabled(false, 1);
        this._inputTable.setColumnEnabled(false, 2);
        this._inputTable.setColumnEnabled(false, 3);
    }

    public void addRow(int n, MCOutputVariable mCOutputVariable) {
        if (n == -1) {
            if (this._inputTable.getRowCount() == 1) {
                Object object = this._inputTable.getValueAt(0, 1);
                if (object == null) {
                    n = 0;
                } else if (object instanceof String) {
                    if (((String)object).isEmpty() || ((String)object).equals(" ")) {
                        n = 0;
                    } else {
                        this._inputTable.appendRow();
                        n = this._inputTable.getRowCount() - 1;
                    }
                } else {
                    this._inputTable.appendRow();
                    n = this._inputTable.getRowCount() - 1;
                }
            } else {
                this._inputTable.appendRow();
                n = this._inputTable.getRowCount() - 1;
            }
        }
        this._inputTable.setValueAt((Object)mCOutputVariable.isActive(), n, 0);
        this._isActiveCheckbox.setSelected(mCOutputVariable.isActive());
        this._inputTable.setValueAt((Object)this._alt.getSystem().getNameForKeyString(mCOutputVariable.getProxyName()), n, 1);
        this._inputTable.setValueAt((Object)RssModelVariableSet.getParamName((int)mCOutputVariable.getModelVariableId()), n, 2);
        this._inputTable.setValueAt((Object)mCOutputVariable.getStatistic(), n, 3);
        this._inputTable.setValueAt((Object)mCOutputVariable.hasTest(), n, 4);
        this._inputTable.setValueAt((Object)mCOutputVariable.getTestOp(), n, 5);
        this._inputTable.setValueAt((Object)mCOutputVariable.getTestVal(), n, 6);
        this._inputTable.setValueAt((Object)mCOutputVariable.hasConv(), n, 7);
        this._inputTable.setValueAt((Object)mCOutputVariable.getConfidence(), n, 8);
        this._inputTable.setValueAt((Object)mCOutputVariable.getRelTol(), n, 9);
        this._inputTable.setValueAt((Object)"Edit", n, 10);
        this._inputTable.setColumnEnabled(false, 1);
        this._inputTable.setColumnEnabled(false, 2);
        this._inputTable.setColumnEnabled(false, 3);
    }

    public void removeButtonAction() {
        int n = this._inputTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        this._inputTable.deleteRow();
        this._variableList.remove(n);
    }

    public int getSelectedRow() {
        return this._inputTable.getSelectedRow();
    }

    public void editButtonAction() {
        int n = this._inputTable.getSelectedRow();
        if (this._variableList != null) {
            if (this._variableList.get(n) == null) {
                return;
            }
            Object object = SwingUtilities.windowForComponent((Component)((Object)this));
            if (object instanceof AlternativeEditor) {
                object = (AlternativeEditor)object;
                object = new OutputVarWizardDialog((Dialog)object, true, this);
                ((OutputVarWizardDialog)((Object)object)).fillPanels(this._alt, this._variableList.get(n));
                object.setVisible(true);
            }
        }
        this._inputTable.setModified(true);
    }

    public void isActiveCheckboxAction() {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setActive(this._isActiveCheckbox.isSelected());
    }

    public void testCheckboxAction() {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setTest(this._testCheckbox.isSelected());
    }

    public void testComboBoxAction(String string) {
        int n = this._inputTable.getSelectedRow();
        if (n >= 0) {
            this._variableList.get(n).setTestOp(string);
        }
    }

    public void thresholdFieldAction(ChangeEvent changeEvent) {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setTestVal(Double.parseDouble((String)this._inputTable.getModel().getValueAt(this._inputTable.getSelectedRow(), 6)));
    }

    public void convergenceCheckboxAction() {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setConv(this._convergenceCheckbox.isSelected());
        this.setModified(true);
    }

    public void confidenceFieldAction(ChangeEvent changeEvent) {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setConfidence(Double.parseDouble((String)this._inputTable.getModel().getValueAt(this._inputTable.getSelectedRow(), 8)));
    }

    public void toleranceFieldAction(ChangeEvent changeEvent) {
        int n = this._inputTable.getSelectedRow();
        this._variableList.get(n).setRelTol(Double.parseDouble((String)this._inputTable.getModel().getValueAt(this._inputTable.getSelectedRow(), 9)));
    }

    public void savePanel(MCAltPluginData mCAltPluginData) {
        this._inputTable.commitEdit(true);
        if (mCAltPluginData == null) {
            mCAltPluginData = new MCAltPluginData();
        }
        mCAltPluginData.setOutputVariables(this._variableList);
        this.setModified(false);
    }

    public void fillPanel(MCAltPluginData object, RssAlt rssAlt) {
        this.clear();
        if (this._alt != rssAlt) {
            this._wizardDlgWasVisible = false;
            this._wizardDlg = null;
            this._firstTimeModified = true;
        }
        this._alt = rssAlt;
        if (object == null) {
            return;
        }
        this._variableList = ((MCAltPluginData)((Object)object)).getOutputVariables();
        for (int i = 0; i < this._variableList.size(); ++i) {
            object = this._variableList.get(i);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).isActive(), i, 0);
            this._isActiveCheckbox.setSelected(((MCOutputVariable)object).isActive());
            this._inputTable.setValueAt((Object)this._alt.getSystem().getNameForKeyString(((MCOutputVariable)object).getProxyName()), i, 1);
            this._inputTable.setCellEnabled(false, i, 1);
            this._inputTable.setValueAt((Object)RssModelVariableSet.getParamName((int)((MCOutputVariable)object).getModelVariableId()), i, 2);
            this._inputTable.setCellEnabled(false, i, 2);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getStatistic(), i, 3);
            this._inputTable.setCellEnabled(false, i, 3);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).hasTest(), i, 4);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getTestOp(), i, 5);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getTestVal(), i, 6);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).hasConv(), i, 7);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getConfidence(), i, 8);
            this._inputTable.setValueAt((Object)((MCOutputVariable)object).getRelTol(), i, 9);
            this._inputTable.setValueAt((Object)"Edit", i, 10);
        }
        this.setModified(false);
    }

    public void setAlt(RssAlt rssAlt) {
        this._alt = rssAlt;
    }

    @Override
    public void switchedFrom() {
        if (this._wizardDlg != null && this._wizardDlg.isVisible()) {
            this._wizardDlg.setVisible(false);
            this._wizardDlgWasVisible = true;
            return;
        }
        this._wizardDlgWasVisible = false;
    }

    @Override
    public void switchedTo() {
        if (this._wizardDlgWasVisible && this._wizardDlg != null) {
            this._wizardDlg.setVisible(true);
        }
    }

    public void setModified(boolean bl) {
        if (bl && this._firstTimeModified && !this._clearing) {
            EventQueue.invokeLater(() -> this._parent.tellUserClearSelected("Output"));
            this._firstTimeModified = false;
        }
        super.setModified(bl);
    }
}

